/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.VarImp;
import hex.glm.GLMTask;
import hex.tree.SharedTree;
import hex.tree.xgboost.XGBoostExtension;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.ExtensionManager;
import water.H2O;
import water.Job;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.FileUtils;
import water.util.Log;
import water.util.Timer;

public class XGBoost
extends ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput> {
    public boolean haveMojo() {
        return true;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        if (ExtensionManager.getInstance().isCoreExtensionsEnabled(XGBoostExtension.NAME)) {
            return ModelBuilder.BuilderVisibility.Stable;
        }
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public static DMatrix convertFrametoDMatrix(Key<DataInfo> dataInfoKey, Frame f, String response, String weight, String fold, String[] featureMap, boolean sparse) throws XGBoostError {
        DMatrix trainMat;
        DataInfo di = (DataInfo)dataInfoKey.get();
        if (featureMap != null) {
            String[] coefnames = di.coefNames();
            StringBuilder sb = new StringBuilder();
            assert (coefnames.length == di.fullN());
            for (int i = 0; i < di.fullN(); ++i) {
                sb.append(i).append(" ").append(coefnames[i].replaceAll("\\s*", "")).append(" ");
                int catCols = di._catOffsets[di._catOffsets.length - 1];
                if (i < catCols || f.vec(i - catCols).isBinary()) {
                    sb.append("i");
                } else if (f.vec(i - catCols).isInt()) {
                    sb.append("int");
                } else {
                    sb.append("q");
                }
                sb.append("\n");
            }
            featureMap[0] = sb.toString();
        }
        int nz = 0;
        int actualRows = 0;
        int nRows = (int)f.numRows();
        Vec.Reader w = weight == null ? null : new Vec.Reader(f.vec(weight));
        Vec.Reader[] vecs = new Vec.Reader[f.numCols()];
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = new Vec.Reader(f.vec(i));
        }
        try {
            if (sparse) {
                Log.info((Object[])new Object[]{"Treating matrix as sparse."});
                boolean csc = false;
                if (csc) {
                    class SparseItem {
                        int pos;
                        double val;

                        SparseItem() {
                        }
                    }
                    int nCols = di._nums;
                    List[] col = new List[nCols];
                    for (int i = 0; i < nCols; ++i) {
                        col[i] = new ArrayList(Math.min(nRows, 10000));
                    }
                    int nzCount = 0;
                    for (int i = 0; i < nCols; ++i) {
                        Vec v = f.vec(i);
                        for (int c = 0; c < v.nChunks(); ++c) {
                            Chunk ck = v.chunkForChunkIdx(c);
                            int[] nnz = new int[ck.sparseLenZero()];
                            int nnzCount = ck.nonzeros(nnz);
                            for (int k = 0; k < nnzCount; ++k) {
                                SparseItem item = new SparseItem();
                                int localIdx = nnz[k];
                                item.pos = (int)ck.start() + localIdx;
                                if (w != null && w.at((long)item.pos) == 0.0 || ck.isNA(localIdx)) continue;
                                item.val = ck.atd(localIdx);
                                col[i].add(item);
                                ++nzCount;
                            }
                        }
                    }
                    long[] colHeaders = new long[nCols + 1];
                    float[] data = new float[nzCount];
                    int[] rowIndex = new int[nzCount];
                    for (int i = 0; i < nCols; ++i) {
                        List sparseCol = col[i];
                        colHeaders[i] = nz;
                        for (int j = 0; j < sparseCol.size(); ++j) {
                            SparseItem si = (SparseItem)sparseCol.get(j);
                            rowIndex[nz] = si.pos;
                            data[nz] = (float)si.val;
                            assert (si.val != 0.0);
                            assert (!Double.isNaN(si.val));
                            assert (w == null || w.at((long)si.pos) != 0.0);
                            ++nz;
                        }
                    }
                    colHeaders[nCols] = nz;
                    data = Arrays.copyOf(data, nz);
                    rowIndex = Arrays.copyOf(rowIndex, nz);
                    actualRows = XGBoost.countUnique(rowIndex);
                    trainMat = new DMatrix(colHeaders, rowIndex, data, DMatrix.SparseType.CSC, actualRows);
                    assert (trainMat.rowNum() == (long)actualRows);
                } else {
                    long[] rowHeaders = new long[nRows + 1];
                    int initial_size = 0x100000;
                    float[] data = new float[initial_size];
                    int[] colIndex = new int[initial_size];
                    rowHeaders[0] = 0L;
                    for (int i = 0; i < nRows; ++i) {
                        int j;
                        if (w != null && w.at((long)i) == 0.0) continue;
                        int nzstart = nz;
                        while (data.length < nz + di._cats + di._nums) {
                            int newLen = (int)Math.min((long)data.length << 1, 0x7FFFFFF5L);
                            Log.info((Object[])new Object[]{"Enlarging sparse data structure from " + data.length + " bytes to " + newLen + " bytes."});
                            if (data.length == newLen) {
                                throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
                            }
                            data = Arrays.copyOf(data, newLen);
                            colIndex = Arrays.copyOf(colIndex, newLen);
                        }
                        for (j = 0; j < di._cats; ++j) {
                            if (vecs[j].isNA((long)i)) continue;
                            data[nz] = 1.0f;
                            colIndex[nz] = di.getCategoricalId(j, (double)vecs[j].at8((long)i));
                            ++nz;
                        }
                        for (j = 0; j < di._nums; ++j) {
                            float val = (float)vecs[di._cats + j].at((long)i);
                            if (Float.isNaN(val) || val == 0.0f) continue;
                            data[nz] = val;
                            colIndex[nz] = di._catOffsets[di._catOffsets.length - 1] + j;
                            ++nz;
                        }
                        if (nz == nzstart) {
                            data[nz] = 0.0f;
                            colIndex[nz] = 0;
                            ++nz;
                        }
                        rowHeaders[++actualRows] = nz;
                    }
                    data = Arrays.copyOf(data, nz);
                    colIndex = Arrays.copyOf(colIndex, nz);
                    rowHeaders = Arrays.copyOf(rowHeaders, actualRows + 1);
                    trainMat = new DMatrix(rowHeaders, colIndex, data, DMatrix.SparseType.CSR, di.fullN());
                    assert (trainMat.rowNum() == (long)actualRows);
                }
            } else {
                Log.info((Object[])new Object[]{"Treating matrix as dense."});
                float[] data = new float[0x100000];
                int cols = di.fullN();
                int pos = 0;
                for (int i = 0; i < nRows; ++i) {
                    int j;
                    if (w != null && w.at((long)i) == 0.0) continue;
                    while (data.length < (actualRows + 1) * cols) {
                        int newLen = (int)Math.min((long)data.length << 1, 0x7FFFFFF5L);
                        Log.info((Object[])new Object[]{"Enlarging dense data structure from " + data.length + " bytes to " + newLen + " bytes."});
                        if (data.length == newLen) {
                            throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
                        }
                        data = Arrays.copyOf(data, newLen);
                    }
                    for (j = 0; j < di._cats; ++j) {
                        if (vecs[j].isNA((long)i)) {
                            data[pos + di.getCategoricalId((int)j, (double)Double.NaN)] = 1.0f;
                            continue;
                        }
                        data[pos + di.getCategoricalId((int)j, (double)((double)vecs[j].at8((long)((long)i))))] = 1.0f;
                    }
                    for (j = 0; j < di._nums; ++j) {
                        data[pos + di._catOffsets[di._catOffsets.length - 1] + j] = vecs[di._cats + j].isNA((long)i) ? Float.NaN : (float)vecs[di._cats + j].at((long)i);
                    }
                    assert (di._catOffsets[di._catOffsets.length - 1] + di._nums == cols);
                    pos += cols;
                    ++actualRows;
                }
                data = Arrays.copyOf(data, actualRows * cols);
                trainMat = new DMatrix(data, actualRows, cols, Float.NaN);
                assert (trainMat.rowNum() == (long)actualRows);
            }
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
        }
        float[] weights = new float[actualRows];
        if (w != null) {
            int j = 0;
            for (int i = 0; i < nRows; ++i) {
                if (w.at((long)i) == 0.0) continue;
                weights[j++] = (float)w.at((long)i);
            }
            assert (j == actualRows);
        }
        Vec.Reader respVec = new Vec.Reader(f.vec(response));
        float[] resp = new float[actualRows];
        int j = 0;
        for (int i = 0; i < nRows; ++i) {
            if (w != null && w.at((long)i) == 0.0) continue;
            resp[j++] = (float)respVec.at((long)i);
        }
        assert (j == actualRows);
        resp = Arrays.copyOf(resp, actualRows);
        weights = Arrays.copyOf(weights, actualRows);
        trainMat.setLabel(resp);
        if (w != null) {
            trainMat.setWeight(weights);
        }
        return trainMat;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms, Key<XGBoostModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    public XGBoost(boolean startup_once) {
        super((Model.Parameters)new XGBoostModel.XGBoostParameters(), startup_once);
    }

    public boolean isSupervised() {
        return true;
    }

    protected int nModelsInParallel() {
        return 2;
    }

    protected XGBoostDriver trainModelImpl() {
        return new XGBoostDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive) {
            if (this._response.naCnt() > 0L) {
                this.error("_response_column", "Response contains missing values (NAs) - not supported by XGBoost.");
            }
            if (!ExtensionManager.getInstance().isCoreExtensionEnabled(XGBoostExtension.NAME)) {
                this.error("XGBoost", "XGBoost is not available!");
            }
        }
        if (expensive) {
            if (this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
            }
            if (this.hasOffsetCol()) {
                this.error("_offset_column", "Offset is not supported for XGBoost.");
            }
        }
        if (H2O.CLOUD.size() > 1) {
            throw new IllegalArgumentException("XGBoost is currently only supported in single-node mode.");
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._backend == XGBoostModel.XGBoostParameters.Backend.gpu && !XGBoost.hasGPU(((XGBoostModel.XGBoostParameters)this._parms)._gpu_id)) {
            this.error("_backend", "GPU backend (gpu_id: " + ((XGBoostModel.XGBoostParameters)this._parms)._gpu_id + ") is not functional. Check CUDA_PATH and/or GPU installation.");
        }
        switch (((XGBoostModel.XGBoostParameters)this._parms)._distribution) {
            case bernoulli: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical"));
                break;
            }
            case modified_huber: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Modified Huber requires the response to be a 2-class categorical."));
                break;
            }
            case multinomial: {
                if (this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Multinomial requires an categorical response."));
                break;
            }
            case huber: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Huber requires the response to be numeric."));
                break;
            }
            case poisson: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Poisson requires the response to be numeric."));
                break;
            }
            case gamma: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                break;
            }
            case tweedie: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                break;
            }
            case gaussian: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gaussian requires the response to be numeric."));
                break;
            }
            case laplace: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Laplace requires the response to be numeric."));
                break;
            }
            case quantile: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Quantile requires the response to be numeric."));
                break;
            }
            case AUTO: {
                break;
            }
            default: {
                this.error("_distribution", "Invalid distribution: " + ((XGBoostModel.XGBoostParameters)this._parms)._distribution);
            }
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._learn_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._learn_rate <= 1.0)) {
            this.error("_learn_rate", "learn_rate must be between 0 and 1");
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate <= 1.0)) {
            this.error("_col_sample_rate", "col_sample_rate must be between 0 and 1");
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._grow_policy == XGBoostModel.XGBoostParameters.GrowPolicy.lossguide && ((XGBoostModel.XGBoostParameters)this._parms)._tree_method != XGBoostModel.XGBoostParameters.TreeMethod.hist) {
            this.error("_grow_policy", "must use tree_method=hist for grow_policy=lossguide");
        }
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, XGBoostModel.XGBoostParameters parms, int nClasses) {
        DataInfo dinfo = new DataInfo(train, valid, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip, false, true, parms._weights_column != null, parms._offset_column != null, parms._fold_column != null);
        GLMTask.YMUTask ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(dinfo, nClasses, nClasses == 1, parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip, true, true).doAll(dinfo._adaptedFrame);
        if (ymt.wsum() == 0.0 && parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip) {
            throw new H2OIllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or set missing_values_handling to 'MeanImputation'.");
        }
        if (parms._weights_column != null && parms._offset_column != null) {
            Log.warn((Object[])new Object[]{"Combination of offset and weights can lead to slight differences because Rollupstats aren't weighted - need to re-calculate weighted mean/sigma of the response including offset terms."});
        }
        if (parms._weights_column != null && parms._offset_column == null) {
            dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
            if (nClasses == 1) {
                dinfo.updateWeightedSigmaAndMeanForResponse(ymt.responseSDs(), ymt.responseMeans());
            }
        }
        return dinfo;
    }

    private double effective_learning_rate(XGBoostModel model) {
        return ((XGBoostModel.XGBoostParameters)this._parms)._learn_rate * Math.pow(((XGBoostModel.XGBoostParameters)this._parms)._learn_rate_annealing, ((XGBoostOutput)model._output)._ntrees - 1);
    }

    static boolean hasGPU(int gpu_id) {
        DMatrix trainMat = null;
        try {
            trainMat = new DMatrix(new float[]{1.0f, 2.0f, 1.0f, 2.0f}, 2, 2);
            trainMat.setLabel(new float[]{1.0f, 0.0f});
        }
        catch (XGBoostError xgBoostError) {
            xgBoostError.printStackTrace();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("updater", "grow_gpu_hist");
        params.put("silent", 1);
        params.put("gpu_id", gpu_id);
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        try {
            ml.dmlc.xgboost4j.java.XGBoost.train((DMatrix)trainMat, params, (int)1, watches, null, null);
            return true;
        }
        catch (XGBoostError xgBoostError) {
            return false;
        }
    }

    public static int countUnique(int[] unsortedArray) {
        if (unsortedArray.length == 0) {
            return 0;
        }
        int[] array = Arrays.copyOf(unsortedArray, unsortedArray.length);
        Arrays.sort(array);
        int count = 1;
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] == array[i + 1]) continue;
            ++count;
        }
        return count;
    }

    private class XGBoostDriver
    extends ModelBuilder.Driver {
        private static final String FEATURE_MAP_FILENAME = "featureMap.txt";
        long _firstScore;
        long _timeLastScoreStart;
        long _timeLastScoreEnd;

        private XGBoostDriver() {
            super((ModelBuilder)XGBoost.this);
            this._firstScore = 0L;
            this._timeLastScoreStart = 0L;
            this._timeLastScoreEnd = 0L;
        }

        public void computeImpl() {
            XGBoost.this.init(true);
            long cs = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).checksum();
            if (XGBoost.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)XGBoost.this);
            }
            this.buildModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void buildModel() {
            XGBoostModel model = new XGBoostModel((Key<XGBoostModel>)XGBoost.this._result, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, new XGBoostOutput(XGBoost.this), XGBoost.this._train, XGBoost.this._valid);
            model.write_lock(XGBoost.this._job);
            String[] featureMap = new String[]{""};
            if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.sparse) {
                ((XGBoostOutput)model._output)._sparse = true;
            } else if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.dense) {
                ((XGBoostOutput)model._output)._sparse = false;
            } else {
                float fillRatio = 0.0f;
                int col = 0;
                for (int i = 0; i < XGBoost.this._train.numCols(); ++i) {
                    if (XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._response_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._weights_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._fold_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._offset_column)) continue;
                    fillRatio += (float)(XGBoost.this._train.vec(i).nzCnt() / XGBoost.this._train.numRows());
                    ++col;
                }
                Log.info((Object[])new Object[]{"fill ratio: " + (fillRatio /= (float)col)});
                ((XGBoostOutput)model._output)._sparse = (double)fillRatio < 0.5 || XGBoost.this._train.numRows() * (long)XGBoost.this._train.numCols() > Integer.MAX_VALUE;
            }
            try {
                DMatrix trainMat = XGBoost.convertFrametoDMatrix(model.model_info()._dataInfoKey, XGBoost.this._train, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._response_column, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._weights_column, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._fold_column, featureMap, ((XGBoostOutput)model._output)._sparse);
                DMatrix validMat = XGBoost.this._valid != null ? XGBoost.convertFrametoDMatrix(model.model_info()._dataInfoKey, XGBoost.this._valid, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._response_column, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._weights_column, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._fold_column, featureMap, ((XGBoostOutput)model._output)._sparse) : null;
                FileOutputStream os = null;
                File tmpModelDir = null;
                try {
                    tmpModelDir = Files.createTempDirectory("xgboost-model-" + XGBoost.this._result.toString(), new FileAttribute[0]).toFile();
                    os = new FileOutputStream(new File(tmpModelDir, FEATURE_MAP_FILENAME));
                    ((OutputStream)os).write(featureMap[0].getBytes());
                }
                catch (IOException e) {
                    try {
                        H2O.fail((String)"Cannot generate featureMap.txt", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.close((Closeable[])new Closeable[]{os});
                        throw throwable;
                    }
                    FileUtils.close((Closeable[])new Closeable[]{os});
                }
                FileUtils.close((Closeable[])new Closeable[]{os});
                HashMap watches = new HashMap();
                model.model_info().setBooster(ml.dmlc.xgboost4j.java.XGBoost.train((DMatrix)trainMat, model.createParams(), (int)0, watches, null, null));
                this.scoreAndBuildTrees(model, trainMat, validMat, tmpModelDir);
                this.doScoring(model, model.model_info().booster(), trainMat, validMat, true, tmpModelDir);
                model.model_info().nativeToJava();
            }
            catch (XGBoostError xgBoostError) {
                xgBoostError.printStackTrace();
                H2O.fail((String)"XGBoost failure", (Throwable)xgBoostError);
            }
            ((XGBoostOutput)model._output)._boosterBytes = model.model_info()._boosterBytes;
            model.unlock(XGBoost.this._job);
        }

        protected final void scoreAndBuildTrees(XGBoostModel model, DMatrix trainMat, DMatrix validMat, File tmpModelDir) throws XGBoostError {
            for (int tid = 0; tid < ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees; ++tid) {
                boolean scored = this.doScoring(model, model.model_info().booster(), trainMat, validMat, false, tmpModelDir);
                if (scored && ScoreKeeper.stopEarly((ScoreKeeper[])((XGBoostOutput)model._output).scoreKeepers(), (int)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_rounds, (XGBoost.this._nclass > 1 ? 1 : 0) != 0, (ScoreKeeper.StoppingMetric)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_metric, (double)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_tolerance, (String)"model's last", (boolean)true)) {
                    this.doScoring(model, model.model_info().booster(), trainMat, validMat, true, tmpModelDir);
                    XGBoost.this._job.update((long)(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees - ((XGBoostOutput)model._output)._ntrees));
                    return;
                }
                Timer kb_timer = new Timer();
                try {
                    model.model_info().booster().update(trainMat, tid);
                }
                catch (XGBoostError xgBoostError) {
                    xgBoostError.printStackTrace();
                }
                Log.info((Object[])new Object[]{tid + 1 + ". tree was built in " + kb_timer.toString()});
                XGBoost.this._job.update(1L);
                ++((XGBoostOutput)model._output)._ntrees;
                ((XGBoostOutput)model._output)._scored_train = (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_train, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper());
                ((XGBoostOutput)model._output)._scored_valid = ((XGBoostOutput)model._output)._scored_valid != null ? (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_valid, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper()) : null;
                ((XGBoostOutput)model._output)._training_time_ms = ArrayUtils.copyAndFillOf((long[])((XGBoostOutput)model._output)._training_time_ms, (int)(((XGBoostOutput)model._output)._ntrees + 1), (long)System.currentTimeMillis());
                if (XGBoost.this.stop_requested() && !XGBoost.this.timeout()) {
                    throw new Job.JobCancelledException();
                }
                if (!XGBoost.this.timeout()) continue;
                if (!scored) {
                    this.doScoring(model, model.model_info().booster(), trainMat, validMat, true, tmpModelDir);
                }
                XGBoost.this._job.update((long)(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees - ((XGBoostOutput)model._output)._ntrees));
                break;
            }
            this.doScoring(model, model.model_info().booster(), trainMat, validMat, true, tmpModelDir);
        }

        private boolean doScoring(XGBoostModel model, Booster booster, DMatrix trainMat, DMatrix validMat, boolean finalScoring, File tmpModelDir) throws XGBoostError {
            boolean manualInterval;
            boolean scored = false;
            long now = System.currentTimeMillis();
            if (this._firstScore == 0L) {
                this._firstScore = now;
            }
            long sinceLastScore = now - this._timeLastScoreStart;
            XGBoost.this._job.update(0L, "Built " + ((XGBoostOutput)model._output)._ntrees + " trees so far (out of " + ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees + ").");
            boolean timeToScore = now - this._firstScore < (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._initial_score_interval || sinceLastScore > (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_interval && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1;
            boolean bl = manualInterval = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval > 0 && ((XGBoostOutput)model._output)._ntrees % ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0;
            if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_each_iteration || finalScoring || timeToScore && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0 || manualInterval) {
                this._timeLastScoreStart = now;
                model.doScoring(booster, trainMat, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).train(), validMat, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).valid());
                this._timeLastScoreEnd = System.currentTimeMillis();
                model.computeVarImp(booster.getFeatureScore(new File(tmpModelDir, FEATURE_MAP_FILENAME).getAbsolutePath()));
                XGBoostOutput out = (XGBoostOutput)model._output;
                out._model_summary = SharedTree.createModelSummaryTable((int)out._ntrees, null);
                out._scoring_history = SharedTree.createScoringHistoryTable((Model.Output)out, (ScoreKeeper[])((XGBoostOutput)model._output)._scored_train, (ScoreKeeper[])out._scored_valid, (Job)XGBoost.this._job, (long[])out._training_time_ms, (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._custom_metric_func != null ? 1 : 0) != 0);
                out._variable_importances = ModelMetrics.calcVarImp((VarImp)out._varimp);
                model.update(XGBoost.this._job);
                Log.info((Object[])new Object[]{model});
                scored = true;
            }
            return scored;
        }
    }
}

