/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import java.io.IOException;
import ml.dmlc.xgboost4j.java.NativeLibLoader;
import water.AbstractH2OExtension;
import water.H2O;
import water.util.Log;

public class XGBoostExtension
extends AbstractH2OExtension {
    private static String XGBOOST_MIN_REQUIREMENTS = "Xgboost (enabled GPUs) needs: \n  - CUDA 8.0\nXGboost (minimal version) needs: \n  - GCC 4.7+\nFor more details, run in debug mode: `java -Dlog4j.configuration=file:///tmp/log4j.properties -jar h2o.jar`\n";
    private boolean isInitCalled = false;
    private boolean isXgboostPresent = false;
    public static String NAME = "XGBoost";

    public String getExtensionName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        if (H2O.getCloudSize() > 1) {
            Log.warn((Object[])new Object[]{"Detected more than 1 H2O node. H2O only supports XGBoost in single node setting."});
            return false;
        }
        if (!this.isInitCalled) {
            XGBoostExtension xGBoostExtension = this;
            synchronized (xGBoostExtension) {
                if (!this.isInitCalled) {
                    this.isXgboostPresent = this.initXgboost();
                    this.isInitCalled = true;
                }
            }
        }
        return this.isXgboostPresent;
    }

    private final boolean initXgboost() {
        try {
            String libName = NativeLibLoader.getLoadedLibraryName();
            if (libName != null) {
                Log.info((Object[])new Object[]{"Found XGBoost backend with library: " + libName});
                String suffix = NativeLibLoader.getLoadedLibrarySuffix();
                if (suffix.equals("")) {
                    Log.warn((Object[])new Object[]{"Your system supports only minimal version of XGBoost (no GPUs, no multithreading)!"});
                }
                return true;
            }
            Log.warn((Object[])new Object[]{"Cannot get XGBoost backend!" + XGBOOST_MIN_REQUIREMENTS});
            return false;
        }
        catch (IOException e) {
            Log.warn((Object[])new Object[]{"Cannot initialize XGBoost backend! " + XGBOOST_MIN_REQUIREMENTS});
            return false;
        }
    }
}

