/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.VarImp;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLMTask;
import hex.tree.SharedTree;
import hex.tree.xgboost.XGBoostExtension;
import hex.tree.xgboost.XGBoostExtensionCheck;
import hex.tree.xgboost.XGBoostGPULock;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.rabit.RabitTrackerH2O;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.IRabitTracker;
import ml.dmlc.xgboost4j.java.Rabit;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostUpdateTask;
import water.ExtensionManager;
import water.H2O;
import water.H2ONode;
import water.Job;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.Timer;

public class XGBoost
extends ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput> {
    private static Set<Integer> GPUS = new HashSet<Integer>();

    public boolean haveMojo() {
        return true;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        if (ExtensionManager.getInstance().isCoreExtensionsEnabled(XGBoostExtension.NAME)) {
            return ModelBuilder.BuilderVisibility.Stable;
        }
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms, Key<XGBoostModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    public XGBoost(boolean startup_once) {
        super((Model.Parameters)new XGBoostModel.XGBoostParameters(), startup_once);
    }

    public boolean isSupervised() {
        return true;
    }

    protected int nModelsInParallel() {
        return 2;
    }

    protected XGBoostDriver trainModelImpl() {
        return new XGBoostDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (H2O.CLOUD.size() > 1 && H2O.SELF.getSecurityManager().securityEnabled) {
            throw new H2OIllegalArgumentException("Cannot run XGBoost on an SSL enabled cluster larger than 1 node. XGBoost does not support SSL encryption.");
        }
        if (expensive) {
            if (this._response.naCnt() > 0L) {
                this.error("_response_column", "Response contains missing values (NAs) - not supported by XGBoost.");
            }
            if (!((XGBoostExtensionCheck)new XGBoostExtensionCheck().doAllNodes()).enabled) {
                this.error("XGBoost", "XGBoost is not available on all nodes!");
            }
        }
        if (expensive) {
            if (this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
            }
            if (this.hasOffsetCol()) {
                this.error("_offset_column", "Offset is not supported for XGBoost.");
            }
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._backend == XGBoostModel.XGBoostParameters.Backend.gpu) {
            Map<String, Object> incompats;
            if (!XGBoost.hasGPU(((XGBoostModel.XGBoostParameters)this._parms)._gpu_id)) {
                this.error("_backend", "GPU backend (gpu_id: " + ((XGBoostModel.XGBoostParameters)this._parms)._gpu_id + ") is not functional. Check CUDA_PATH and/or GPU installation.");
            }
            if (H2O.getCloudSize() > 1) {
                this.error("_backend", "GPU backend is not supported in distributed mode.");
            }
            if (!(incompats = ((XGBoostModel.XGBoostParameters)this._parms).gpuIncompatibleParams()).isEmpty()) {
                for (Map.Entry<String, Object> incompat : incompats.entrySet()) {
                    this.error("_backend", "GPU backend is not available for parameter setting '" + incompat.getKey() + " = " + incompat.getValue() + "'. Use CPU backend instead.");
                }
            }
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            this.error("_distribution", "Quasibinomial is not supported for XGBoost in current H2O.");
        }
        switch (((XGBoostModel.XGBoostParameters)this._parms)._distribution) {
            case bernoulli: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical"));
                break;
            }
            case modified_huber: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Modified Huber requires the response to be a 2-class categorical."));
                break;
            }
            case multinomial: {
                if (this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Multinomial requires an categorical response."));
                break;
            }
            case huber: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Huber requires the response to be numeric."));
                break;
            }
            case poisson: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Poisson requires the response to be numeric."));
                break;
            }
            case gamma: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                break;
            }
            case tweedie: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                break;
            }
            case gaussian: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gaussian requires the response to be numeric."));
                break;
            }
            case laplace: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Laplace requires the response to be numeric."));
                break;
            }
            case quantile: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Quantile requires the response to be numeric."));
                break;
            }
            case AUTO: {
                break;
            }
            default: {
                this.error("_distribution", "Invalid distribution: " + ((XGBoostModel.XGBoostParameters)this._parms)._distribution);
            }
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._learn_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._learn_rate <= 1.0)) {
            this.error("_learn_rate", "learn_rate must be between 0 and 1");
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate <= 1.0)) {
            this.error("_col_sample_rate", "col_sample_rate must be between 0 and 1");
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._grow_policy == XGBoostModel.XGBoostParameters.GrowPolicy.lossguide && ((XGBoostModel.XGBoostParameters)this._parms)._tree_method != XGBoostModel.XGBoostParameters.TreeMethod.hist) {
            this.error("_grow_policy", "must use tree_method=hist for grow_policy=lossguide");
        }
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, XGBoostModel.XGBoostParameters parms, int nClasses) {
        DataInfo dinfo = new DataInfo(train, valid, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip, false, true, parms._weights_column != null, parms._offset_column != null, parms._fold_column != null);
        GLMTask.YMUTask ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(dinfo, nClasses, nClasses == 1, parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip, true, true).doAll(dinfo._adaptedFrame);
        if (ymt.wsum() == 0.0 && parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip) {
            throw new H2OIllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or set missing_values_handling to 'MeanImputation'.");
        }
        if (parms._weights_column != null && parms._offset_column != null) {
            Log.warn((Object[])new Object[]{"Combination of offset and weights can lead to slight differences because Rollupstats aren't weighted - need to re-calculate weighted mean/sigma of the response including offset terms."});
        }
        if (parms._weights_column != null && parms._offset_column == null) {
            dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
            if (nClasses == 1) {
                dinfo.updateWeightedSigmaAndMeanForResponse(ymt.responseSDs(), ymt.responseMeans());
            }
        }
        return dinfo;
    }

    public static byte[] getRawArray(Booster booster) {
        byte[] rawBooster;
        if (null == booster) {
            return null;
        }
        try {
            HashMap localRabitEnv = new HashMap();
            Rabit.init(localRabitEnv);
            rawBooster = booster.toByteArray();
            Rabit.shutdown();
        }
        catch (XGBoostError xgBoostError) {
            throw new IllegalStateException("Failed to initialize Rabit or serialize the booster.", xgBoostError);
        }
        return rawBooster;
    }

    private double effective_learning_rate(XGBoostModel model) {
        return ((XGBoostModel.XGBoostParameters)this._parms)._learn_rate * Math.pow(((XGBoostModel.XGBoostParameters)this._parms)._learn_rate_annealing, ((XGBoostOutput)model._output)._ntrees - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static synchronized boolean hasGPU(int gpu_id) {
        if (!XGBoostExtension.isGpuSupportEnabled()) {
            return false;
        }
        if (GPUS.contains(gpu_id)) {
            return true;
        }
        DMatrix trainMat = null;
        try {
            trainMat = new DMatrix(new float[]{1.0f, 2.0f, 1.0f, 2.0f}, 2, 2);
            trainMat.setLabel(new float[]{1.0f, 0.0f});
        }
        catch (XGBoostError xgBoostError) {
            throw new IllegalStateException("Couldn't prepare training matrix for XGBoost.", xgBoostError);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("updater", "grow_gpu_hist");
        params.put("silent", 1);
        params.put("gpu_id", gpu_id);
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        HashMap localRabitEnv = new HashMap();
        Rabit.init(localRabitEnv);
        ml.dmlc.xgboost4j.java.XGBoost.train((DMatrix)trainMat, params, (int)1, watches, null, null);
        GPUS.add(gpu_id);
        boolean bl = true;
        try {
            Rabit.shutdown();
        }
        catch (XGBoostError e) {
            Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
        }
        return bl;
        catch (XGBoostError xgBoostError) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    Rabit.shutdown();
                }
                catch (XGBoostError e) {
                    Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
                }
                throw throwable;
            }
            try {
                Rabit.shutdown();
            }
            catch (XGBoostError e) {
                Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
            }
            return bl2;
        }
    }

    class XGBoostDriver
    extends ModelBuilder.Driver {
        private final String featureMapFileName;
        private File featureMapFile;
        long _firstScore;
        long _timeLastScoreStart;
        long _timeLastScoreEnd;

        XGBoostDriver() {
            super((ModelBuilder)XGBoost.this);
            this.featureMapFileName = "featureMap" + UUID.randomUUID().toString() + ".txt";
            this.featureMapFile = null;
            this._firstScore = 0L;
            this._timeLastScoreStart = 0L;
            this._timeLastScoreEnd = 0L;
        }

        public void computeImpl() {
            XGBoost.this.init(true);
            if (XGBoost.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)XGBoost.this);
            }
            this.buildModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void buildModel() {
            if ((XGBoostModel.XGBoostParameters.Backend.auto.equals((Object)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._backend) || XGBoostModel.XGBoostParameters.Backend.gpu.equals((Object)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._backend)) && XGBoost.hasGPU(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._gpu_id) && H2O.getCloudSize() == 1 && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).gpuIncompatibleParams().isEmpty()) {
                XGBoostGPULock xGBoostGPULock = XGBoostGPULock.lock(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._gpu_id);
                synchronized (xGBoostGPULock) {
                    this.buildModelImpl();
                }
            } else {
                this.buildModelImpl();
            }
        }

        final void buildModelImpl() {
            XGBoostModel model = new XGBoostModel((Key<XGBoostModel>)XGBoost.this._result, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, new XGBoostOutput(XGBoost.this), XGBoost.this._train, XGBoost.this._valid);
            model.write_lock(XGBoost.this._job);
            if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.sparse) {
                ((XGBoostOutput)model._output)._sparse = true;
            } else if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.dense) {
                ((XGBoostOutput)model._output)._sparse = false;
            } else {
                float fillRatio = 0.0f;
                int col = 0;
                for (int i = 0; i < XGBoost.this._train.numCols(); ++i) {
                    if (XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._response_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._weights_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._fold_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._offset_column)) continue;
                    fillRatio += (float)(XGBoost.this._train.vec(i).nzCnt() / XGBoost.this._train.numRows());
                    ++col;
                }
                Log.info((Object[])new Object[]{"fill ratio: " + (fillRatio /= (float)col)});
                ((XGBoostOutput)model._output)._sparse = (double)fillRatio < 0.5 || XGBoost.this._train.numRows() * (long)XGBoost.this._train.numCols() > Integer.MAX_VALUE;
            }
            RabitTrackerH2O rt = null;
            try {
                this.featureMapFile = this.createFeatureMapFile();
                HashSet<H2ONode> nodesHoldingFrame = new HashSet<H2ONode>();
                Vec vec = XGBoost.this.train().anyVec();
                for (int chunkNr = 0; chunkNr < vec.nChunks(); ++chunkNr) {
                    nodesHoldingFrame.add(vec.chunkKey(chunkNr).home_node());
                }
                rt = new RabitTrackerH2O(nodesHoldingFrame.size());
                if (!this.startRabitTracker(rt)) {
                    throw new IllegalArgumentException("Cannot start XGboost rabit tracker, please, make sure you have python installed!");
                }
                try {
                    model.model_info().setBooster(((XGBoostUpdateTask)new XGBoostUpdateTask(model.model_info().getBooster(), model.model_info(), (XGBoostOutput)model._output, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, 0, this.getWorkerEnvs(rt), new String[]{""}).doAll(XGBoost.this._train)).getBooster(this.featureMapFile));
                    this.waitOnRabitWorkers(rt);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                finally {
                    rt.stop();
                }
                this.scoreAndBuildTrees(model, rt);
                model.model_info().nativeToJava();
                ((XGBoostOutput)model._output)._boosterBytes = model.model_info()._boosterBytes;
            }
            catch (XGBoostError xgBoostError) {
                xgBoostError.printStackTrace();
                throw new RuntimeException("XGBoost failure", xgBoostError);
            }
            finally {
                model.unlock(XGBoost.this._job);
            }
        }

        private File createFeatureMapFile() {
            File tmpModelDir = null;
            try {
                tmpModelDir = Files.createTempDirectory("xgboost-model-" + XGBoost.this._result.toString(), new FileAttribute[0]).toFile();
                return new File(tmpModelDir, this.featureMapFileName);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot generate temporary directory for feature map file", e);
            }
        }

        protected final void scoreAndBuildTrees(XGBoostModel model, IRabitTracker rt) throws XGBoostError {
            for (int tid = 0; tid < ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees; ++tid) {
                boolean scored = this.doScoring(model, model.model_info().getBooster(), false);
                if (scored && ScoreKeeper.stopEarly((ScoreKeeper[])((XGBoostOutput)model._output).scoreKeepers(), (int)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_rounds, (XGBoost.this._nclass > 1 ? 1 : 0) != 0, (ScoreKeeper.StoppingMetric)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_metric, (double)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_tolerance, (String)"model's last", (boolean)true)) {
                    this.doScoring(model, model.model_info().getBooster(), true);
                    XGBoost.this._job.update((long)(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees - ((XGBoostOutput)model._output)._ntrees));
                    return;
                }
                Timer kb_timer = new Timer();
                this.startRabitTracker(rt);
                try {
                    model.model_info().setBooster(((XGBoostUpdateTask)new XGBoostUpdateTask(model.model_info().getBooster(), model.model_info(), (XGBoostOutput)model._output, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, tid, this.getWorkerEnvs(rt), null).doAll(XGBoost.this._train)).getBooster());
                    this.waitOnRabitWorkers(rt);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                finally {
                    rt.stop();
                }
                Log.info((Object[])new Object[]{tid + 1 + ". tree was built in " + kb_timer.toString()});
                XGBoost.this._job.update(1L);
                ++((XGBoostOutput)model._output)._ntrees;
                ((XGBoostOutput)model._output)._scored_train = (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_train, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper());
                ((XGBoostOutput)model._output)._scored_valid = ((XGBoostOutput)model._output)._scored_valid != null ? (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_valid, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper()) : null;
                ((XGBoostOutput)model._output)._training_time_ms = ArrayUtils.copyAndFillOf((long[])((XGBoostOutput)model._output)._training_time_ms, (int)(((XGBoostOutput)model._output)._ntrees + 1), (long)System.currentTimeMillis());
                if (XGBoost.this.stop_requested() && !XGBoost.this.timeout()) {
                    throw new Job.JobCancelledException();
                }
                if (!XGBoost.this.timeout()) continue;
                if (!scored) {
                    this.doScoring(model, model.model_info().getBooster(), true);
                }
                XGBoost.this._job.update((long)(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees - ((XGBoostOutput)model._output)._ntrees));
                break;
            }
            this.doScoring(model, model.model_info().getBooster(), true);
        }

        private boolean startRabitTracker(IRabitTracker rt) {
            if (H2O.CLOUD.size() > 1) {
                return rt.start(0L);
            }
            return true;
        }

        private void waitOnRabitWorkers(IRabitTracker rt) {
            if (H2O.CLOUD.size() > 1) {
                rt.waitFor(0L);
            }
        }

        private Map<String, String> getWorkerEnvs(IRabitTracker rt) {
            if (H2O.CLOUD.size() > 1) {
                return rt.getWorkerEnvs();
            }
            return new HashMap<String, String>();
        }

        private boolean doScoring(XGBoostModel model, Booster booster, boolean finalScoring) throws XGBoostError {
            boolean manualInterval;
            boolean scored = false;
            long now = System.currentTimeMillis();
            if (this._firstScore == 0L) {
                this._firstScore = now;
            }
            long sinceLastScore = now - this._timeLastScoreStart;
            XGBoost.this._job.update(0L, "Built " + ((XGBoostOutput)model._output)._ntrees + " trees so far (out of " + ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees + ").");
            boolean timeToScore = now - this._firstScore < (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._initial_score_interval || sinceLastScore > (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_interval && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1;
            boolean bl = manualInterval = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval > 0 && ((XGBoostOutput)model._output)._ntrees % ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0;
            if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_each_iteration || finalScoring || timeToScore && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0 || manualInterval) {
                this._timeLastScoreStart = now;
                model.doScoring(booster, XGBoost.this._train, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).train(), XGBoost.this._valid, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).valid());
                this._timeLastScoreEnd = System.currentTimeMillis();
                model.computeVarImp(booster.getFeatureScore(this.featureMapFile.getAbsolutePath()));
                XGBoostOutput out = (XGBoostOutput)model._output;
                out._model_summary = SharedTree.createModelSummaryTable((int)out._ntrees, null);
                out._scoring_history = SharedTree.createScoringHistoryTable((Model.Output)out, (ScoreKeeper[])((XGBoostOutput)model._output)._scored_train, (ScoreKeeper[])out._scored_valid, (Job)XGBoost.this._job, (long[])out._training_time_ms, (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._custom_metric_func != null ? 1 : 0) != 0);
                out._variable_importances = ModelMetrics.calcVarImp((VarImp)out._varimp);
                model.update(XGBoost.this._job);
                Log.info((Object[])new Object[]{model});
                scored = true;
            }
            return scored;
        }
    }
}

