/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import hex.DataInfo;
import hex.tree.xgboost.XGBoostModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.BoosterHelper;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.Iced;
import water.Key;
import water.util.TwoDimTable;

public final class XGBoostModelInfo
extends Iced {
    public byte[] _boosterBytes;
    private TwoDimTable summaryTable;
    private transient Booster _booster;
    public Key<DataInfo> _dataInfoKey;
    public XGBoostModel.XGBoostParameters parameters;
    private final boolean _classification;

    public Booster getBooster() {
        if (null == this._booster && null != this._boosterBytes) {
            try {
                this._booster = Booster.loadModel((InputStream)new ByteArrayInputStream(this._boosterBytes));
            }
            catch (IOException | XGBoostError exception) {
                throw new IllegalStateException("Failed to load the booster.", exception);
            }
        }
        return this._booster;
    }

    public void setBooster(Booster _booster) {
        this._booster = _booster;
    }

    public final Booster booster() {
        if (this._booster == null) {
            this._booster = XGBoostModelInfo.javaToNative(this._boosterBytes);
        }
        return this._booster;
    }

    public void nukeBackend() {
        if (this._booster != null) {
            this._booster.dispose();
        }
        this._booster = null;
    }

    public void nativeToJava() {
        try {
            this._boosterBytes = this._booster.toByteArray();
        }
        catch (XGBoostError xgBoostError) {
            xgBoostError.printStackTrace();
            throw new RuntimeException(xgBoostError);
        }
    }

    private static Booster javaToNative(byte[] boosterBytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(boosterBytes);
        try {
            return BoosterHelper.loadModel((InputStream)is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this._boosterBytes);
    }

    public long size() {
        long res = 0L;
        if (this._boosterBytes != null) {
            res += (long)this._boosterBytes.length;
        }
        return res;
    }

    public final XGBoostModel.XGBoostParameters get_params() {
        return this.parameters;
    }

    public XGBoostModelInfo(XGBoostModel.XGBoostParameters origParams, int nClasses) {
        this._classification = nClasses > 1;
        this.parameters = (XGBoostModel.XGBoostParameters)origParams.clone();
    }

    TwoDimTable createSummaryTable() {
        TwoDimTable table = new TwoDimTable("Status of XGBoost Model", "Ha", new String[1], new String[]{"Input Neurons", "Rate", "Momentum"}, new String[]{"int", "double", "double"}, new String[]{"%d", "%5f", "%5f"}, "");
        table.set(0, 0, (Object)123);
        table.set(0, 1, (Object)1234);
        table.set(0, 2, (Object)12345);
        this.summaryTable = table;
        return this.summaryTable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.createSummaryTable();
        if (this.summaryTable != null) {
            sb.append(this.summaryTable.toString(1));
        }
        return sb.toString();
    }
}

