/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.H2O;
import water.Key;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;
import water.util.VecUtils;

public class XGBoostUtils {
    private static final int ARRAY_MAX = 0x7FFFFFF5;

    public static DMatrix convertFrameToDMatrix(Key<DataInfo> dataInfoKey, Frame f, boolean onlyLocal, String response, String weight, String fold, String[] featureMap, boolean sparse) throws XGBoostError {
        DMatrix trainMat;
        int[] chunks;
        Vec vec = f.anyVec();
        if (!onlyLocal) {
            chunks = new int[f.anyVec().nChunks()];
            for (int i = 0; i < chunks.length; ++i) {
                chunks[i] = i;
            }
        } else {
            chunks = VecUtils.getLocalChunkIds((Vec)f.anyVec());
        }
        long nRowsL = 0L;
        for (int chId : chunks) {
            nRowsL += (long)vec.chunkLen(chId);
        }
        if (0L == nRowsL) {
            return null;
        }
        int nRows = (int)nRowsL;
        DataInfo di = (DataInfo)dataInfoKey.get();
        if (featureMap != null) {
            String[] coefnames = di.coefNames();
            StringBuilder sb = new StringBuilder();
            assert (coefnames.length == di.fullN());
            for (int i = 0; i < di.fullN(); ++i) {
                sb.append(i).append(" ").append(coefnames[i].replaceAll("\\s*", "")).append(" ");
                int catCols = di._catOffsets[di._catOffsets.length - 1];
                if (i < catCols || f.vec(i - catCols).isBinary()) {
                    sb.append("i");
                } else if (f.vec(i - catCols).isInt()) {
                    sb.append("int");
                } else {
                    sb.append("q");
                }
                sb.append("\n");
            }
            featureMap[0] = sb.toString();
        }
        Vec.Reader w = weight == null ? null : new Vec.Reader(f.vec(weight));
        Vec.Reader[] vecs = new Vec.Reader[f.numCols()];
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = new Vec.Reader(f.vec(i));
        }
        float[] resp = new float[nRows];
        float[] weights = null;
        if (null != w) {
            weights = new float[nRows];
        }
        try {
            if (sparse) {
                Log.info((Object[])new Object[]{"Treating matrix as sparse."});
                boolean csc = false;
                trainMat = csc ? XGBoostUtils.csc(f, chunks, w, new Vec.Reader(f.vec(response)), nRows, di, resp, weights) : XGBoostUtils.csr(f, chunks, vecs, w, new Vec.Reader(f.vec(response)), nRows, di, resp, weights);
            } else {
                Log.info((Object[])new Object[]{"Treating matrix as dense."});
                int cols = di.fullN();
                float[][] data = new float[XGBoostUtils.getDataRows(chunks, vec, cols)][];
                data[0] = new float[0x100000];
                long actualRows = XGBoostUtils.denseChunk(data, chunks, f, vecs, w, di, cols, resp, weights, new Vec.Reader(f.vec(response)));
                int lastRowSize = (int)(actualRows * (long)cols % 0x7FFFFFF5L);
                if (data[data.length - 1].length > lastRowSize) {
                    data[data.length - 1] = Arrays.copyOf(data[data.length - 1], lastRowSize);
                }
                trainMat = new DMatrix((float[][])data, actualRows, cols, Float.NaN);
                assert (trainMat.rowNum() == actualRows);
            }
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."), e);
        }
        int len = (int)trainMat.rowNum();
        resp = Arrays.copyOf(resp, len);
        trainMat.setLabel(resp);
        if (w != null) {
            weights = Arrays.copyOf(weights, len);
            trainMat.setWeight(weights);
        }
        return trainMat;
    }

    private static int getDataRows(Chunk[] chunks, Frame f, int[] chunksIds, int cols) {
        double totalRows = 0.0;
        if (null != chunks) {
            for (Chunk ch : chunks) {
                totalRows += (double)ch.len();
            }
        } else {
            for (int chunkId : chunksIds) {
                totalRows += (double)f.anyVec().chunkLen(chunkId);
            }
        }
        return (int)Math.ceil(totalRows * (double)cols / 2.147483637E9);
    }

    private static int getDataRows(int[] chunks, Vec vec, int cols) {
        double totalRows = 0.0;
        for (int ch : chunks) {
            totalRows += (double)vec.chunkLen(ch);
        }
        return (int)Math.ceil(totalRows * (double)cols / 2.147483637E9);
    }

    private static int setResponseAndWeight(Chunk[] chunks, int respIdx, int weightIdx, float[] resp, float[] weights, int j, int i) {
        if (weightIdx != -1) {
            if (chunks[weightIdx].atd(i) == 0.0) {
                return j;
            }
            weights[j] = (float)chunks[weightIdx].atd(i);
        }
        resp[j++] = (float)chunks[respIdx].atd(i);
        return j;
    }

    private static int setResponseAndWeight(Vec.Reader w, float[] resp, float[] weights, Vec.Reader respVec, int j, long i) {
        if (w != null) {
            if (w.at(i) == 0.0) {
                return j;
            }
            weights[j] = (float)w.at(i);
        }
        resp[j++] = (float)respVec.at(i);
        return j;
    }

    private static int getNzCount(Frame f, int[] chunks, final Vec.Reader w, int nCols, List<SparseItem>[] col, int nzCount) {
        for (int i = 0; i < nCols; ++i) {
            Vec v = f.vec(i);
            int[] nArray = chunks;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                Integer c = nArray[j];
                Chunk ck = v.chunkForChunkIdx(c.intValue());
                int[] nnz = new int[ck.sparseLenZero()];
                int nnzCount = ck.nonzeros(nnz);
                nzCount = XGBoostUtils.getNzCount(new ZeroWeight(){

                    @Override
                    public boolean zeroWeight(int idx) {
                        return w != null && w.at((long)idx) == 0.0;
                    }
                }, col[i], nzCount, ck, nnz, nnzCount, false);
            }
        }
        return nzCount;
    }

    private static int getNzCount(Chunk[] chunks, final int weight, int nCols, List<SparseItem>[] col, int nzCount) {
        for (int i = 0; i < nCols; ++i) {
            final Chunk ck = chunks[i];
            int[] nnz = new int[ck.sparseLenZero()];
            int nnzCount = ck.nonzeros(nnz);
            nzCount = XGBoostUtils.getNzCount(new ZeroWeight(){

                @Override
                public boolean zeroWeight(int idx) {
                    return weight != -1 && ck.atd(idx) == 0.0;
                }
            }, col[i], nzCount, ck, nnz, nnzCount, true);
        }
        return nzCount;
    }

    private static int getNzCount(ZeroWeight zw, List<SparseItem> sparseItems, int nzCount, Chunk ck, int[] nnz, int nnzCount, boolean localWeight) {
        for (int k = 0; k < nnzCount; ++k) {
            SparseItem item = new SparseItem();
            int localIdx = nnz[k];
            item.pos = (int)ck.start() + localIdx;
            if (zw.zeroWeight(localWeight ? localIdx : item.pos) || ck.isNA(localIdx)) continue;
            item.val = ck.atd(localIdx);
            sparseItems.add(item);
            ++nzCount;
        }
        return nzCount;
    }

    public static DMatrix convertChunksToDMatrix(Key<DataInfo> dataInfoKey, Chunk[] chunks, int response, int weight, int fold, boolean sparse) throws XGBoostError {
        DMatrix trainMat;
        long nRows = chunks[0]._len;
        DataInfo di = (DataInfo)dataInfoKey.get();
        float[] resp = new float[(int)nRows];
        float[] weights = null;
        if (-1 != weight) {
            weights = new float[(int)nRows];
        }
        try {
            if (sparse) {
                Log.info((Object[])new Object[]{"Treating matrix as sparse."});
                boolean csc = false;
                trainMat = csc ? XGBoostUtils.csc(chunks, weight, nRows, di, resp, weights) : XGBoostUtils.csr(chunks, weight, response, (int)nRows, di, resp, weights);
            } else {
                trainMat = XGBoostUtils.dense(chunks, weight, di, response, resp, weights);
            }
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
        }
        int len = (int)trainMat.rowNum();
        resp = Arrays.copyOf(resp, len);
        trainMat.setLabel(resp);
        if (weight != -1) {
            weights = Arrays.copyOf(weights, len);
            trainMat.setWeight(weights);
        }
        return trainMat;
    }

    private static DMatrix dense(Chunk[] chunks, int weight, DataInfo di, int respIdx, float[] resp, float[] weights) throws XGBoostError {
        Log.info((Object[])new Object[]{"Treating matrix as dense."});
        int cols = di.fullN();
        float[][] data = new float[XGBoostUtils.getDataRows(chunks, null, null, cols)][];
        data[0] = new float[0x100000];
        long actualRows = XGBoostUtils.denseChunk(data, chunks, weight, respIdx, di, cols, resp, weights);
        int lastRowSize = (int)((double)actualRows * (double)cols % 2.147483637E9);
        if (data[data.length - 1].length > lastRowSize) {
            data[data.length - 1] = Arrays.copyOf(data[data.length - 1], lastRowSize);
        }
        DMatrix trainMat = new DMatrix((float[][])data, actualRows, cols, Float.NaN);
        assert (trainMat.rowNum() == actualRows);
        return trainMat;
    }

    private static long denseChunk(float[][] data, int[] chunks, Frame f, Vec.Reader[] vecs, Vec.Reader w, DataInfo di, int cols, float[] resp, float[] weights, Vec.Reader respVec) {
        int currentRow = 0;
        int currentCol = 0;
        long actualRows = 0L;
        int rwRow = 0;
        int[] nArray = chunks;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer chunk = nArray[i];
            for (long i2 = f.anyVec().espc()[chunk]; i2 < f.anyVec().espc()[chunk + 1]; ++i2) {
                int j;
                if (w != null && w.at(i2) == 0.0) continue;
                XGBoostUtils.enlargeFloatTable(data, cols, currentRow, currentCol);
                for (j = 0; j < di._cats; ++j) {
                    int offset = di._catOffsets[j + 1] - di._catOffsets[j];
                    int pos = vecs[j].isNA(i2) ? di.getCategoricalId(j, Double.NaN) : di.getCategoricalId(j, (double)vecs[j].at8(i2));
                    if (currentCol + (pos -= di._catOffsets[j]) < data[currentRow].length && currentCol + pos >= 0) {
                        data[currentRow][currentCol + pos] = 1.0f;
                    }
                    if (currentCol + offset >= data[currentRow].length || currentCol + offset < 0) {
                        pos = currentCol + pos - data[currentRow].length;
                        offset = currentCol + offset - data[currentRow].length;
                        if (++currentRow > 0x7FFFFFF5) {
                            throw new IllegalStateException("Data too big to be used in XGBoost. Currently we can handle only up to 4.6116859711827476E18 entries (after encodings etc.).");
                        }
                        currentCol = 0;
                        if (pos >= 0) {
                            data[currentRow][currentCol + pos] = 1.0f;
                        }
                    }
                    currentCol += offset;
                }
                for (j = 0; j < di._nums; ++j) {
                    if (currentCol == 0x7FFFFFF5) {
                        currentCol = 0;
                        ++currentRow;
                    }
                    data[currentRow][currentCol++] = vecs[di._cats + j].isNA(i2) ? Float.NaN : (float)vecs[di._cats + j].at(i2);
                }
                ++actualRows;
                rwRow = XGBoostUtils.setResponseAndWeight(w, resp, weights, respVec, rwRow, i2);
            }
        }
        return actualRows;
    }

    private static long denseChunk(float[][] data, Chunk[] chunks, int weight, int respIdx, DataInfo di, int cols, float[] resp, float[] weights) {
        int currentRow = 0;
        int currentCol = 0;
        long actualRows = 0L;
        int rwRow = 0;
        for (int i = 0; i < chunks[0].len(); ++i) {
            int j;
            if (weight != -1 && chunks[weight].atd(i) == 0.0) continue;
            XGBoostUtils.enlargeFloatTable(data, cols, currentRow, currentCol);
            for (j = 0; j < di._cats; ++j) {
                int offset = di._catOffsets[j + 1] - di._catOffsets[j];
                int pos = chunks[j].isNA(i) ? di.getCategoricalId(j, Double.NaN) : di.getCategoricalId(j, (double)chunks[j].at8(i));
                if (currentCol + (pos -= di._catOffsets[j]) < data[currentRow].length) {
                    data[currentRow][currentCol + pos] = 1.0f;
                }
                if (currentCol + offset >= data[currentRow].length) {
                    pos = currentCol + pos - data[currentRow].length;
                    offset = currentCol + offset - data[currentRow].length;
                    ++currentRow;
                    currentCol = 0;
                    if (pos >= 0) {
                        data[currentRow][currentCol + pos] = 1.0f;
                    }
                }
                currentCol += offset;
            }
            for (j = 0; j < di._nums; ++j) {
                if (currentCol == 0x7FFFFFF5) {
                    currentCol = 0;
                    ++currentRow;
                }
                data[currentRow][currentCol++] = chunks[di._cats + j].isNA(i) ? Float.NaN : (float)chunks[di._cats + j].atd(i);
            }
            assert (di._catOffsets[di._catOffsets.length - 1] + di._nums == cols);
            ++actualRows;
            rwRow = XGBoostUtils.setResponseAndWeight(chunks, respIdx, weight, resp, weights, rwRow, i);
        }
        return actualRows;
    }

    private static DMatrix csr(Frame f, int[] chunksIds, Vec.Reader[] vecs, Vec.Reader w, Vec.Reader respReader, int nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csr(null, -1, -1, f, chunksIds, vecs, w, respReader, nRows, di, resp, weights);
    }

    private static DMatrix csr(Chunk[] chunks, int weight, int respIdx, int nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csr(chunks, weight, respIdx, null, null, null, null, null, nRows, di, resp, weights);
    }

    private static DMatrix csr(Chunk[] chunks, int weight, int respIdx, Frame f, int[] chunksIds, Vec.Reader[] vecs, Vec.Reader w, Vec.Reader respReader, int nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        int actualRows = 0;
        long[][] rowHeaders = new long[1][nRows + 1];
        int initial_size = 0x100000;
        float[][] data = new float[XGBoostUtils.getDataRows(chunks, f, chunksIds, di.fullN())][initial_size];
        int[][] colIndex = new int[1][initial_size];
        rowHeaders[0][0] = 0L;
        actualRows = null != chunks ? XGBoostUtils.initalizeFromChunks(chunks, weight, di, actualRows, rowHeaders, data, colIndex, respIdx, resp, weights) : XGBoostUtils.initalizeFromChunkIds(f, chunksIds, vecs, w, di, actualRows, rowHeaders, data, colIndex, respReader, resp, weights);
        long size = 0L;
        for (int i = 0; i < data.length; ++i) {
            size += (long)data[i].length;
        }
        int rowHeadersSize = 0;
        for (int i = 0; i < rowHeaders.length; ++i) {
            rowHeadersSize += rowHeaders[i].length;
        }
        DMatrix trainMat = new DMatrix(rowHeaders, colIndex, data, DMatrix.SparseType.CSR, di.fullN(), rowHeadersSize, size);
        assert (trainMat.rowNum() == (long)actualRows);
        return trainMat;
    }

    private static int initalizeFromChunkIds(Frame f, int[] chunks, Vec.Reader[] vecs, Vec.Reader w, DataInfo di, int actualRows, long[][] rowHeaders, float[][] data, int[][] colIndex, Vec.Reader respVec, float[] resp, float[] weights) {
        int nz = 0;
        int currentRow = 0;
        int currentCol = 0;
        int rwRow = 0;
        rowHeaders[0][0] = 0L;
        int[] nArray = chunks;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer chunk = nArray[i];
            for (long i2 = f.anyVec().espc()[chunk]; i2 < f.anyVec().espc()[chunk + 1]; ++i2) {
                int j;
                if (w != null && w.at(i2) == 0.0) continue;
                int nzstart = nz;
                XGBoostUtils.enlargeTables(data, colIndex, di._cats + di._nums, currentRow, currentCol);
                for (j = 0; j < di._cats; ++j) {
                    if (vecs[j].isNA(i2)) continue;
                    data[currentRow][currentCol] = 1.0f;
                    colIndex[currentRow][currentCol++] = di.getCategoricalId(j, (double)vecs[j].at8(i2));
                    ++nz;
                }
                for (j = 0; j < di._nums; ++j) {
                    float val = (float)vecs[di._cats + j].at(i2);
                    if (Float.isNaN(val) || val == 0.0f) continue;
                    data[currentRow][currentCol] = val;
                    colIndex[currentRow][currentCol++] = di._catOffsets[di._catOffsets.length - 1] + j;
                    ++nz;
                }
                if (nz == nzstart) {
                    data[currentRow][currentCol] = 0.0f;
                    colIndex[currentRow][currentCol++] = 0;
                    ++nz;
                }
                rowHeaders[0][++actualRows] = nz;
                rwRow = XGBoostUtils.setResponseAndWeight(w, resp, weights, respVec, rwRow, i2);
            }
        }
        data[data.length - 1] = Arrays.copyOf(data[data.length - 1], nz % 0x7FFFFFF5);
        colIndex[colIndex.length - 1] = Arrays.copyOf(colIndex[colIndex.length - 1], nz % 0x7FFFFFF5);
        rowHeaders[0] = Arrays.copyOf(rowHeaders[rowHeaders.length - 1], actualRows + 1);
        return actualRows;
    }

    private static int initalizeFromChunks(Chunk[] chunks, int weight, DataInfo di, int actualRows, long[][] rowHeaders, float[][] data, int[][] colIndex, int respIdx, float[] resp, float[] weights) {
        int nz = 0;
        int currentRow = 0;
        int currentCol = 0;
        int rwRow = 0;
        for (int i = 0; i < chunks[0].len(); ++i) {
            int j;
            if (weight != -1 && chunks[weight].atd(i) == 0.0) continue;
            int nzstart = nz;
            XGBoostUtils.enlargeTables(data, colIndex, di._cats + di._nums, currentRow, currentCol);
            for (j = 0; j < di._cats; ++j) {
                if (chunks[j].isNA(i)) continue;
                data[currentRow][currentCol] = 1.0f;
                colIndex[currentRow][currentCol++] = di.getCategoricalId(j, (double)chunks[j].at8(i));
                ++nz;
            }
            for (j = 0; j < di._nums; ++j) {
                float val = (float)chunks[di._cats + j].atd(i);
                if (Float.isNaN(val) || val == 0.0f) continue;
                data[currentRow][currentCol] = val;
                colIndex[currentRow][currentCol++] = di._catOffsets[di._catOffsets.length - 1] + j;
                ++nz;
            }
            if (nz == nzstart) {
                data[currentRow][currentCol] = 0.0f;
                colIndex[currentRow][currentCol++] = 0;
                ++nz;
            }
            rowHeaders[0][++actualRows] = nz;
            rwRow = XGBoostUtils.setResponseAndWeight(chunks, respIdx, weight, resp, weights, rwRow, i);
        }
        data[data.length - 1] = Arrays.copyOf(data[data.length - 1], nz % 0x7FFFFFF5);
        colIndex[colIndex.length - 1] = Arrays.copyOf(colIndex[colIndex.length - 1], nz % 0x7FFFFFF5);
        rowHeaders[0] = Arrays.copyOf(rowHeaders[rowHeaders.length - 1], actualRows + 1);
        return actualRows;
    }

    private static DMatrix csc(Chunk[] chunks, int weight, long nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csc(chunks, weight, null, null, null, null, nRows, di, resp, weights);
    }

    private static DMatrix csc(Frame f, int[] chunksIds, Vec.Reader w, Vec.Reader respReader, long nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csc(null, -1, f, chunksIds, w, respReader, nRows, di, resp, weights);
    }

    private static DMatrix csc(Chunk[] chunks, int weight, Frame f, int[] chunksIds, Vec.Reader w, Vec.Reader respReader, long nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        int nCols = di._nums;
        List[] col = new List[nCols];
        for (int i = 0; i < nCols; ++i) {
            col[i] = new ArrayList((int)Math.min(nRows, 10000L));
        }
        int nzCount = 0;
        nzCount = null != chunks ? XGBoostUtils.getNzCount(chunks, weight, nCols, col, nzCount) : XGBoostUtils.getNzCount(f, chunksIds, w, nCols, col, nzCount);
        int currentRow = 0;
        int currentCol = 0;
        int nz = 0;
        long[][] colHeaders = new long[1][nCols + 1];
        float[][] data = new float[XGBoostUtils.getDataRows(chunks, f, chunksIds, di.fullN())][nzCount];
        int[][] rowIndex = new int[1][nzCount];
        int rwRow = 0;
        for (int i = 0; i < nCols; ++i) {
            List sparseCol = col[i];
            colHeaders[0][i] = nz;
            XGBoostUtils.enlargeTables(data, rowIndex, sparseCol.size(), currentRow, currentCol);
            for (int j = 0; j < sparseCol.size(); ++j) {
                if (currentCol == 0x7FFFFFF5) {
                    currentCol = 0;
                    ++currentRow;
                }
                SparseItem si = (SparseItem)sparseCol.get(j);
                rowIndex[currentRow][currentCol] = si.pos;
                data[currentRow][currentCol] = (float)si.val;
                assert (si.val != 0.0);
                assert (!Double.isNaN(si.val));
                ++nz;
                ++currentCol;
                if (0 != i) continue;
                rwRow = XGBoostUtils.setResponseAndWeight(w, resp, weights, respReader, rwRow, j);
            }
        }
        colHeaders[0][nCols] = nz;
        data[data.length - 1] = Arrays.copyOf(data[data.length - 1], nz % 0x7FFFFFF5);
        rowIndex[rowIndex.length - 1] = Arrays.copyOf(rowIndex[rowIndex.length - 1], nz % 0x7FFFFFF5);
        int actualRows = XGBoostUtils.countUnique(rowIndex);
        DMatrix trainMat = new DMatrix(colHeaders, rowIndex, data, DMatrix.SparseType.CSC, actualRows, di.fullN(), (long)nz);
        assert (trainMat.rowNum() == (long)actualRows);
        assert (trainMat.rowNum() == (long)rwRow);
        return trainMat;
    }

    private static int countUnique(int[][] array) {
        if (array.length == 0) {
            return 0;
        }
        BitSet values = new BitSet(0x7FFFFFF5);
        int count = 1;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length - 1; ++j) {
                if (values.get(array[i][j])) continue;
                ++count;
                values.set(array[i][j]);
            }
        }
        return count;
    }

    private static void enlargeTables(float[][] data, int[][] rowIndex, int cols, int currentRow, int currentCol) {
        while (data[currentRow].length < currentCol + cols) {
            if (data[currentRow].length == 0x7FFFFFF5) {
                currentCol = 0;
                cols -= data[currentRow].length - currentCol;
                data[++currentRow] = new float[0x100000];
                rowIndex[currentRow] = new int[0x100000];
                continue;
            }
            int newLen = (int)Math.min((long)data[currentRow].length << 1, 0x7FFFFFF5L);
            Log.info((Object[])new Object[]{"Enlarging dense data structures row from " + data[currentRow].length + " float entries to " + newLen + " entries."});
            data[currentRow] = Arrays.copyOf(data[currentRow], newLen);
            rowIndex[currentRow] = Arrays.copyOf(rowIndex[currentRow], newLen);
        }
    }

    private static void enlargeFloatTable(float[][] data, int cols, int currentRow, int currentCol) {
        while ((long)data[currentRow].length < (long)currentCol + (long)cols) {
            if (data[currentRow].length == 0x7FFFFFF5) {
                currentCol = 0;
                cols -= data[currentRow].length - currentCol;
                data[++currentRow] = new float[0x100000];
                continue;
            }
            int newLen = (int)Math.min((long)data[currentRow].length << 1, 0x7FFFFFF5L);
            Log.info((Object[])new Object[]{"Enlarging dense data structure row from " + data[currentRow].length + " bytes to " + newLen + " bytes."});
            data[currentRow] = Arrays.copyOf(data[currentRow], newLen);
        }
    }

    static class SparseItem {
        int pos;
        double val;

        SparseItem() {
        }
    }

    static interface ZeroWeight {
        public boolean zeroWeight(int var1);
    }
}

