/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import hex.tree.xgboost.XGBoostExtension;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.XGBoostUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.Rabit;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostModelInfo;
import water.ExtensionManager;
import water.H2O;
import water.MRTask;
import water.util.FileUtils;
import water.util.IcedHashMapGeneric;
import water.util.Log;

public class XGBoostUpdateTask
extends MRTask<XGBoostUpdateTask> {
    private final XGBoostModelInfo _sharedModel;
    private final XGBoostOutput _output;
    private transient Booster _booster;
    private byte[] _rawBooster;
    private final XGBoostModel.XGBoostParameters _parms;
    private final int _tid;
    private IcedHashMapGeneric.IcedHashMapStringString rabitEnv = new IcedHashMapGeneric.IcedHashMapStringString();
    private String[] _featureMap;

    public XGBoostUpdateTask(Booster booster, XGBoostModelInfo inputModel, XGBoostOutput _output, XGBoostModel.XGBoostParameters _parms, int tid, Map<String, String> workerEnvs, String[] featureMap) {
        this._sharedModel = inputModel;
        this._output = _output;
        this._parms = _parms;
        this._tid = tid;
        this._featureMap = featureMap;
        this._rawBooster = hex.tree.xgboost.XGBoost.getRawArray(booster);
        this.rabitEnv.putAll(workerEnvs);
    }

    protected void setupLocal() {
        if (H2O.ARGS.client) {
            return;
        }
        if (!ExtensionManager.getInstance().isCoreExtensionEnabled(XGBoostExtension.NAME)) {
            throw new IllegalStateException("XGBoost is not available on the node " + H2O.SELF);
        }
        try {
            this.update();
        }
        catch (XGBoostError xgBoostError) {
            try {
                Rabit.shutdown();
            }
            catch (XGBoostError xgBoostError1) {
                xgBoostError1.printStackTrace();
            }
            xgBoostError.printStackTrace();
            throw new IllegalStateException("Failed XGBoost training.", xgBoostError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() throws XGBoostError {
        HashMap<String, Object> params = XGBoostModel.createParams(this._parms, this._output);
        this.rabitEnv.put((Object)"DMLC_TASK_ID", (Object)String.valueOf(H2O.SELF.index()));
        DMatrix trainMat = XGBoostUtils.convertFrameToDMatrix(this._sharedModel._dataInfoKey, this._fr, true, this._parms._response_column, this._parms._weights_column, this._parms._fold_column, this._featureMap, this._output._sparse);
        if (null == trainMat) {
            return;
        }
        try {
            Rabit.init((Map)this.rabitEnv);
            if (this._rawBooster == null) {
                HashMap watches = new HashMap();
                this._booster = XGBoost.train((DMatrix)trainMat, params, (int)0, watches, null, null);
            } else {
                try {
                    this._booster = Booster.loadModel((InputStream)new ByteArrayInputStream(this._rawBooster));
                    this._booster.setParams(params);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to load the booster.", e);
                }
                this._booster.update(trainMat, this._tid);
            }
            this._rawBooster = this._booster.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                Rabit.shutdown();
            }
            catch (XGBoostError xgBoostError) {
                Log.debug((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
            }
            throw throwable;
        }
        try {
            Rabit.shutdown();
        }
        catch (XGBoostError xgBoostError) {
            Log.debug((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
        }
    }

    public void reduce(XGBoostUpdateTask mrt) {
        if (null == this._rawBooster) {
            this._rawBooster = mrt._rawBooster;
            this._featureMap = mrt._featureMap;
        }
    }

    private void updateFeatureMapFile(File featureMapFile) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(featureMapFile);
            ((OutputStream)os).write(this._featureMap[0].getBytes());
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Cannot generate " + featureMapFile, e);
            }
            catch (Throwable throwable) {
                FileUtils.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
        }
        FileUtils.close((Closeable[])new Closeable[]{os});
    }

    public Booster getBooster() {
        return this.getBooster(null);
    }

    public Booster getBooster(File featureMapFile) {
        if (null == this._booster) {
            try {
                this._booster = Booster.loadModel((InputStream)new ByteArrayInputStream(this._rawBooster));
            }
            catch (IOException | XGBoostError xgBoostError) {
                throw new IllegalStateException("Failed to load the booster.", xgBoostError);
            }
        }
        if (featureMapFile != null) {
            this.updateFeatureMapFile(featureMapFile);
        }
        return this._booster;
    }
}

