/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import hex.tree.xgboost.XGBoostModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import ml.dmlc.xgboost4j.java.AbstractXGBoostTask;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostSetupTask;
import ml.dmlc.xgboost4j.java.XGBoostUpdater;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.RPC;
import water.util.Log;

public class XGBoostUpdateTask
extends AbstractXGBoostTask<XGBoostUpdateTask> {
    private final int _tid;

    public XGBoostUpdateTask(XGBoostSetupTask setupTask, int tid) {
        super(setupTask);
        this._tid = tid;
    }

    @Override
    protected void execute() {
        Booster booster = XGBoostUpdater.getUpdater((Key<XGBoostModel>)this._modelKey).doUpdate(this._tid);
        if (booster == null) {
            throw new IllegalStateException("Boosting iteration didn't produce a valid Booster.");
        }
    }

    public Booster getBooster() {
        Booster booster;
        H2ONode boosterNode = this.getBoosterNode();
        if (H2O.SELF.equals((Object)boosterNode)) {
            booster = XGBoostUpdater.getUpdater((Key<XGBoostModel>)this._modelKey).getBooster();
        } else {
            Log.debug((Object[])new Object[]{"Booster will be retrieved from a remote node, node=" + boosterNode});
            FetchBoosterTask t = new FetchBoosterTask((Key<XGBoostModel>)this._modelKey);
            booster = ((FetchBoosterTask)new RPC(boosterNode, (DTask)t).call().get()).rawBooster();
        }
        return booster;
    }

    private static class FetchBoosterTask
    extends DTask<FetchBoosterTask> {
        private final Key<XGBoostModel> _modelKey;
        private byte[] _boosterBytes;

        public FetchBoosterTask(Key<XGBoostModel> modelKey) {
            this._modelKey = modelKey;
        }

        private Booster rawBooster() {
            try {
                Booster booster = Booster.loadModel((InputStream)new ByteArrayInputStream(this._boosterBytes));
                Log.debug((Object[])new Object[]{"Booster created from bytes, raw size = " + this._boosterBytes.length});
                return booster;
            }
            catch (IOException | XGBoostError xgBoostError) {
                throw new IllegalStateException("Failed to load the booster.", xgBoostError);
            }
        }

        public void compute2() {
            this._boosterBytes = XGBoostUpdater.getUpdater(this._modelKey).getBoosterBytes();
            this.tryComplete();
        }
    }
}

