/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import hex.tree.xgboost.BoosterParms;
import hex.tree.xgboost.XGBoostModel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.Rabit;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.H2O;
import water.Key;
import water.nbhm.NonBlockingHashMap;
import water.util.Log;

public class XGBoostUpdater
extends Thread {
    private static long WORK_START_TIMEOUT_SECS = 300L;
    private static long INACTIVE_CHECK_INTERVAL_SECS = 60L;
    private static final NonBlockingHashMap<Key<XGBoostModel>, XGBoostUpdater> updaters = new NonBlockingHashMap();
    private final Key<XGBoostModel> _modelKey;
    private final DMatrix _trainMat;
    private final BoosterParms _boosterParms;
    private final Map<String, String> _rabitEnv;
    private SynchronousQueue<BoosterCallable<?>> _in;
    private SynchronousQueue<Object> _out;
    private Booster _booster;

    private XGBoostUpdater(Key<XGBoostModel> modelKey, DMatrix trainMat, BoosterParms boosterParms, Map<String, String> rabitEnv) {
        super("XGBoostUpdater-" + modelKey);
        this._modelKey = modelKey;
        this._trainMat = trainMat;
        this._boosterParms = boosterParms;
        this._rabitEnv = rabitEnv;
        this._in = new SynchronousQueue();
        this._out = new SynchronousQueue();
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block17: {
            Rabit.init(this._rabitEnv);
            while (!XGBoostUpdater.interrupted()) {
                BoosterCallable<?> task = this._in.take();
                Object result = task.call();
                this._out.put(result);
            }
            this._in = null;
            this._out = null;
            this._trainMat.dispose();
            if (this._booster != null) {
                this._booster.dispose();
            }
            updaters.remove(this._modelKey);
            try {
                Rabit.shutdown();
            }
            catch (XGBoostError xgBoostError) {
                Log.warn((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
            }
            break block17;
            catch (InterruptedException e) {
                XGBoostUpdater self = (XGBoostUpdater)updaters.get(this._modelKey);
                if (self != null) {
                    throw new IllegalStateException("Updater thread was interrupted while it was still registered, name=" + self.getName());
                }
                this._in = null;
                this._out = null;
                this._trainMat.dispose();
                if (this._booster != null) {
                    this._booster.dispose();
                }
                updaters.remove(this._modelKey);
                try {
                    Rabit.shutdown();
                }
                catch (XGBoostError xgBoostError) {
                    Log.warn((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
                }
            }
            catch (XGBoostError e2) {
                throw new IllegalStateException("XGBoost training iteration failed", e2);
                {
                    catch (Throwable throwable) {
                        this._in = null;
                        this._out = null;
                        this._trainMat.dispose();
                        if (this._booster != null) {
                            this._booster.dispose();
                        }
                        updaters.remove(this._modelKey);
                        try {
                            Rabit.shutdown();
                        }
                        catch (XGBoostError xgBoostError) {
                            Log.warn((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private <T> T invoke(BoosterCallable<T> callable) throws InterruptedException {
        SynchronousQueue<Object> outQ;
        SynchronousQueue<BoosterCallable<?>> inQ = this._in;
        if (inQ == null) {
            throw new IllegalStateException("Updater is inactive on node " + H2O.SELF);
        }
        if (!inQ.offer(callable, WORK_START_TIMEOUT_SECS, TimeUnit.SECONDS)) {
            throw new IllegalStateException("XGBoostUpdater couldn't start work on task " + callable + " in " + WORK_START_TIMEOUT_SECS + "s.");
        }
        while ((outQ = this._out) != null) {
            Object result = outQ.poll(INACTIVE_CHECK_INTERVAL_SECS, TimeUnit.SECONDS);
            if (result == null) continue;
            return (T)result;
        }
        throw new IllegalStateException("Cannot perform booster operation: updater is inactive on node " + H2O.SELF);
    }

    Booster getBooster() {
        return this._booster;
    }

    byte[] getBoosterBytes() {
        try {
            return this.invoke(new SerializeBooster());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to serialize Booster - operation was interrupted", e);
        }
    }

    Booster doUpdate(int tid) {
        try {
            return this.invoke(new UpdateBooster(tid));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Boosting iteration failed - operation was interrupted", e);
        }
    }

    static XGBoostUpdater make(Key<XGBoostModel> modelKey, DMatrix trainMat, BoosterParms boosterParms, Map<String, String> rabitEnv) {
        XGBoostUpdater updater = new XGBoostUpdater(modelKey, trainMat, boosterParms, rabitEnv);
        if (updaters.putIfAbsent(modelKey, (Object)updater) != null) {
            throw new IllegalStateException("XGBoostUpdater for modelKey=" + modelKey + " already exists!");
        }
        return updater;
    }

    static void terminate(Key<XGBoostModel> modelKey) {
        XGBoostUpdater updater = (XGBoostUpdater)updaters.remove(modelKey);
        if (updater == null) {
            Log.debug((Object[])new Object[]{"XGBoostUpdater for modelKey=" + modelKey + " was already clean-up on node " + H2O.SELF});
        } else {
            updater.interrupt();
        }
    }

    static XGBoostUpdater getUpdater(Key<XGBoostModel> modelKey) {
        XGBoostUpdater updater = (XGBoostUpdater)updaters.get(modelKey);
        if (updater == null) {
            throw new IllegalStateException("XGBoostUpdater for modelKey=" + modelKey + " was not found!");
        }
        return updater;
    }

    private static interface BoosterCallable<E> {
        public E call() throws XGBoostError;
    }

    private class SerializeBooster
    implements BoosterCallable<byte[]> {
        private SerializeBooster() {
        }

        @Override
        public byte[] call() throws XGBoostError {
            return XGBoostUpdater.this._booster.toByteArray();
        }

        public String toString() {
            return "SerializeBooster";
        }
    }

    private class UpdateBooster
    implements BoosterCallable<Booster> {
        private final int _tid;

        private UpdateBooster(int tid) {
            this._tid = tid;
        }

        @Override
        public Booster call() throws XGBoostError {
            if (XGBoostUpdater.this._booster == null && this._tid == 0) {
                HashMap watches = new HashMap();
                XGBoostUpdater.this._booster = XGBoost.train((DMatrix)XGBoostUpdater.this._trainMat, XGBoostUpdater.this._boosterParms.get(), (int)0, watches, null, null);
                byte[] boosterBytes = XGBoostUpdater.this._booster.toByteArray();
                Log.info((Object[])new Object[]{"Initial (0 tree) Booster created, size=" + boosterBytes.length});
            } else {
                assert (XGBoostUpdater.this._booster != null);
                XGBoostUpdater.this._booster.update(XGBoostUpdater.this._trainMat, this._tid);
            }
            return XGBoostUpdater.this._booster;
        }

        public String toString() {
            return "Boosting Iteration (tid=" + this._tid + ")";
        }
    }
}

