/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.util.BigDenseMatrix;
import water.H2O;
import water.Key;
import water.LocalMR;
import water.MemoryManager;
import water.MrFun;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;
import water.util.VecUtils;

public class XGBoostUtils {
    private static final int ALLOCATED_ARRAY_LEN = 0x100000;
    private static final int ARRAY_MAX = 0x7FFFFFF5;

    public static String makeFeatureMap(Frame f, DataInfo di) {
        String[] coefnames = di.coefNames();
        StringBuilder sb = new StringBuilder();
        assert (coefnames.length == di.fullN());
        int catCols = di._catOffsets[di._catOffsets.length - 1];
        for (int i = 0; i < di.fullN(); ++i) {
            sb.append(i).append(" ").append(coefnames[i].replaceAll("\\s*", "")).append(" ");
            if (i < catCols || f.vec(i - catCols).isBinary()) {
                sb.append("i");
            } else if (f.vec(i - catCols).isInt()) {
                sb.append("int");
            } else {
                sb.append("q");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMatrix convertFrameToDMatrix(Key<DataInfo> dataInfoKey, Frame f, boolean onlyLocal, String response, String weight, String fold, boolean sparse) throws XGBoostError {
        DMatrix trainMat;
        int[] nRowsByChunk;
        Vec weightVector;
        long nRowsL;
        int[] chunks;
        Vec vec = f.anyVec();
        if (!onlyLocal) {
            chunks = new int[f.anyVec().nChunks()];
            for (int i = 0; i < chunks.length; ++i) {
                chunks[i] = i;
            }
        } else {
            chunks = VecUtils.getLocalChunkIds((Vec)f.anyVec());
        }
        if ((nRowsL = XGBoostUtils.sumChunksLength(chunks, vec, weightVector = f.vec(weight), nRowsByChunk = new int[chunks.length])) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("XGBoost currently doesn't support datasets with more than 2147483647 per node. To train a XGBoost model on this dataset add more nodes to your H2O cluster and use distributed training.");
        }
        int nRows = (int)nRowsL;
        DataInfo di = (DataInfo)dataInfoKey.get();
        assert (di != null);
        float[] resp = MemoryManager.malloc4f((int)nRows);
        float[] weights = null;
        if (weightVector != null) {
            weights = MemoryManager.malloc4f((int)nRows);
        }
        if (sparse) {
            Vec.Reader w;
            Log.debug((Object[])new Object[]{"Treating matrix as sparse."});
            boolean csc = false;
            Vec.Reader reader = weight == null ? null : (w = new Vec.Reader(weightVector));
            if (csc) {
                trainMat = XGBoostUtils.csc(f, chunks, w, new Vec.Reader(f.vec(response)), nRows, di, resp, weights);
            } else {
                Vec.Reader[] vecs = new Vec.Reader[f.numCols()];
                for (int i = 0; i < vecs.length; ++i) {
                    vecs[i] = new Vec.Reader(f.vec(i));
                }
                trainMat = XGBoostUtils.csr(f, chunks, vecs, w, new Vec.Reader(f.vec(response)), nRows, di, resp, weights);
            }
        } else {
            Log.debug((Object[])new Object[]{"Treating matrix as dense."});
            BigDenseMatrix data = null;
            try {
                data = XGBoostUtils.allocateDenseMatrix(nRows, di);
                long actualRows = XGBoostUtils.denseChunk(data, chunks, nRowsByChunk, f, weightVector, f.vec(response), di, resp, weights);
                assert ((long)data.nrow == actualRows);
                trainMat = new DMatrix(data, Float.NaN);
            }
            finally {
                if (data != null) {
                    data.dispose();
                }
            }
        }
        assert (trainMat.rowNum() == (long)nRows);
        trainMat.setLabel(resp);
        if (weights != null) {
            trainMat.setWeight(weights);
        }
        return trainMat;
    }

    private static int getDataRows(Chunk[] chunks, Frame f, int[] chunksIds, int cols) {
        double totalRows = 0.0;
        if (null != chunks) {
            for (Chunk ch : chunks) {
                totalRows += (double)ch.len();
            }
        } else {
            for (int chunkId : chunksIds) {
                totalRows += (double)f.anyVec().chunkLen(chunkId);
            }
        }
        return (int)Math.ceil(totalRows * (double)cols / 2.147483637E9);
    }

    private static long sumChunksLength(int[] chunkIds, Vec vec, Vec weightsVector, int[] chunkLengths) {
        for (int i = 0; i < chunkIds.length; ++i) {
            int chunk = chunkIds[i];
            chunkLengths[i] = vec.chunkLen(chunk);
            if (weightsVector == null) continue;
            Chunk weightVecChunk = weightsVector.chunkForChunkIdx(chunk);
            if (weightVecChunk.atd(0) == 0.0) {
                int n = i;
                chunkLengths[n] = chunkLengths[n] - 1;
            }
            int nzIndex = 0;
            while ((nzIndex = weightVecChunk.nextNZ(nzIndex, true)) >= 0 && nzIndex < weightVecChunk._len) {
                if (weightVecChunk.atd(nzIndex) != 0.0) continue;
                int n = i;
                chunkLengths[n] = chunkLengths[n] - 1;
            }
        }
        long totalChunkLength = 0L;
        for (int cl : chunkLengths) {
            totalChunkLength += (long)cl;
        }
        return totalChunkLength;
    }

    private static int setResponseAndWeight(Chunk[] chunks, int respIdx, int weightIdx, float[] resp, float[] weights, int j, int i) {
        if (weightIdx != -1) {
            if (chunks[weightIdx].atd(i) == 0.0) {
                return j;
            }
            weights[j] = (float)chunks[weightIdx].atd(i);
        }
        resp[j++] = (float)chunks[respIdx].atd(i);
        return j;
    }

    private static int setResponseAndWeight(Vec.Reader w, float[] resp, float[] weights, Vec.Reader respVec, int j, long i) {
        if (w != null) {
            if (w.at(i) == 0.0) {
                return j;
            }
            weights[j] = (float)w.at(i);
        }
        resp[j++] = (float)respVec.at(i);
        return j;
    }

    private static int getNzCount(Frame f, int[] chunks, final Vec.Reader w, int nCols, List<SparseItem>[] col, int nzCount) {
        for (int i = 0; i < nCols; ++i) {
            Vec v = f.vec(i);
            int[] nArray = chunks;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                Integer c = nArray[j];
                Chunk ck = v.chunkForChunkIdx(c.intValue());
                int[] nnz = new int[ck.sparseLenZero()];
                int nnzCount = ck.nonzeros(nnz);
                nzCount = XGBoostUtils.getNzCount(new ZeroWeight(){

                    @Override
                    public boolean zeroWeight(int idx) {
                        return w != null && w.at((long)idx) == 0.0;
                    }
                }, col[i], nzCount, ck, nnz, nnzCount, false);
            }
        }
        return nzCount;
    }

    private static int getNzCount(Chunk[] chunks, final int weight, int nCols, List<SparseItem>[] col, int nzCount) {
        for (int i = 0; i < nCols; ++i) {
            final Chunk ck = chunks[i];
            int[] nnz = new int[ck.sparseLenZero()];
            int nnzCount = ck.nonzeros(nnz);
            nzCount = XGBoostUtils.getNzCount(new ZeroWeight(){

                @Override
                public boolean zeroWeight(int idx) {
                    return weight != -1 && ck.atd(idx) == 0.0;
                }
            }, col[i], nzCount, ck, nnz, nnzCount, true);
        }
        return nzCount;
    }

    private static int getNzCount(ZeroWeight zw, List<SparseItem> sparseItems, int nzCount, Chunk ck, int[] nnz, int nnzCount, boolean localWeight) {
        for (int k = 0; k < nnzCount; ++k) {
            SparseItem item = new SparseItem();
            int localIdx = nnz[k];
            item.pos = (int)ck.start() + localIdx;
            if (zw.zeroWeight(localWeight ? localIdx : item.pos) || ck.isNA(localIdx)) continue;
            item.val = ck.atd(localIdx);
            sparseItems.add(item);
            ++nzCount;
        }
        return nzCount;
    }

    public static DMatrix convertChunksToDMatrix(Key<DataInfo> dataInfoKey, Chunk[] chunks, int response, int weight, int fold, boolean sparse) throws XGBoostError {
        DMatrix trainMat;
        int nRows = chunks[0]._len;
        DataInfo di = (DataInfo)dataInfoKey.get();
        float[] resp = MemoryManager.malloc4f((int)nRows);
        float[] weights = null;
        if (-1 != weight) {
            weights = MemoryManager.malloc4f((int)nRows);
        }
        try {
            if (sparse) {
                Log.debug((Object[])new Object[]{"Treating matrix as sparse."});
                boolean csc = false;
                trainMat = csc ? XGBoostUtils.csc(chunks, weight, nRows, di, resp, weights) : XGBoostUtils.csr(chunks, weight, response, nRows, di, resp, weights);
            } else {
                trainMat = XGBoostUtils.dense(chunks, weight, di, response, resp, weights);
            }
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
        }
        int len = (int)trainMat.rowNum();
        resp = Arrays.copyOf(resp, len);
        trainMat.setLabel(resp);
        if (weight != -1) {
            weights = Arrays.copyOf(weights, len);
            trainMat.setWeight(weights);
        }
        return trainMat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DMatrix dense(Chunk[] chunks, int weight, DataInfo di, int respIdx, float[] resp, float[] weights) throws XGBoostError {
        Log.debug((Object[])new Object[]{"Treating matrix as dense."});
        BigDenseMatrix data = null;
        try {
            data = XGBoostUtils.allocateDenseMatrix(chunks[0].len(), di);
            long actualRows = XGBoostUtils.denseChunk(data, chunks, weight, respIdx, di, resp, weights);
            assert (actualRows == (long)data.nrow);
            DMatrix dMatrix = new DMatrix(data, Float.NaN);
            return dMatrix;
        }
        finally {
            if (data != null) {
                data.dispose();
            }
        }
    }

    private static long denseChunk(BigDenseMatrix data, int[] chunks, int[] nRowsByChunk, Frame f, Vec weightsVec, Vec respVec, DataInfo di, float[] resp, float[] weights) {
        int[] offsets = new int[nRowsByChunk.length + 1];
        for (int i = 0; i < chunks.length; ++i) {
            offsets[i + 1] = nRowsByChunk[i] + offsets[i];
        }
        WriteDenseChunkFun writeFun = new WriteDenseChunkFun(f, chunks, offsets, weightsVec, respVec, di, data, resp, weights);
        ((LocalMR)H2O.submitTask((H2O.H2OCountedCompleter)new LocalMR((MrFun)writeFun, chunks.length))).join();
        return writeFun.getTotalRows();
    }

    private static long denseChunk(BigDenseMatrix data, Chunk[] chunks, int weight, int respIdx, DataInfo di, float[] resp, float[] weights) {
        long idx = 0L;
        long actualRows = 0L;
        int rwRow = 0;
        for (int i = 0; i < chunks[0]._len; ++i) {
            if (weight != -1 && chunks[weight].atd(i) == 0.0) continue;
            idx = XGBoostUtils.writeDenseRow(di, chunks, i, data, idx);
            ++actualRows;
            rwRow = XGBoostUtils.setResponseAndWeight(chunks, respIdx, weight, resp, weights, rwRow, i);
        }
        assert ((long)data.nrow * (long)data.ncol == idx);
        return actualRows;
    }

    private static long writeDenseRow(DataInfo di, Chunk[] chunks, int rowInChunk, BigDenseMatrix data, long idx) {
        int j;
        for (j = 0; j < di._cats; ++j) {
            int len = di._catOffsets[j + 1] - di._catOffsets[j];
            double val = chunks[j].isNA(rowInChunk) ? Double.NaN : (double)chunks[j].at8(rowInChunk);
            int pos = di.getCategoricalId(j, val) - di._catOffsets[j];
            for (int cat = 0; cat < len; ++cat) {
                data.set(idx + (long)cat, 0.0f);
            }
            data.set(idx + (long)pos, 1.0f);
            idx += (long)len;
        }
        for (j = 0; j < di._nums; ++j) {
            float val = chunks[di._cats + j].isNA(rowInChunk) ? Float.NaN : (float)chunks[di._cats + j].atd(rowInChunk);
            data.set(idx++, val);
        }
        return idx;
    }

    private static DMatrix csr(Frame f, int[] chunksIds, Vec.Reader[] vecs, Vec.Reader w, Vec.Reader respReader, int nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csr(null, -1, -1, f, chunksIds, vecs, w, respReader, nRows, di, resp, weights);
    }

    private static DMatrix csr(Chunk[] chunks, int weight, int respIdx, int nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csr(chunks, weight, respIdx, null, null, null, null, null, nRows, di, resp, weights);
    }

    private static DMatrix csr(Chunk[] chunks, int weight, int respIdx, Frame f, int[] chunksIds, Vec.Reader[] vecs, Vec.Reader w, Vec.Reader respReader, int nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        int[][] colIndex;
        long[][] rowHeaders;
        float[][] data;
        SparseMatrix sparseMatrix;
        SparseMatrixDimensions sparseMatrixDimensions;
        int actualRows = 0;
        if (null != chunks) {
            sparseMatrixDimensions = XGBoostUtils.calculateCSRMatrixDimensions(chunks, di, weight);
            sparseMatrix = XGBoostUtils.allocateCSRMatrix(sparseMatrixDimensions);
            data = sparseMatrix._sparseData;
            rowHeaders = sparseMatrix._rowIndices;
            colIndex = sparseMatrix._colIndices;
            actualRows = XGBoostUtils.initializeFromChunks(chunks, weight, di, actualRows, rowHeaders, data, colIndex, respIdx, resp, weights);
        } else {
            sparseMatrixDimensions = XGBoostUtils.calculateCSRMatrixDimensions(f, chunksIds, vecs, w, di);
            sparseMatrix = XGBoostUtils.allocateCSRMatrix(sparseMatrixDimensions);
            data = sparseMatrix._sparseData;
            rowHeaders = sparseMatrix._rowIndices;
            colIndex = sparseMatrix._colIndices;
            actualRows = XGBoostUtils.initalizeFromChunkIds(f, chunksIds, vecs, w, di, actualRows, rowHeaders, data, colIndex, respReader, resp, weights);
        }
        long size = sparseMatrixDimensions._nonZeroElementsCount;
        int rowHeadersSize = (int)sparseMatrixDimensions._rowIndicesCount;
        DMatrix trainMat = new DMatrix(rowHeaders, colIndex, data, DMatrix.SparseType.CSR, di.fullN(), rowHeadersSize, size);
        assert (trainMat.rowNum() == (long)actualRows);
        return trainMat;
    }

    private static int initalizeFromChunkIds(Frame f, int[] chunks, Vec.Reader[] vecs, Vec.Reader w, DataInfo di, int actualRows, long[][] rowHeaders, float[][] data, int[][] colIndex, Vec.Reader respVec, float[] resp, float[] weights) {
        int nonZeroCount = 0;
        int currentRow = 0;
        int currentCol = 0;
        int rwRow = 0;
        int[] nArray = chunks;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer chunk = nArray[i];
            for (long i2 = f.anyVec().espc()[chunk]; i2 < f.anyVec().espc()[chunk + 1]; ++i2) {
                int j;
                if (w != null && w.at(i2) == 0.0) continue;
                int startNonZeroCount = nonZeroCount;
                for (j = 0; j < di._cats; ++j) {
                    data[currentRow][currentCol] = 1.0f;
                    colIndex[currentRow][currentCol++] = vecs[j].isNA(i2) ? di.getCategoricalId(j, Double.NaN) : di.getCategoricalId(j, (double)vecs[j].at8(i2));
                    ++nonZeroCount;
                }
                for (j = 0; j < di._nums; ++j) {
                    float val = (float)vecs[di._cats + j].at(i2);
                    if (val == 0.0f) continue;
                    data[currentRow][currentCol] = val;
                    colIndex[currentRow][currentCol++] = di._catOffsets[di._catOffsets.length - 1] + j;
                    ++nonZeroCount;
                }
                rowHeaders[0][++actualRows] = nonZeroCount;
                rwRow = XGBoostUtils.setResponseAndWeight(w, resp, weights, respVec, rwRow, i2);
            }
        }
        return actualRows;
    }

    private static int initializeFromChunks(Chunk[] chunks, int weight, DataInfo di, int actualRows, long[][] rowHeaders, float[][] data, int[][] colIndex, int respIdx, float[] resp, float[] weights) {
        int nonZeroCount = 0;
        int currentRow = 0;
        int currentCol = 0;
        int rwRow = 0;
        for (int i = 0; i < chunks[0].len(); ++i) {
            int j;
            if (weight != -1 && chunks[weight].atd(i) == 0.0) continue;
            for (j = 0; j < di._cats; ++j) {
                data[currentRow][currentCol] = 1.0f;
                colIndex[currentRow][currentCol++] = chunks[j].isNA(i) ? di.getCategoricalId(j, Double.NaN) : di.getCategoricalId(j, (double)chunks[j].at8(i));
                ++nonZeroCount;
            }
            for (j = 0; j < di._nums; ++j) {
                float val = (float)chunks[di._cats + j].atd(i);
                if (val == 0.0f) continue;
                data[currentRow][currentCol] = val;
                colIndex[currentRow][currentCol++] = di._catOffsets[di._catOffsets.length - 1] + j;
                ++nonZeroCount;
            }
            rowHeaders[0][++actualRows] = nonZeroCount;
            rwRow = XGBoostUtils.setResponseAndWeight(chunks, respIdx, weight, resp, weights, rwRow, i);
        }
        return actualRows;
    }

    private static DMatrix csc(Chunk[] chunks, int weight, long nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csc(chunks, weight, null, null, null, null, nRows, di, resp, weights);
    }

    private static DMatrix csc(Frame f, int[] chunksIds, Vec.Reader w, Vec.Reader respReader, long nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        return XGBoostUtils.csc(null, -1, f, chunksIds, w, respReader, nRows, di, resp, weights);
    }

    private static DMatrix csc(Chunk[] chunks, int weight, Frame f, int[] chunksIds, Vec.Reader w, Vec.Reader respReader, long nRows, DataInfo di, float[] resp, float[] weights) throws XGBoostError {
        int nCols = di._nums;
        List[] col = new List[nCols];
        for (int i = 0; i < nCols; ++i) {
            col[i] = new ArrayList((int)Math.min(nRows, 10000L));
        }
        int nzCount = 0;
        nzCount = null != chunks ? XGBoostUtils.getNzCount(chunks, weight, nCols, col, nzCount) : XGBoostUtils.getNzCount(f, chunksIds, w, nCols, col, nzCount);
        int currentRow = 0;
        int currentCol = 0;
        int nz = 0;
        long[][] colHeaders = new long[1][nCols + 1];
        float[][] data = new float[XGBoostUtils.getDataRows(chunks, f, chunksIds, di.fullN())][nzCount];
        int[][] rowIndex = new int[1][nzCount];
        int rwRow = 0;
        for (int i = 0; i < nCols; ++i) {
            List sparseCol = col[i];
            colHeaders[0][i] = nz;
            XGBoostUtils.enlargeTables(data, rowIndex, sparseCol.size(), currentRow, currentCol);
            for (int j = 0; j < sparseCol.size(); ++j) {
                if (currentCol == 0x7FFFFFF5) {
                    currentCol = 0;
                    ++currentRow;
                }
                SparseItem si = (SparseItem)sparseCol.get(j);
                rowIndex[currentRow][currentCol] = si.pos;
                data[currentRow][currentCol] = (float)si.val;
                assert (si.val != 0.0);
                assert (!Double.isNaN(si.val));
                ++nz;
                ++currentCol;
                if (0 != i) continue;
                rwRow = XGBoostUtils.setResponseAndWeight(w, resp, weights, respReader, rwRow, j);
            }
        }
        colHeaders[0][nCols] = nz;
        data[data.length - 1] = Arrays.copyOf(data[data.length - 1], nz % 0x7FFFFFF5);
        rowIndex[rowIndex.length - 1] = Arrays.copyOf(rowIndex[rowIndex.length - 1], nz % 0x7FFFFFF5);
        int actualRows = XGBoostUtils.countUnique(rowIndex);
        DMatrix trainMat = new DMatrix(colHeaders, rowIndex, data, DMatrix.SparseType.CSC, actualRows, di.fullN(), (long)nz);
        assert (trainMat.rowNum() == (long)actualRows);
        assert (trainMat.rowNum() == (long)rwRow);
        return trainMat;
    }

    private static int countUnique(int[][] array) {
        if (array.length == 0) {
            return 0;
        }
        BitSet values = new BitSet(0x7FFFFFF5);
        int count = 1;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length - 1; ++j) {
                if (values.get(array[i][j])) continue;
                ++count;
                values.set(array[i][j]);
            }
        }
        return count;
    }

    private static void enlargeTables(float[][] data, int[][] rowIndex, int cols, int currentRow, int currentCol) {
        while (data[currentRow].length < currentCol + cols) {
            if (data[currentRow].length == 0x7FFFFFF5) {
                currentCol = 0;
                cols -= data[currentRow].length - currentCol;
                data[++currentRow] = MemoryManager.malloc4f((int)0x100000);
                rowIndex[currentRow] = MemoryManager.malloc4((int)0x100000);
                continue;
            }
            int newLen = (int)Math.min((long)data[currentRow].length << 1, 0x7FFFFFF5L);
            data[currentRow] = Arrays.copyOf(data[currentRow], newLen);
            rowIndex[currentRow] = Arrays.copyOf(rowIndex[currentRow], newLen);
        }
    }

    private static SparseMatrix allocateCSRMatrix(SparseMatrixDimensions sparseMatrixDimensions) {
        int dataRowsNumber = (int)(sparseMatrixDimensions._nonZeroElementsCount / 0x7FFFFFF5L);
        int dataLastRowSize = (int)(sparseMatrixDimensions._nonZeroElementsCount % 0x7FFFFFF5L);
        int rowIndicesRowsNumber = (int)(sparseMatrixDimensions._rowIndicesCount / 0x7FFFFFF5L);
        int rowIndicesLastRowSize = (int)(sparseMatrixDimensions._rowIndicesCount % 0x7FFFFFF5L);
        int colIndicesRowsNumber = (int)(sparseMatrixDimensions._nonZeroElementsCount / 0x7FFFFFF5L);
        int colIndicesLastRowSize = (int)(sparseMatrixDimensions._nonZeroElementsCount % 0x7FFFFFF5L);
        float[][] sparseData = new float[dataLastRowSize == 0 ? dataRowsNumber : dataRowsNumber + 1][];
        for (int sparseDataRow = 0; sparseDataRow < sparseData.length - 1; ++sparseDataRow) {
            sparseData[sparseDataRow] = MemoryManager.malloc4f((int)0x7FFFFFF5);
        }
        if (dataLastRowSize > 0) {
            sparseData[sparseData.length - 1] = MemoryManager.malloc4f((int)dataLastRowSize);
        }
        long[][] rowIndices = new long[rowIndicesLastRowSize == 0 ? rowIndicesRowsNumber : rowIndicesRowsNumber + 1][];
        for (int rowIndicesRow = 0; rowIndicesRow < rowIndices.length - 1; ++rowIndicesRow) {
            rowIndices[rowIndicesRow] = MemoryManager.malloc8((int)0x7FFFFFF5);
        }
        if (rowIndicesLastRowSize > 0) {
            rowIndices[rowIndices.length - 1] = MemoryManager.malloc8((int)rowIndicesLastRowSize);
        }
        int[][] colIndices = new int[colIndicesLastRowSize == 0 ? colIndicesRowsNumber : colIndicesRowsNumber + 1][];
        for (int colIndicesRow = 0; colIndicesRow < colIndices.length - 1; ++colIndicesRow) {
            colIndices[colIndicesRow] = MemoryManager.malloc4((int)0x7FFFFFF5);
        }
        if (colIndicesLastRowSize > 0) {
            colIndices[colIndices.length - 1] = MemoryManager.malloc4((int)colIndicesLastRowSize);
        }
        return new SparseMatrix(sparseData, rowIndices, colIndices);
    }

    private static SparseMatrixDimensions calculateCSRMatrixDimensions(Chunk[] chunks, DataInfo di, int weightColIndex) {
        long nonZeroElementsCount = 0L;
        long rowIndicesCount = 0L;
        for (int i = 0; i < chunks[0].len(); ++i) {
            if (weightColIndex != -1 && chunks[weightColIndex].atd(i) == 0.0) continue;
            nonZeroElementsCount += (long)di._cats;
            for (int j = 0; j < di._nums; ++j) {
                float val = (float)chunks[di._cats + j].atd(i);
                if (val == 0.0f) continue;
                ++nonZeroElementsCount;
            }
            ++rowIndicesCount;
        }
        return new SparseMatrixDimensions(nonZeroElementsCount, ++rowIndicesCount);
    }

    private static SparseMatrixDimensions calculateCSRMatrixDimensions(Frame f, int[] chunks, Vec.Reader[] vecs, Vec.Reader w, DataInfo di) {
        long nonZeroElementsCount = 0L;
        long rowIndicesCount = 0L;
        int[] nArray = chunks;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer chunk = nArray[i];
            for (long i2 = f.anyVec().espc()[chunk]; i2 < f.anyVec().espc()[chunk + 1]; ++i2) {
                if (w != null && w.at(i2) == 0.0) continue;
                nonZeroElementsCount += (long)di._cats;
                for (int j = 0; j < di._nums; ++j) {
                    float val = (float)vecs[di._cats + j].at(i2);
                    if (val == 0.0f) continue;
                    ++nonZeroElementsCount;
                }
                ++rowIndicesCount;
            }
        }
        return new SparseMatrixDimensions(nonZeroElementsCount, ++rowIndicesCount);
    }

    private static BigDenseMatrix allocateDenseMatrix(int rowCount, DataInfo dataInfo) {
        return new BigDenseMatrix(rowCount, dataInfo.fullN());
    }

    public static FeatureProperties assembleFeatureNames(DataInfo di) {
        String[] coefnames = di.coefNames();
        assert (coefnames.length == di.fullN());
        int numCatCols = di._catOffsets[di._catOffsets.length - 1];
        String[] featureNames = new String[di.fullN()];
        boolean[] oneHotEncoded = new boolean[di.fullN()];
        for (int i = 0; i < di.fullN(); ++i) {
            featureNames[i] = coefnames[i];
            if (i >= numCatCols) continue;
            oneHotEncoded[i] = true;
        }
        return new FeatureProperties(featureNames, oneHotEncoded);
    }

    static class FeatureProperties {
        public String[] _names;
        public boolean[] _oneHotEncoded;

        public FeatureProperties(String[] names, boolean[] oneHotEncoded) {
            this._names = names;
            this._oneHotEncoded = oneHotEncoded;
        }
    }

    private static final class SparseMatrix {
        private final float[][] _sparseData;
        private final long[][] _rowIndices;
        private final int[][] _colIndices;

        public SparseMatrix(float[][] sparseData, long[][] rowIndices, int[][] colIndices) {
            this._sparseData = sparseData;
            this._rowIndices = rowIndices;
            this._colIndices = colIndices;
        }
    }

    private static final class SparseMatrixDimensions {
        private final long _nonZeroElementsCount;
        private final long _rowIndicesCount;

        public SparseMatrixDimensions(long nonZeroElementsCount, long rowIndicesCount) {
            this._nonZeroElementsCount = nonZeroElementsCount;
            this._rowIndicesCount = rowIndicesCount;
        }
    }

    static class SparseItem {
        int pos;
        double val;

        SparseItem() {
        }
    }

    private static class WriteDenseChunkFun
    extends MrFun<WriteDenseChunkFun> {
        private final Frame _f;
        private final int[] _chunks;
        private final int[] _offsets;
        private final Vec _weightsVec;
        private final Vec _respVec;
        private final DataInfo _di;
        private final BigDenseMatrix _data;
        private final float[] _resp;
        private final float[] _weights;
        private int[] _nRowsByChunk;

        private WriteDenseChunkFun(Frame f, int[] chunks, int[] offsets, Vec weightsVec, Vec respVec, DataInfo di, BigDenseMatrix data, float[] resp, float[] weights) {
            this._f = f;
            this._chunks = chunks;
            this._offsets = offsets;
            this._weightsVec = weightsVec;
            this._respVec = respVec;
            this._di = di;
            this._data = data;
            this._resp = resp;
            this._weights = weights;
            this._nRowsByChunk = new int[chunks.length];
        }

        protected void map(int id) {
            int chunkIdx = this._chunks[id];
            Chunk[] chks = new Chunk[this._f.numCols()];
            for (int c = 0; c < chks.length; ++c) {
                chks[c] = this._f.vec(c).chunkForChunkIdx(chunkIdx);
            }
            Chunk weightsChk = this._weightsVec != null ? this._weightsVec.chunkForChunkIdx(chunkIdx) : null;
            Chunk respChk = this._respVec.chunkForChunkIdx(chunkIdx);
            long idx = this._offsets[id] * this._data.ncol;
            int actualRows = 0;
            for (int i = 0; i < chks[0]._len; ++i) {
                if (weightsChk != null && weightsChk.atd(i) == 0.0) continue;
                idx = XGBoostUtils.writeDenseRow(this._di, chks, i, this._data, idx);
                this._resp[this._offsets[id] + actualRows] = (float)respChk.atd(i);
                if (weightsChk != null) {
                    this._weights[this._offsets[id] + actualRows] = (float)weightsChk.atd(i);
                }
                ++actualRows;
            }
            assert (idx == (long)this._offsets[id + 1] * (long)this._data.ncol);
            this._nRowsByChunk[id] = actualRows;
        }

        private long getTotalRows() {
            long totalRows = 0L;
            for (int r : this._nRowsByChunk) {
                totalRows += (long)r;
            }
            return totalRows;
        }
    }

    static interface ZeroWeight {
        public boolean zeroWeight(int var1);
    }
}

