/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import hex.DataInfo;
import hex.tree.xgboost.XGBoostModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.Iced;
import water.Key;
import water.util.Log;

public final class XGBoostModelInfo
extends Iced {
    public String _featureMap;
    public byte[] _boosterBytes;
    public Key<DataInfo> _dataInfoKey;
    public XGBoostModel.XGBoostParameters parameters;

    public String getFeatureMap() {
        return this._featureMap;
    }

    public void setFeatureMap(String featureMap) {
        this._featureMap = featureMap;
    }

    public void setBoosterBytes(byte[] boosterBytes) {
        this._boosterBytes = boosterBytes;
    }

    public Booster deserializeBooster() {
        if (this._boosterBytes == null) {
            throw new IllegalStateException("Booster not initialized!");
        }
        try {
            Booster booster = Booster.loadModel((InputStream)new ByteArrayInputStream(this._boosterBytes));
            Log.debug((Object[])new Object[]{"Booster created from bytes, raw size = " + this._boosterBytes.length});
            return booster;
        }
        catch (IOException | XGBoostError exception) {
            throw new IllegalStateException("Failed to load the booster.", exception);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this._boosterBytes);
    }

    public long size() {
        long res = 0L;
        if (this._boosterBytes != null) {
            res += (long)this._boosterBytes.length;
        }
        return res;
    }

    public XGBoostModelInfo(XGBoostModel.XGBoostParameters origParams) {
        this.parameters = (XGBoostModel.XGBoostParameters)origParams.clone();
    }
}

