/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeFactory;
import biz.k11i.xgboost.util.ModelReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import ml.dmlc.xgboost4j.java.XGBoostRegTree;
import water.util.Log;

public class PredictorFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Predictor makePredictor(byte[] boosterBytes) {
        PredictorConfiguration.Builder bldr = PredictorConfiguration.builder();
        if (PredictorFactory.unsafeTreesSupported()) {
            Log.warn((Object[])new Object[]{"XGBoost Predictor is using EXPERIMENTAL scoring implementation!"});
            bldr.regTreeFactory((RegTreeFactory)UnsafeRegTreeFactory.INSTANCE);
        }
        PredictorConfiguration cfg = bldr.build();
        try (ByteArrayInputStream is = new ByteArrayInputStream(boosterBytes);){
            Predictor predictor = new Predictor((InputStream)is, cfg);
            return predictor;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean unsafeTreesSupported() {
        return ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    }

    private static class UnsafeRegTreeFactory
    implements RegTreeFactory {
        private static final UnsafeRegTreeFactory INSTANCE = new UnsafeRegTreeFactory();

        private UnsafeRegTreeFactory() {
        }

        public RegTree loadTree(ModelReader reader) throws IOException {
            return new XGBoostRegTree(reader);
        }
    }
}

