/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import hex.KeyValue;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLMTask;
import hex.tree.SharedTree;
import hex.tree.TreeUtils;
import hex.tree.xgboost.BoosterParms;
import hex.tree.xgboost.XGBoostExtension;
import hex.tree.xgboost.XGBoostExtensionCheck;
import hex.tree.xgboost.XGBoostGPULock;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.XGBoostUtils;
import hex.tree.xgboost.XgbVarImp;
import hex.tree.xgboost.rabit.RabitTrackerH2O;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.BoosterHelper;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.IRabitTracker;
import ml.dmlc.xgboost4j.java.Rabit;
import ml.dmlc.xgboost4j.java.XGBoostCleanupTask;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostModelInfo;
import ml.dmlc.xgboost4j.java.XGBoostSetupTask;
import ml.dmlc.xgboost4j.java.XGBoostUpdateTask;
import water.DKV;
import water.DTask;
import water.ExtensionManager;
import water.H2O;
import water.H2ONode;
import water.Job;
import water.Key;
import water.RPC;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.FileUtils;
import water.util.Log;
import water.util.Timer;
import water.util.TwoDimTable;

public class XGBoost
extends ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput> {
    private static final double FILL_RATIO_THRESHOLD = 0.25;
    private static volatile boolean DEFAULT_GPU_BLACKLISTED = false;
    private static Set<Integer> GPUS = new HashSet<Integer>();

    public boolean haveMojo() {
        return true;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        if (ExtensionManager.getInstance().isCoreExtensionsEnabled(XGBoostExtension.NAME)) {
            return ModelBuilder.BuilderVisibility.Stable;
        }
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms, Key<XGBoostModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    public XGBoost(boolean startup_once) {
        super((Model.Parameters)new XGBoostModel.XGBoostParameters(), startup_once);
    }

    public boolean isSupervised() {
        return true;
    }

    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(folds, 2);
    }

    protected XGBoostDriver trainModelImpl() {
        return new XGBoostDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (H2O.CLOUD.size() > 1 && H2O.SELF.getSecurityManager().securityEnabled) {
            throw new H2OIllegalArgumentException("Cannot run XGBoost on an SSL enabled cluster larger than 1 node. XGBoost does not support SSL encryption.");
        }
        if (expensive) {
            if (this._response.naCnt() > 0L) {
                this.error("_response_column", "Response contains missing values (NAs) - not supported by XGBoost.");
            }
            if (!((XGBoostExtensionCheck)new XGBoostExtensionCheck().doAllNodes()).enabled) {
                this.error("XGBoost", "XGBoost is not available on all nodes!");
            }
        }
        if (expensive) {
            if (this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
            }
            if (this.hasOffsetCol()) {
                this.error("_offset_column", "Offset is not supported for XGBoost.");
            }
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._backend == XGBoostModel.XGBoostParameters.Backend.gpu) {
            Map<String, Object> incompats;
            if (!XGBoost.hasGPU(((XGBoostModel.XGBoostParameters)this._parms)._gpu_id)) {
                this.error("_backend", "GPU backend (gpu_id: " + ((XGBoostModel.XGBoostParameters)this._parms)._gpu_id + ") is not functional. Check CUDA_PATH and/or GPU installation.");
            }
            if (H2O.getCloudSize() > 1) {
                this.error("_backend", "GPU backend is not supported in distributed mode.");
            }
            if (!(incompats = ((XGBoostModel.XGBoostParameters)this._parms).gpuIncompatibleParams()).isEmpty()) {
                for (Map.Entry<String, Object> incompat : incompats.entrySet()) {
                    this.error("_backend", "GPU backend is not available for parameter setting '" + incompat.getKey() + " = " + incompat.getValue() + "'. Use CPU backend instead.");
                }
            }
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            this.error("_distribution", "Quasibinomial is not supported for XGBoost in current H2O.");
        }
        switch (((XGBoostModel.XGBoostParameters)this._parms)._distribution) {
            case bernoulli: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical"));
                break;
            }
            case modified_huber: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Modified Huber requires the response to be a 2-class categorical."));
                break;
            }
            case multinomial: {
                if (this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Multinomial requires an categorical response."));
                break;
            }
            case huber: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Huber requires the response to be numeric."));
                break;
            }
            case poisson: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Poisson requires the response to be numeric."));
                break;
            }
            case gamma: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                break;
            }
            case tweedie: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                break;
            }
            case gaussian: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gaussian requires the response to be numeric."));
                break;
            }
            case laplace: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Laplace requires the response to be numeric."));
                break;
            }
            case quantile: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Quantile requires the response to be numeric."));
                break;
            }
            case AUTO: {
                break;
            }
            default: {
                this.error("_distribution", "Invalid distribution: " + ((XGBoostModel.XGBoostParameters)this._parms)._distribution);
            }
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._learn_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._learn_rate <= 1.0)) {
            this.error("_learn_rate", "learn_rate must be between 0 and 1");
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate <= 1.0)) {
            this.error("_col_sample_rate", "col_sample_rate must be between 0 and 1");
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._grow_policy == XGBoostModel.XGBoostParameters.GrowPolicy.lossguide && ((XGBoostModel.XGBoostParameters)this._parms)._tree_method != XGBoostModel.XGBoostParameters.TreeMethod.hist) {
            this.error("_grow_policy", "must use tree_method=hist for grow_policy=lossguide");
        }
        if (this._train != null && ((XGBoostModel.XGBoostParameters)this._parms)._monotone_constraints != null) {
            TreeUtils.checkMonotoneConstraints((ModelBuilder)this, (Frame)this._train, (KeyValue[])((XGBoostModel.XGBoostParameters)this._parms)._monotone_constraints);
        }
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, XGBoostModel.XGBoostParameters parms, int nClasses) {
        DataInfo dinfo = new DataInfo(train, valid, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip, false, true, parms._weights_column != null, parms._offset_column != null, parms._fold_column != null);
        GLMTask.YMUTask ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(dinfo, nClasses, nClasses == 1, parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip, true, true).doAll(dinfo._adaptedFrame);
        if (ymt.wsum() == 0.0 && parms._missing_values_handling == XGBoostModel.XGBoostParameters.MissingValuesHandling.Skip) {
            throw new H2OIllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or set missing_values_handling to 'MeanImputation'.");
        }
        if (parms._weights_column != null && parms._offset_column != null) {
            Log.warn((Object[])new Object[]{"Combination of offset and weights can lead to slight differences because Rollupstats aren't weighted - need to re-calculate weighted mean/sigma of the response including offset terms."});
        }
        if (parms._weights_column != null && parms._offset_column == null) {
            dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
            if (nClasses == 1) {
                dinfo.updateWeightedSigmaAndMeanForResponse(ymt.responseSDs(), ymt.responseMeans());
            }
        }
        dinfo.coefNames();
        assert (dinfo._coefNames != null);
        return dinfo;
    }

    public static byte[] getRawArray(Booster booster) {
        byte[] rawBooster;
        if (null == booster) {
            return null;
        }
        try {
            HashMap localRabitEnv = new HashMap();
            Rabit.init(localRabitEnv);
            rawBooster = booster.toByteArray();
            Rabit.shutdown();
        }
        catch (XGBoostError xgBoostError) {
            throw new IllegalStateException("Failed to initialize Rabit or serialize the booster.", xgBoostError);
        }
        return rawBooster;
    }

    private static TwoDimTable createVarImpTable(String name, double[] rel_imp, String[] coef_names) {
        return ModelMetrics.calcVarImp((double[])rel_imp, (String[])coef_names, (String)("Variable Importances" + (name != null ? " - " + name : "")), (String[])new String[]{"Relative Importance", "Scaled Importance", "Percentage"});
    }

    private static XgbVarImp computeVarImp(Map<String, XGBoostUtils.FeatureScore> varimp) {
        if (varimp.isEmpty()) {
            return null;
        }
        float[] gains = new float[varimp.size()];
        float[] covers = new float[varimp.size()];
        int[] freqs = new int[varimp.size()];
        String[] names = new String[varimp.size()];
        int j = 0;
        for (Map.Entry<String, XGBoostUtils.FeatureScore> it : varimp.entrySet()) {
            gains[j] = it.getValue()._gain;
            covers[j] = it.getValue()._cover;
            freqs[j] = it.getValue()._frequency;
            names[j] = it.getKey();
            ++j;
        }
        return new XgbVarImp(names, gains, covers, freqs);
    }

    static boolean hasGPU(H2ONode node, int gpu_id) {
        boolean hasGPU;
        if (H2O.SELF.equals((Object)node)) {
            hasGPU = XGBoost.hasGPU(gpu_id);
        } else {
            HasGPUTask t = new HasGPUTask(gpu_id);
            new RPC(node, (DTask)t).call().get();
            hasGPU = t._hasGPU;
        }
        Log.debug((Object[])new Object[]{"Availability of GPU (id=" + gpu_id + ") on node " + node + ": " + hasGPU});
        return hasGPU;
    }

    private static boolean hasGPU(int gpu_id) {
        if (gpu_id == 0 && DEFAULT_GPU_BLACKLISTED) {
            return false;
        }
        boolean hasGPU = XGBoost.hasGPU_impl(gpu_id);
        if (gpu_id == 0 && !hasGPU) {
            DEFAULT_GPU_BLACKLISTED = true;
        }
        return hasGPU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized boolean hasGPU_impl(int gpu_id) {
        DMatrix trainMat;
        if (!XGBoostExtension.isGpuSupportEnabled()) {
            return false;
        }
        if (GPUS.contains(gpu_id)) {
            return true;
        }
        try {
            trainMat = new DMatrix(new float[]{1.0f, 2.0f, 1.0f, 2.0f}, 2, 2);
            trainMat.setLabel(new float[]{1.0f, 0.0f});
        }
        catch (XGBoostError xgBoostError) {
            throw new IllegalStateException("Couldn't prepare training matrix for XGBoost.", xgBoostError);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("updater", "grow_gpu_hist");
        params.put("silent", 1);
        params.put("gpu_id", gpu_id);
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        HashMap localRabitEnv = new HashMap();
        Rabit.init(localRabitEnv);
        ml.dmlc.xgboost4j.java.XGBoost.train((DMatrix)trainMat, params, (int)1, watches, null, null);
        GPUS.add(gpu_id);
        boolean bl = true;
        try {
            Rabit.shutdown();
        }
        catch (XGBoostError e) {
            Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
        }
        return bl;
        catch (XGBoostError xgBoostError) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    Rabit.shutdown();
                }
                catch (XGBoostError e) {
                    Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
                }
                throw throwable;
            }
            try {
                Rabit.shutdown();
            }
            catch (XGBoostError e) {
                Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
            }
            return bl2;
        }
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput>[] cvModelBuilders) {
        if (((XGBoostModel.XGBoostParameters)this._parms)._stopping_rounds == 0 && ((XGBoostModel.XGBoostParameters)this._parms)._max_runtime_secs == 0.0) {
            return;
        }
        ((XGBoostModel.XGBoostParameters)this._parms)._stopping_rounds = 0;
        ((XGBoostModel.XGBoostParameters)this._parms)._max_runtime_secs = 0.0;
        int sum = 0;
        for (ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput> mb : cvModelBuilders) {
            sum += ((XGBoostOutput)((Model)DKV.getGet((Key)mb.dest()))._output)._ntrees;
        }
        ((XGBoostModel.XGBoostParameters)this._parms)._ntrees = (int)((double)sum / (double)cvModelBuilders.length);
        this.warn("_ntrees", "Setting optimal _ntrees to " + ((XGBoostModel.XGBoostParameters)this._parms)._ntrees + " for cross-validation main model based on early stopping of cross-validation models.");
        this.warn("_stopping_rounds", "Disabling convergence-based early stopping for cross-validation main model.");
        this.warn("_max_runtime_secs", "Disabling maximum allowed runtime for cross-validation main model.");
    }

    private static class HasGPUTask
    extends DTask<HasGPUTask> {
        private final int _gpu_id;
        private boolean _hasGPU;

        private HasGPUTask(int gpu_id) {
            this._gpu_id = gpu_id;
        }

        public void compute2() {
            this._hasGPU = XGBoost.hasGPU(this._gpu_id);
            this.tryComplete();
        }
    }

    private static final class BoosterProvider {
        XGBoostModelInfo _modelInfo;
        XGBoostUpdateTask _updateTask;

        BoosterProvider(XGBoostModelInfo modelInfo, XGBoostUpdateTask updateTask) {
            this._modelInfo = modelInfo;
            this._updateTask = updateTask;
            this._modelInfo.setBoosterBytes(this._updateTask.getBoosterBytes());
        }

        final void reset(XGBoostUpdateTask updateTask) {
            this._updateTask = updateTask;
        }

        final void updateBooster() {
            if (this._updateTask == null) {
                throw new IllegalStateException("Booster can be retrieved only once!");
            }
            byte[] boosterBytes = this._updateTask.getBoosterBytes();
            this._modelInfo.setBoosterBytes(boosterBytes);
        }
    }

    class XGBoostDriver
    extends ModelBuilder.Driver {
        private final String featureMapFileName;
        private String featureMapFileAbsolutePath;
        long _firstScore;
        long _timeLastScoreStart;
        long _timeLastScoreEnd;

        XGBoostDriver() {
            super((ModelBuilder)XGBoost.this);
            this.featureMapFileName = "featureMap" + UUID.randomUUID().toString() + ".txt";
            this.featureMapFileAbsolutePath = null;
            this._firstScore = 0L;
            this._timeLastScoreStart = 0L;
            this._timeLastScoreEnd = 0L;
        }

        public void computeImpl() {
            XGBoost.this.init(true);
            if (XGBoost.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)XGBoost.this);
            }
            this.buildModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void buildModel() {
            if ((XGBoostModel.XGBoostParameters.Backend.auto.equals((Object)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._backend) || XGBoostModel.XGBoostParameters.Backend.gpu.equals((Object)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._backend)) && XGBoost.hasGPU(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._gpu_id) && H2O.getCloudSize() == 1 && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).gpuIncompatibleParams().isEmpty()) {
                XGBoostGPULock xGBoostGPULock = XGBoostGPULock.lock(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._gpu_id);
                synchronized (xGBoostGPULock) {
                    this.buildModelImpl();
                }
            } else {
                this.buildModelImpl();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void buildModelImpl() {
            XGBoostModel model;
            block15: {
                model = new XGBoostModel((Key<XGBoostModel>)XGBoost.this._result, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, new XGBoostOutput(XGBoost.this), XGBoost.this._train, XGBoost.this._valid);
                model.write_lock(XGBoost.this._job);
                ((XGBoostOutput)model._output)._sparse = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.sparse ? true : (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.dense ? false : this.isTrainDatasetSparse());
                XGBoostSetupTask setupTask = null;
                try {
                    XGBoostSetupTask.FrameNodes trainFrameNodes = XGBoostSetupTask.findFrameNodes(XGBoost.this._train);
                    RabitTrackerH2O rt = new RabitTrackerH2O(trainFrameNodes.getNumNodes());
                    if (!this.startRabitTracker(rt)) {
                        throw new IllegalArgumentException("Cannot start XGboost rabit tracker, please, make sure you have python installed!");
                    }
                    DataInfo dataInfo = model.model_info().dataInfo();
                    assert (dataInfo != null);
                    String featureMap = XGBoostUtils.makeFeatureMap(XGBoost.this._train, dataInfo);
                    model.model_info().setFeatureMap(featureMap);
                    this.featureMapFileAbsolutePath = this.createFeatureMapFile(featureMap);
                    BoosterParms boosterParms = XGBoostModel.createParams((XGBoostModel.XGBoostParameters)XGBoost.this._parms, ((XGBoostOutput)model._output).nclasses(), dataInfo.coefNames());
                    ((XGBoostOutput)model._output)._native_parameters = boosterParms.toTwoDimTable();
                    setupTask = (XGBoostSetupTask)((Object)new XGBoostSetupTask(model, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, boosterParms, this.getWorkerEnvs(rt), trainFrameNodes).run());
                    try {
                        XGBoostUpdateTask nullModelTask = (XGBoostUpdateTask)((Object)new XGBoostUpdateTask(setupTask, 0).run());
                        BoosterProvider boosterProvider = new BoosterProvider(model.model_info(), nullModelTask);
                        this.scoreAndBuildTrees(setupTask, boosterProvider, model);
                        XGBoostCleanupTask.cleanUp(setupTask);
                        setupTask = null;
                        this.waitOnRabitWorkers(rt);
                    }
                    finally {
                        this.stopRabitTracker(rt);
                    }
                    if (setupTask == null) break block15;
                }
                catch (XGBoostError xgBoostError) {
                    try {
                        xgBoostError.printStackTrace();
                        throw new RuntimeException("XGBoost failure", xgBoostError);
                    }
                    catch (Throwable throwable) {
                        if (setupTask != null) {
                            try {
                                XGBoostCleanupTask.cleanUp(setupTask);
                            }
                            catch (Exception e) {
                                Log.err((Object[])new Object[]{"XGBoost clean-up failed - this could leak memory!", e});
                            }
                        }
                        model.unlock(XGBoost.this._job);
                        throw throwable;
                    }
                }
                try {
                    XGBoostCleanupTask.cleanUp(setupTask);
                }
                catch (Exception e) {
                    Log.err((Object[])new Object[]{"XGBoost clean-up failed - this could leak memory!", e});
                }
            }
            model.unlock(XGBoost.this._job);
        }

        private boolean isTrainDatasetSparse() {
            long nonZeroCount = 0L;
            int nonCategoricalColumns = 0;
            long oneHotEncodedColumns = 0L;
            for (int i = 0; i < XGBoost.this._train.numCols(); ++i) {
                if (XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._response_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._weights_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._fold_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._offset_column)) continue;
                Vec vector = XGBoost.this._train.vec(i);
                nonZeroCount = vector.isCategorical() ? (nonZeroCount += XGBoost.this._train.numRows()) : (nonZeroCount += vector.nzCnt());
                if (vector.isCategorical()) {
                    oneHotEncodedColumns += (long)vector.cardinality();
                    continue;
                }
                ++nonCategoricalColumns;
            }
            long totalColumns = oneHotEncodedColumns + (long)nonCategoricalColumns;
            double denominator = (double)totalColumns * (double)XGBoost.this._train.numRows();
            double fillRatio = (double)nonZeroCount / denominator;
            Log.info((Object[])new Object[]{"fill ratio: " + fillRatio});
            return fillRatio < 0.25 || XGBoost.this._train.numRows() * totalColumns > Integer.MAX_VALUE;
        }

        private String createFeatureMapFile(String featureMap) {
            String string;
            FileOutputStream os = null;
            try {
                File tmpModelDir = Files.createTempDirectory("xgboost-model-" + XGBoost.this._result.toString(), new FileAttribute[0]).toFile();
                File fmFile = new File(tmpModelDir, this.featureMapFileName);
                os = new FileOutputStream(fmFile);
                ((OutputStream)os).write(featureMap.getBytes());
                ((OutputStream)os).close();
                string = fmFile.getAbsolutePath();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Cannot generate feature map file " + this.featureMapFileName, e);
                }
                catch (Throwable throwable) {
                    FileUtils.close((Closeable[])new Closeable[]{os});
                    throw throwable;
                }
            }
            FileUtils.close((Closeable[])new Closeable[]{os});
            return string;
        }

        private void scoreAndBuildTrees(XGBoostSetupTask setupTask, BoosterProvider boosterProvider, XGBoostModel model) throws XGBoostError {
            for (int tid = 0; tid < ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees; ++tid) {
                boolean scored = this.doScoring(model, boosterProvider, false);
                if (scored && ScoreKeeper.stopEarly((ScoreKeeper[])((XGBoostOutput)model._output).scoreKeepers(), (int)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_rounds, (XGBoost.this._nclass > 1 ? 1 : 0) != 0, (ScoreKeeper.StoppingMetric)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_metric, (double)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_tolerance, (String)"model's last", (boolean)true)) {
                    Log.info((Object[])new Object[]{"Early stopping triggered - stopping XGBoost training"});
                    break;
                }
                Timer kb_timer = new Timer();
                XGBoostUpdateTask t = (XGBoostUpdateTask)((Object)new XGBoostUpdateTask(setupTask, tid).run());
                boosterProvider.reset(t);
                Log.info((Object[])new Object[]{tid + 1 + ". tree was built in " + kb_timer.toString()});
                XGBoost.this._job.update(1L);
                ++((XGBoostOutput)model._output)._ntrees;
                ((XGBoostOutput)model._output)._scored_train = (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_train, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper());
                ((XGBoostOutput)model._output)._scored_valid = ((XGBoostOutput)model._output)._scored_valid != null ? (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_valid, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper()) : null;
                ((XGBoostOutput)model._output)._training_time_ms = ArrayUtils.copyAndFillOf((long[])((XGBoostOutput)model._output)._training_time_ms, (int)(((XGBoostOutput)model._output)._ntrees + 1), (long)System.currentTimeMillis());
                if (XGBoost.this.stop_requested() && !XGBoost.this.timeout()) {
                    throw new Job.JobCancelledException();
                }
                if (!XGBoost.this.timeout()) continue;
                Log.info((Object[])new Object[]{"Stopping XGBoost training because of timeout"});
                break;
            }
            XGBoost.this._job.update(0L, "Scoring the final model");
            this.doScoring(model, boosterProvider, true);
            XGBoost.this._job.update((long)(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees - ((XGBoostOutput)model._output)._ntrees));
        }

        private boolean startRabitTracker(IRabitTracker rt) {
            if (H2O.CLOUD.size() > 1) {
                return rt.start(0L);
            }
            return true;
        }

        private void waitOnRabitWorkers(IRabitTracker rt) {
            if (H2O.CLOUD.size() > 1) {
                rt.waitFor(0L);
            }
        }

        private void stopRabitTracker(IRabitTracker rt) {
            if (H2O.CLOUD.size() > 1) {
                rt.stop();
            }
        }

        private Map<String, String> getWorkerEnvs(IRabitTracker rt) {
            if (H2O.CLOUD.size() > 1) {
                return rt.getWorkerEnvs();
            }
            return new HashMap<String, String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean doScoring(XGBoostModel model, BoosterProvider boosterProvider, boolean finalScoring) throws XGBoostError {
            Map varimp;
            XGBoostOutput out;
            block5: {
                boolean manualInterval;
                boolean scored = false;
                long now = System.currentTimeMillis();
                if (this._firstScore == 0L) {
                    this._firstScore = now;
                }
                long sinceLastScore = now - this._timeLastScoreStart;
                XGBoost.this._job.update(0L, "Built " + ((XGBoostOutput)model._output)._ntrees + " trees so far (out of " + ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees + ").");
                boolean timeToScore = now - this._firstScore < (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._initial_score_interval || sinceLastScore > (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_interval && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1;
                boolean bl = manualInterval = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval > 0 && ((XGBoostOutput)model._output)._ntrees % ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0;
                if (!(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_each_iteration || finalScoring || timeToScore && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0)) {
                    if (!manualInterval) return scored;
                }
                this._timeLastScoreStart = now;
                boosterProvider.updateBooster();
                model.doScoring(XGBoost.this._train, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).train(), XGBoost.this._valid, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).valid());
                this._timeLastScoreEnd = System.currentTimeMillis();
                out = (XGBoostOutput)model._output;
                Booster booster = null;
                try {
                    booster = model.model_info().deserializeBooster();
                    varimp = (Map)BoosterHelper.doWithLocalRabit((BoosterHelper.BoosterOp)new BoosterHelper.BoosterOp<Map<String, XGBoostUtils.FeatureScore>>(){

                        public Map<String, XGBoostUtils.FeatureScore> apply(Booster booster) throws XGBoostError {
                            String[] modelDump = booster.getModelDump(XGBoostDriver.this.featureMapFileAbsolutePath, true);
                            return XGBoostUtils.parseFeatureScores(modelDump);
                        }
                    }, (Booster)booster);
                    if (booster == null) break block5;
                }
                catch (Throwable throwable) {
                    if (booster == null) throw throwable;
                    BoosterHelper.dispose((Object[])new Object[]{booster});
                    throw throwable;
                }
                BoosterHelper.dispose((Object[])new Object[]{booster});
            }
            out._varimp = XGBoost.computeVarImp(varimp);
            out._model_summary = SharedTree.createModelSummaryTable((int)out._ntrees, null);
            out._scoring_history = SharedTree.createScoringHistoryTable((Model.Output)out, (ScoreKeeper[])((XGBoostOutput)model._output)._scored_train, (ScoreKeeper[])out._scored_valid, (Job)XGBoost.this._job, (long[])out._training_time_ms, (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._custom_metric_func != null ? 1 : 0) != 0);
            if (out._varimp != null) {
                out._variable_importances = XGBoost.createVarImpTable(null, ArrayUtils.toDouble((float[])out._varimp._varimp), out._varimp._names);
                out._variable_importances_cover = XGBoost.createVarImpTable("Cover", ArrayUtils.toDouble((float[])out._varimp._covers), out._varimp._names);
                out._variable_importances_frequency = XGBoost.createVarImpTable("Frequency", ArrayUtils.toDouble((int[])out._varimp._freqs), out._varimp._names);
            }
            model.update(XGBoost.this._job);
            Log.info((Object[])new Object[]{model});
            return true;
        }
    }
}

