/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import java.io.IOException;
import java.util.Arrays;
import ml.dmlc.xgboost4j.java.INativeLibLoader;
import ml.dmlc.xgboost4j.java.NativeLibLoader;
import ml.dmlc.xgboost4j.java.NativeLibrary;
import ml.dmlc.xgboost4j.java.NativeLibraryLoaderChain;
import water.AbstractH2OExtension;
import water.util.Log;

public class XGBoostExtension
extends AbstractH2OExtension {
    private static String XGBOOST_MIN_REQUIREMENTS = "Xgboost (enabled GPUs) needs: \n  - CUDA 8.0\nXGboost (minimal version) needs: \n  - GCC 4.7+\nFor more details, run in debug mode: `java -Dlog4j.configuration=file:///tmp/log4j.properties -jar h2o.jar`\n";
    private boolean isInitCalled = false;
    private boolean isXgboostPresent = false;
    private NativeLibInfo nativeLibInfo = null;
    public static String NAME = "XGBoost";

    public String getExtensionName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        if (!this.isInitCalled) {
            XGBoostExtension xGBoostExtension = this;
            synchronized (xGBoostExtension) {
                if (!this.isInitCalled) {
                    this.isXgboostPresent = this.initXgboost();
                    this.isInitCalled = true;
                }
            }
        }
        return this.isXgboostPresent;
    }

    public void logNativeLibInfo() {
        Log.info((Object[])new Object[]{"Found XGBoost backend with library: " + this.nativeLibInfo.name});
        if (this.nativeLibInfo.flags.length == 0) {
            Log.warn((Object[])new Object[]{"Your system supports only minimal version of XGBoost (no GPUs, no multithreading)!"});
        } else {
            Log.info((Object[])new Object[]{"XGBoost supported backends: " + Arrays.toString(this.nativeLibInfo.flags)});
        }
    }

    private boolean initXgboost() {
        try {
            INativeLibLoader loader = NativeLibLoader.getLoader();
            if (!(loader instanceof NativeLibraryLoaderChain)) {
                Log.warn((Object[])new Object[]{"Unexpected XGBoost library loader found. Custom loaders are not supported in this version. XGBoost extension will be disabled."});
                return false;
            }
            NativeLibraryLoaderChain chainLoader = (NativeLibraryLoaderChain)loader;
            NativeLibrary lib = chainLoader.getLoadedLibrary();
            this.nativeLibInfo = new NativeLibInfo(lib);
            return true;
        }
        catch (IOException e) {
            Log.warn((Object[])new Object[]{"Cannot initialize XGBoost backend! " + XGBOOST_MIN_REQUIREMENTS});
            return false;
        }
    }

    static boolean isGpuSupportEnabled() {
        try {
            INativeLibLoader loader = NativeLibLoader.getLoader();
            if (!(loader instanceof NativeLibraryLoaderChain)) {
                return false;
            }
            NativeLibraryLoaderChain chainLoader = (NativeLibraryLoaderChain)loader;
            NativeLibrary lib = chainLoader.getLoadedLibrary();
            return lib.hasCompilationFlag(NativeLibrary.CompilationFlags.WITH_GPU);
        }
        catch (IOException e) {
            Log.debug((Object[])new Object[]{e});
            return false;
        }
    }

    private static class NativeLibInfo {
        String name;
        NativeLibrary.CompilationFlags[] flags;

        private NativeLibInfo(NativeLibrary nl) {
            this.name = nl.getName();
            this.flags = nl.getCompilationFlags();
        }
    }
}

