/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.rabit;

import hex.tree.xgboost.rabit.communication.XGBoostAutoBuffer;
import hex.tree.xgboost.rabit.util.LinkMap;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import water.AutoBuffer;
import water.ExternalFrameUtils;
import water.util.Log;

public class RabitWorker
implements Comparable<RabitWorker> {
    final String host;
    final int workerPort;
    private SocketChannel socket;
    int rank;
    int worldSize;
    String jobId;
    public String cmd;
    int waitAccept;
    private int port;
    private XGBoostAutoBuffer ab;
    private XGBoostAutoBuffer writerAB;

    RabitWorker(SocketChannel channel) throws IOException {
        this.ab = new XGBoostAutoBuffer(channel);
        this.socket = channel;
        this.host = channel.socket().getInetAddress().getHostAddress();
        this.workerPort = channel.socket().getPort();
        int magicReceived = this.ab.get4();
        if (65433 != magicReceived) {
            throw new IllegalStateException("Tracker received wrong magic number [" + magicReceived + "] from host " + this.host);
        }
        this.writerAB = new XGBoostAutoBuffer();
        this.writerAB.put4(65433);
        ExternalFrameUtils.writeToChannel((AutoBuffer)this.writerAB.buffer(), (ByteChannel)this.socket);
        this.rank = this.ab.get4();
        this.worldSize = this.ab.get4();
        this.jobId = this.safeLowercase(this.ab.getStr());
        this.cmd = this.safeLowercase(this.ab.getStr());
        this.waitAccept = 0;
        this.port = -1;
        Log.debug((Object[])new Object[]{"Initialized worker " + this.host + " with rank " + this.rank + " and command [" + this.cmd + "]."});
    }

    private String safeLowercase(String str) {
        return null == str ? null : str.toLowerCase();
    }

    int decideRank(Map<String, Integer> jobToRankMap) {
        if (this.rank >= 0) {
            return this.rank;
        }
        if (!"null".equals(this.jobId) && jobToRankMap.containsKey(this.jobId)) {
            return jobToRankMap.get(this.jobId);
        }
        return -1;
    }

    public XGBoostAutoBuffer receiver() {
        return this.ab;
    }

    public void assignRank(int rank, Map<Integer, RabitWorker> waitConn, LinkMap linkMap) throws IOException {
        HashSet<Integer> conset;
        HashSet<Integer> badSet;
        int nerr;
        this.rank = rank;
        List<Integer> nnset = linkMap.treeMap.get(rank);
        Integer rprev = (Integer)linkMap.ringMap.get(rank)._1();
        Integer rnext = (Integer)linkMap.ringMap.get(rank)._2();
        this.writerAB.put4(rank);
        this.writerAB.put4(linkMap.parentMap.get(rank));
        this.writerAB.put4(linkMap.treeMap.size());
        this.writerAB.put4(nnset.size());
        for (Integer r : nnset) {
            this.writerAB.put4(r);
        }
        if (rprev != -1 && rprev != rank) {
            nnset.add(rprev);
            this.writerAB.put4(rprev);
        } else {
            this.writerAB.put4(-1);
        }
        if (rnext != -1 && rnext != rank) {
            nnset.add(rnext);
            this.writerAB.put4(rnext);
        } else {
            this.writerAB.put4(-1);
        }
        ExternalFrameUtils.writeToChannel((AutoBuffer)this.writerAB.buffer(), (ByteChannel)this.socket);
        do {
            int ngood = this.ab.get4();
            HashSet<Integer> goodSet = new HashSet<Integer>();
            for (int i = 0; i < ngood; ++i) {
                int got = this.ab.get4();
                goodSet.add(got);
            }
            assert (nnset.containsAll(goodSet));
            badSet = new HashSet<Integer>(nnset);
            badSet.removeAll(goodSet);
            conset = new HashSet<Integer>();
            for (Integer r : badSet) {
                if (!waitConn.containsKey(r)) continue;
                conset.add(r);
            }
            this.writerAB.put4(conset.size());
            ExternalFrameUtils.writeToChannel((AutoBuffer)this.writerAB.buffer(), (ByteChannel)this.socket);
            this.writerAB.put4(badSet.size() - conset.size());
            ExternalFrameUtils.writeToChannel((AutoBuffer)this.writerAB.buffer(), (ByteChannel)this.socket);
            for (Integer r : conset) {
                this.writerAB.putStr(waitConn.get((Object)r).host);
                this.writerAB.put4(waitConn.get((Object)r).port);
                this.writerAB.put4(r);
                ExternalFrameUtils.writeToChannel((AutoBuffer)this.writerAB.buffer(), (ByteChannel)this.socket);
            }
        } while ((nerr = this.ab.get4()) != 0);
        this.port = this.ab.get4();
        HashSet<Integer> rmset = new HashSet<Integer>();
        for (Integer r : conset) {
            --waitConn.get((Object)r).waitAccept;
            if (waitConn.get((Object)r).waitAccept != 0) continue;
            rmset.add(r);
        }
        for (Integer r : rmset) {
            waitConn.remove(r);
        }
        this.waitAccept = badSet.size() - conset.size();
    }

    @Override
    public int compareTo(RabitWorker o) {
        return this.host.compareTo(o.host);
    }
}

