/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import hex.tree.xgboost.XGBoost;
import hex.tree.xgboost.XGBoostModel;
import ml.dmlc.xgboost4j.java.AbstractXGBoostTask;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.XGBoostSetupTask;
import ml.dmlc.xgboost4j.java.XGBoostUpdater;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.RPC;
import water.util.Log;

public class XGBoostUpdateTask
extends AbstractXGBoostTask<XGBoostUpdateTask> {
    private final int _tid;

    public XGBoostUpdateTask(XGBoostSetupTask setupTask, int tid) {
        super(setupTask);
        this._tid = tid;
    }

    @Override
    protected void execute() {
        Booster booster = XGBoostUpdater.getUpdater((Key<XGBoostModel>)this._modelKey).doUpdate(this._tid);
        if (booster == null) {
            throw new IllegalStateException("Boosting iteration didn't produce a valid Booster.");
        }
    }

    public byte[] getBoosterBytes() {
        byte[] boosterBytes;
        H2ONode boosterNode = this.getBoosterNode();
        if (H2O.SELF.equals((Object)boosterNode)) {
            boosterBytes = XGBoost.getRawArray(XGBoostUpdater.getUpdater((Key<XGBoostModel>)this._modelKey).getBooster());
        } else {
            Log.debug((Object[])new Object[]{"Booster will be retrieved from a remote node, node=" + boosterNode});
            FetchBoosterTask t = new FetchBoosterTask(this._modelKey);
            boosterBytes = ((FetchBoosterTask)new RPC(boosterNode, (DTask)t).call().get())._boosterBytes;
        }
        return boosterBytes;
    }

    private static class FetchBoosterTask
    extends DTask<FetchBoosterTask> {
        private final Key<XGBoostModel> _modelKey;
        private byte[] _boosterBytes;

        private FetchBoosterTask(Key<XGBoostModel> modelKey) {
            this._modelKey = modelKey;
        }

        public void compute2() {
            this._boosterBytes = XGBoostUpdater.getUpdater(this._modelKey).getBoosterBytes();
            this.tryComplete();
        }
    }
}

