/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import hex.tree.xgboost.matrix.DenseMatrixFactory;
import hex.tree.xgboost.matrix.SparseMatrixFactory;
import hex.tree.xgboost.util.FeatureScore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.H2O;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;
import water.util.VecUtils;

public class XGBoostUtils {
    public static String makeFeatureMap(Frame f, DataInfo di) {
        String[] coefnames = di.coefNames();
        StringBuilder sb = new StringBuilder();
        assert (coefnames.length == di.fullN());
        int catCols = di._catOffsets[di._catOffsets.length - 1];
        for (int i = 0; i < di.fullN(); ++i) {
            sb.append(i).append(" ").append(coefnames[i].replaceAll("\\s*", "")).append(" ");
            if (i < catCols || f.vec(i - catCols).isBinary()) {
                sb.append("i");
            } else if (f.vec(i - catCols).isInt()) {
                sb.append("int");
            } else {
                sb.append("q");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static DMatrix convertFrameToDMatrix(DataInfo di, Frame frame, String response, String weight, boolean sparse) throws XGBoostError {
        DMatrix trainMat;
        int[] nRowsByChunk;
        Vec weightVec;
        Vec responseVec;
        assert (di != null);
        int[] chunks = VecUtils.getLocalChunkIds((Vec)frame.anyVec());
        long nRowsL = XGBoostUtils.sumChunksLength(chunks, responseVec = frame.vec(response), weightVec = frame.vec(weight), nRowsByChunk = new int[chunks.length]);
        if (nRowsL > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("XGBoost currently doesn't support datasets with more than 2147483647 per node. To train a XGBoost model on this dataset add more nodes to your H2O cluster and use distributed training.");
        }
        int nRows = (int)nRowsL;
        float[] resp = MemoryManager.malloc4f((int)nRows);
        float[] weights = null;
        if (weightVec != null) {
            weights = MemoryManager.malloc4f((int)nRows);
        }
        if (sparse) {
            Log.debug((Object[])new Object[]{"Treating matrix as sparse."});
            trainMat = SparseMatrixFactory.csr(frame, chunks, weightVec, responseVec, di, resp, weights);
        } else {
            Log.debug((Object[])new Object[]{"Treating matrix as dense."});
            trainMat = DenseMatrixFactory.dense(frame, chunks, nRows, nRowsByChunk, weightVec, responseVec, di, resp, weights);
        }
        assert (trainMat.rowNum() == (long)nRows);
        trainMat.setLabel(resp);
        if (weights != null) {
            trainMat.setWeight(weights);
        }
        return trainMat;
    }

    private static long sumChunksLength(int[] chunkIds, Vec vec, Vec weightsVector, int[] chunkLengths) {
        for (int i = 0; i < chunkIds.length; ++i) {
            int chunk = chunkIds[i];
            chunkLengths[i] = vec.chunkLen(chunk);
            if (weightsVector == null) continue;
            Chunk weightVecChunk = weightsVector.chunkForChunkIdx(chunk);
            if (weightVecChunk.atd(0) == 0.0) {
                int n = i;
                chunkLengths[n] = chunkLengths[n] - 1;
            }
            int nzIndex = 0;
            while ((nzIndex = weightVecChunk.nextNZ(nzIndex, true)) >= 0 && nzIndex < weightVecChunk._len) {
                if (weightVecChunk.atd(nzIndex) != 0.0) continue;
                int n = i;
                chunkLengths[n] = chunkLengths[n] - 1;
            }
        }
        long totalChunkLength = 0L;
        for (int cl : chunkLengths) {
            totalChunkLength += (long)cl;
        }
        return totalChunkLength;
    }

    public static DMatrix convertChunksToDMatrix(DataInfo di, Chunk[] chunks, int response, boolean sparse) throws XGBoostError {
        DMatrix trainMat;
        int nRows = chunks[0]._len;
        float[] resp = MemoryManager.malloc4f((int)nRows);
        try {
            if (sparse) {
                Log.debug((Object[])new Object[]{"Treating matrix as sparse."});
                trainMat = SparseMatrixFactory.csr(chunks, -1, response, di, resp, null);
            } else {
                trainMat = DenseMatrixFactory.dense(chunks, di, response, resp, null);
            }
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
        }
        int len = (int)trainMat.rowNum();
        resp = Arrays.copyOf(resp, len);
        trainMat.setLabel(resp);
        return trainMat;
    }

    public static FeatureProperties assembleFeatureNames(DataInfo di) {
        String[] coefnames = di.coefNames();
        assert (coefnames.length == di.fullN());
        int numCatCols = di._catOffsets[di._catOffsets.length - 1];
        String[] featureNames = new String[di.fullN()];
        boolean[] oneHotEncoded = new boolean[di.fullN()];
        for (int i = 0; i < di.fullN(); ++i) {
            featureNames[i] = coefnames[i];
            if (i >= numCatCols) continue;
            oneHotEncoded[i] = true;
        }
        return new FeatureProperties(featureNames, oneHotEncoded);
    }

    static Map<String, FeatureScore> parseFeatureScores(String[] modelDump) {
        HashMap<String, FeatureScore> featureScore = new HashMap<String, FeatureScore>();
        for (String tree : modelDump) {
            for (String node : tree.split("\n")) {
                String[] keyValues;
                String[] content;
                String[] array = node.split("\\[", 2);
                if (array.length < 2 || (content = array[1].split("\\]", 2)).length < 2) continue;
                String fid = content[0].split("<")[0];
                FeatureScore fs = new FeatureScore();
                for (String keyValue : keyValues = content[1].split(",")) {
                    if (keyValue.startsWith("gain=")) {
                        fs._gain = Float.parseFloat(keyValue.substring("gain".length() + 1));
                        continue;
                    }
                    if (!keyValue.startsWith("cover=")) continue;
                    fs._cover = Float.parseFloat(keyValue.substring("cover".length() + 1));
                }
                fs._frequency = 1;
                if (featureScore.containsKey(fid)) {
                    ((FeatureScore)featureScore.get(fid)).add(fs);
                    continue;
                }
                featureScore.put(fid, fs);
            }
        }
        return featureScore;
    }

    static class FeatureProperties {
        public String[] _names;
        public boolean[] _oneHotEncoded;

        public FeatureProperties(String[] names, boolean[] oneHotEncoded) {
            this._names = names;
            this._oneHotEncoded = oneHotEncoded;
        }
    }
}

