/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import hex.tree.xgboost.BoosterParms;
import hex.tree.xgboost.XGBoostModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.Rabit;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.H2O;
import water.Key;
import water.nbhm.NonBlockingHashMap;
import water.util.Log;

public class XGBoostUpdater
extends Thread {
    private static long WORK_START_TIMEOUT_SECS = 300L;
    private static long INACTIVE_CHECK_INTERVAL_SECS = 60L;
    private static final NonBlockingHashMap<Key<XGBoostModel>, XGBoostUpdater> updaters = new NonBlockingHashMap();
    private final Key<XGBoostModel> _modelKey;
    private final DMatrix _trainMat;
    private final BoosterParms _boosterParms;
    private final byte[] _checkpointBoosterBytes;
    private final Map<String, String> _rabitEnv;
    private volatile SynchronousQueue<BoosterCallable<?>> _in;
    private volatile SynchronousQueue<Object> _out;
    private Booster _booster;

    private XGBoostUpdater(Key<XGBoostModel> modelKey, DMatrix trainMat, BoosterParms boosterParms, byte[] checkpointBoosterBytes, Map<String, String> rabitEnv) {
        super("XGBoostUpdater-" + modelKey);
        this._modelKey = modelKey;
        this._trainMat = trainMat;
        this._boosterParms = boosterParms;
        this._checkpointBoosterBytes = checkpointBoosterBytes;
        this._rabitEnv = rabitEnv;
        this._in = new SynchronousQueue();
        this._out = new SynchronousQueue();
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block29: {
            Rabit.init(this._rabitEnv);
            while (!XGBoostUpdater.interrupted()) {
                BoosterCallable<?> task = this._in.take();
                Object result = task.call();
                this._out.put(result);
            }
            this._in = null;
            this._out = null;
            updaters.remove(this._modelKey);
            try {
                this._trainMat.dispose();
                if (this._booster != null) {
                    this._booster.dispose();
                }
            }
            catch (Exception e) {
                Log.warn((Object[])new Object[]{"Failed to dispose of training matrix/booster", e});
            }
            try {
                Rabit.shutdown();
            }
            catch (Exception xgBoostError) {
                Log.warn((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
            }
            break block29;
            catch (InterruptedException e) {
                XGBoostUpdater self = (XGBoostUpdater)updaters.get(this._modelKey);
                if (self != null) {
                    Log.err((Object[])new Object[]{"Updater thread was interrupted while it was still registered, name=" + self.getName()});
                    Log.err((Throwable)e);
                } else {
                    Log.debug((Object[])new Object[]{"Updater thread interrupted.", e});
                }
                this._in = null;
                this._out = null;
                updaters.remove(this._modelKey);
                try {
                    this._trainMat.dispose();
                    if (this._booster != null) {
                        this._booster.dispose();
                    }
                }
                catch (Exception e2) {
                    Log.warn((Object[])new Object[]{"Failed to dispose of training matrix/booster", e2});
                }
                try {
                    Rabit.shutdown();
                }
                catch (Exception xgBoostError) {
                    Log.warn((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
                }
            }
            catch (XGBoostError e2) {
                Log.err((Object[])new Object[]{"XGBoost training iteration failed"});
                Log.err((Throwable)e2);
                this._in = null;
                this._out = null;
                {
                    catch (Throwable throwable) {
                        this._in = null;
                        this._out = null;
                        updaters.remove(this._modelKey);
                        try {
                            this._trainMat.dispose();
                            if (this._booster != null) {
                                this._booster.dispose();
                            }
                        }
                        catch (Exception e3) {
                            Log.warn((Object[])new Object[]{"Failed to dispose of training matrix/booster", e3});
                        }
                        try {
                            Rabit.shutdown();
                        }
                        catch (Exception xgBoostError) {
                            Log.warn((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
                        }
                        throw throwable;
                    }
                }
                updaters.remove(this._modelKey);
                try {
                    this._trainMat.dispose();
                    if (this._booster != null) {
                        this._booster.dispose();
                    }
                }
                catch (Exception e4) {
                    Log.warn((Object[])new Object[]{"Failed to dispose of training matrix/booster", e4});
                }
                try {
                    Rabit.shutdown();
                }
                catch (Exception xgBoostError) {
                    Log.warn((Object[])new Object[]{"Rabit shutdown during update failed", xgBoostError});
                }
            }
        }
    }

    private <T> T invoke(BoosterCallable<T> callable) throws InterruptedException {
        SynchronousQueue<Object> outQ;
        SynchronousQueue<BoosterCallable<?>> inQ = this._in;
        if (inQ == null) {
            throw new IllegalStateException("Updater is inactive on node " + H2O.SELF);
        }
        if (!inQ.offer(callable, WORK_START_TIMEOUT_SECS, TimeUnit.SECONDS)) {
            throw new IllegalStateException("XGBoostUpdater couldn't start work on task " + callable + " in " + WORK_START_TIMEOUT_SECS + "s.");
        }
        int i = 0;
        while ((outQ = this._out) != null) {
            ++i;
            Object result = outQ.poll(INACTIVE_CHECK_INTERVAL_SECS, TimeUnit.SECONDS);
            if (result != null) {
                return (T)result;
            }
            if (i <= 5) continue;
            Log.warn((Object[])new Object[]{String.format("XGBoost task of type '%s' is taking unexpectedly long, it didn't finish in %d seconds.", callable, INACTIVE_CHECK_INTERVAL_SECS * (long)i)});
        }
        throw new IllegalStateException("Cannot perform booster operation: updater is inactive on node " + H2O.SELF);
    }

    Booster getBooster() {
        return this._booster;
    }

    byte[] getBoosterBytes() {
        try {
            return this.invoke(new SerializeBooster());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to serialize Booster - operation was interrupted", e);
        }
    }

    Booster doUpdate(int tid) {
        try {
            return this.invoke(new UpdateBooster(tid));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Boosting iteration failed - operation was interrupted", e);
        }
    }

    static XGBoostUpdater make(Key<XGBoostModel> modelKey, DMatrix trainMat, BoosterParms boosterParms, byte[] checkpoint, Map<String, String> rabitEnv) {
        XGBoostUpdater updater = new XGBoostUpdater(modelKey, trainMat, boosterParms, checkpoint, rabitEnv);
        updater.setUncaughtExceptionHandler(LoggingExceptionHandler.INSTANCE);
        if (updaters.putIfAbsent(modelKey, (Object)updater) != null) {
            throw new IllegalStateException("XGBoostUpdater for modelKey=" + modelKey + " already exists!");
        }
        return updater;
    }

    static void terminate(Key<XGBoostModel> modelKey) {
        XGBoostUpdater updater = (XGBoostUpdater)updaters.remove(modelKey);
        if (updater == null) {
            Log.debug((Object[])new Object[]{"XGBoostUpdater for modelKey=" + modelKey + " was already clean-up on node " + H2O.SELF});
        } else {
            updater.interrupt();
        }
    }

    static XGBoostUpdater getUpdater(Key<XGBoostModel> modelKey) {
        XGBoostUpdater updater = (XGBoostUpdater)updaters.get(modelKey);
        if (updater == null) {
            throw new IllegalStateException("XGBoostUpdater for modelKey=" + modelKey + " was not found!");
        }
        return updater;
    }

    private static class LoggingExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static LoggingExceptionHandler INSTANCE = new LoggingExceptionHandler();

        private LoggingExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Log.err((Object[])new Object[]{"Uncaught exception in " + t.getName()});
            Log.err((Throwable)e);
        }
    }

    private static interface BoosterCallable<E> {
        public E call() throws XGBoostError;
    }

    private class SerializeBooster
    implements BoosterCallable<byte[]> {
        private SerializeBooster() {
        }

        @Override
        public byte[] call() throws XGBoostError {
            return XGBoostUpdater.this._booster.toByteArray();
        }

        public String toString() {
            return "SerializeBooster";
        }
    }

    private class UpdateBooster
    implements BoosterCallable<Booster> {
        private final int _tid;

        private UpdateBooster(int tid) {
            this._tid = tid;
        }

        @Override
        public Booster call() throws XGBoostError {
            if (XGBoostUpdater.this._booster == null && this._tid == 0) {
                HashMap watches = new HashMap();
                Booster checkpointBooster = null;
                if (XGBoostUpdater.this._checkpointBoosterBytes != null) {
                    try {
                        checkpointBooster = XGBoost.loadModel((InputStream)new ByteArrayInputStream(XGBoostUpdater.this._checkpointBoosterBytes));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load checkpoint booster.");
                    }
                }
                XGBoostUpdater.this._booster = XGBoost.train((DMatrix)XGBoostUpdater.this._trainMat, XGBoostUpdater.this._boosterParms.get(), (int)0, watches, (float[][])null, null, null, (int)0, (Booster)checkpointBooster);
                byte[] boosterBytes = XGBoostUpdater.this._booster.toByteArray();
                Log.info((Object[])new Object[]{"Initial Booster created, size=" + boosterBytes.length});
            } else {
                assert (XGBoostUpdater.this._booster != null);
                XGBoostUpdater.this._booster.update(XGBoostUpdater.this._trainMat, this._tid);
                XGBoostUpdater.this._booster.saveRabitCheckpoint();
            }
            return XGBoostUpdater.this._booster;
        }

        public String toString() {
            return "Boosting Iteration (tid=" + this._tid + ")";
        }
    }
}

