/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.util;

import hex.tree.xgboost.util.NativeLibrary;
import java.io.IOException;
import java.util.LinkedList;
import ml.dmlc.xgboost4j.java.INativeLibLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLibraryLoaderChain
implements INativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibraryLoaderChain.class);
    private final NativeLibrary[] nativeLibs;
    private NativeLibrary successfullyLoaded = null;

    public NativeLibraryLoaderChain() {
        this(NativeLibrary.nativeLibrary("xgboost4j_gpu", new NativeLibrary.CompilationFlags[]{NativeLibrary.CompilationFlags.WITH_GPU, NativeLibrary.CompilationFlags.WITH_OMP}), NativeLibrary.nativeLibrary("xgboost4j_omp", new NativeLibrary.CompilationFlags[]{NativeLibrary.CompilationFlags.WITH_OMP}), NativeLibrary.nativeLibrary("xgboost4j_minimal", NativeLibrary.EMPTY_COMPILATION_FLAGS));
    }

    private NativeLibraryLoaderChain(NativeLibrary ... libs) {
        assert (libs != null) : "Argument `libs` cannot be null.";
        this.nativeLibs = libs;
    }

    public void loadNativeLibs() throws IOException {
        LinkedList<IOException> exs = new LinkedList<IOException>();
        for (NativeLibrary lib : this.nativeLibs) {
            try {
                if (!lib.load()) continue;
                this.successfullyLoaded = lib;
                break;
            }
            catch (IOException e) {
                logger.info((Object)("Cannot load library: " + lib.toString()));
                exs.add(e);
            }
        }
        if (this.successfullyLoaded == null && !exs.isEmpty()) {
            throw new IOException((Throwable)exs.getLast());
        }
    }

    public String name() {
        return "NativeLibraryLoaderChain";
    }

    public int priority() {
        return 1;
    }

    public NativeLibrary getLoadedLibrary() throws IOException {
        if (this.successfullyLoaded != null) {
            return this.successfullyLoaded;
        }
        throw new IOException("No binary library found!");
    }
}

