/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import biz.k11i.xgboost.gbm.GBTree;
import biz.k11i.xgboost.gbm.GradBooster;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeNode;
import hex.DataInfo;
import hex.KeyValue;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.genmodel.algos.xgboost.XGBoostJavaMojoModel;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLMTask;
import hex.tree.PlattScalingHelper;
import hex.tree.SharedTree;
import hex.tree.TreeUtils;
import hex.tree.xgboost.BoosterParms;
import hex.tree.xgboost.XGBoostExtension;
import hex.tree.xgboost.XGBoostExtensionCheck;
import hex.tree.xgboost.XGBoostGPULock;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.XGBoostUtils;
import hex.tree.xgboost.XgbVarImp;
import hex.tree.xgboost.rabit.RabitTrackerH2O;
import hex.tree.xgboost.util.BoosterHelper;
import hex.tree.xgboost.util.FeatureScore;
import hex.util.CheckpointUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.Rabit;
import ml.dmlc.xgboost4j.java.XGBoostCleanupTask;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostModelInfo;
import ml.dmlc.xgboost4j.java.XGBoostSetupTask;
import ml.dmlc.xgboost4j.java.XGBoostUpdateTask;
import water.DKV;
import water.DTask;
import water.ExtensionManager;
import water.H2O;
import water.H2ONode;
import water.Job;
import water.Key;
import water.Paxos;
import water.RPC;
import water.Scope;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.Timer;
import water.util.TwoDimTable;

public class XGBoost
extends ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput>
implements PlattScalingHelper.ModelBuilderWithCalibration<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput> {
    private static final double FILL_RATIO_THRESHOLD = 0.25;
    private int _ntrees;
    private XGBoostModel.XGBoostParameters.Backend _backend;
    private transient Frame _calib;
    private static volatile boolean DEFAULT_GPU_BLACKLISTED = false;
    private static Set<Integer> GPUS = new HashSet<Integer>();

    public boolean haveMojo() {
        return true;
    }

    public boolean havePojo() {
        return true;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        if (ExtensionManager.getInstance().isCoreExtensionsEnabled(XGBoostExtension.NAME)) {
            return ModelBuilder.BuilderVisibility.Stable;
        }
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public XGBoost(XGBoostModel.XGBoostParameters parms, Key<XGBoostModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    public XGBoost(boolean startup_once) {
        super((Model.Parameters)new XGBoostModel.XGBoostParameters(), startup_once);
    }

    public boolean isSupervised() {
        return true;
    }

    protected int nModelsInParallel(int folds) {
        if (this._backend == XGBoostModel.XGBoostParameters.Backend.gpu) {
            return 1;
        }
        return this.nModelsInParallel(folds, 2);
    }

    protected XGBoostDriver trainModelImpl() {
        return new XGBoostDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (H2O.CLOUD.size() > 1) {
            if (H2O.SELF.getSecurityManager().securityEnabled && !H2O.ARGS.allow_insecure_xgboost) {
                throw new H2OIllegalArgumentException("Cannot run XGBoost on an SSL enabled cluster larger than 1 node. XGBoost does not support SSL encryption.");
            }
            Log.info((Object[])new Object[]{"Executing XGBoost on an secured cluster might compromise security."});
        }
        if (H2O.ARGS.client && ((XGBoostModel.XGBoostParameters)this._parms)._build_tree_one_node) {
            this.error("_build_tree_one_node", "Cannot run on a single node in client mode.");
        }
        if (expensive) {
            if (this._response.naCnt() > 0L) {
                this.error("_response_column", "Response contains missing values (NAs) - not supported by XGBoost.");
            }
            if (!((XGBoostExtensionCheck)new XGBoostExtensionCheck().doAllNodes()).enabled) {
                this.error("XGBoost", "XGBoost is not available on all nodes!");
            }
        }
        this._backend = !Paxos._cloudLocked ? XGBoostModel.XGBoostParameters.Backend.cpu : XGBoostModel.getActualBackend((XGBoostModel.XGBoostParameters)this._parms);
        if (((XGBoostModel.XGBoostParameters)this._parms).hasCheckpoint()) {
            Value cv = DKV.get((Key)((XGBoostModel.XGBoostParameters)this._parms)._checkpoint);
            if (cv != null) {
                XGBoostModel checkpointModel = (XGBoostModel)CheckpointUtils.getAndValidateCheckpointModel((ModelBuilder)this, (String[])XGBoostModel.XGBoostParameters.CHECKPOINT_NON_MODIFIABLE_FIELDS, (Value)cv);
                this._ntrees = ((XGBoostModel.XGBoostParameters)this._parms)._ntrees - ((XGBoostOutput)checkpointModel._output)._ntrees;
            }
        } else {
            this._ntrees = ((XGBoostModel.XGBoostParameters)this._parms)._ntrees;
        }
        if (expensive && this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._backend == XGBoostModel.XGBoostParameters.Backend.gpu) {
            Map<String, Object> incompats;
            if (!XGBoost.hasGPU(((XGBoostModel.XGBoostParameters)this._parms)._gpu_id)) {
                this.error("_backend", "GPU backend (gpu_id: " + ((XGBoostModel.XGBoostParameters)this._parms)._gpu_id + ") is not functional. Check CUDA_PATH and/or GPU installation.");
            }
            if (H2O.getCloudSize() > 1) {
                this.error("_backend", "GPU backend is not supported in distributed mode.");
            }
            if (!(incompats = ((XGBoostModel.XGBoostParameters)this._parms).gpuIncompatibleParams()).isEmpty()) {
                for (Map.Entry<String, Object> incompat : incompats.entrySet()) {
                    this.error("_backend", "GPU backend is not available for parameter setting '" + incompat.getKey() + " = " + incompat.getValue() + "'. Use CPU backend instead.");
                }
            }
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            this.error("_distribution", "Quasibinomial is not supported for XGBoost in current H2O.");
        }
        switch (((XGBoostModel.XGBoostParameters)this._parms)._distribution) {
            case bernoulli: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical"));
                break;
            }
            case modified_huber: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Modified Huber requires the response to be a 2-class categorical."));
                break;
            }
            case multinomial: {
                if (this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Multinomial requires an categorical response."));
                break;
            }
            case huber: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Huber requires the response to be numeric."));
                break;
            }
            case poisson: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Poisson requires the response to be numeric."));
                break;
            }
            case gamma: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                break;
            }
            case tweedie: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                break;
            }
            case gaussian: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gaussian requires the response to be numeric."));
                break;
            }
            case laplace: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Laplace requires the response to be numeric."));
                break;
            }
            case quantile: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Quantile requires the response to be numeric."));
                break;
            }
            case AUTO: {
                break;
            }
            default: {
                this.error("_distribution", "Invalid distribution: " + ((XGBoostModel.XGBoostParameters)this._parms)._distribution);
            }
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._learn_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._learn_rate <= 1.0)) {
            this.error("_learn_rate", "learn_rate must be between 0 and 1");
        }
        if (!(0.0 < ((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate) || !(((XGBoostModel.XGBoostParameters)this._parms)._col_sample_rate <= 1.0)) {
            this.error("_col_sample_rate", "col_sample_rate must be between 0 and 1");
        }
        if (((XGBoostModel.XGBoostParameters)this._parms)._grow_policy == XGBoostModel.XGBoostParameters.GrowPolicy.lossguide && ((XGBoostModel.XGBoostParameters)this._parms)._tree_method != XGBoostModel.XGBoostParameters.TreeMethod.hist) {
            this.error("_grow_policy", "must use tree_method=hist for grow_policy=lossguide");
        }
        if (this._train != null && !((XGBoostModel.XGBoostParameters)this._parms).monotoneConstraints().isEmpty()) {
            if (((XGBoostModel.XGBoostParameters)this._parms)._tree_method == XGBoostModel.XGBoostParameters.TreeMethod.approx) {
                this.error("_tree_method", "approx is not supported with _monotone_constraints, use auto/exact/hist instead");
            } else assert (((XGBoostModel.XGBoostParameters)this._parms)._tree_method == XGBoostModel.XGBoostParameters.TreeMethod.auto || ((XGBoostModel.XGBoostParameters)this._parms)._tree_method == XGBoostModel.XGBoostParameters.TreeMethod.exact || ((XGBoostModel.XGBoostParameters)this._parms)._tree_method == XGBoostModel.XGBoostParameters.TreeMethod.hist) : "Unexpected tree method used " + (Object)((Object)((XGBoostModel.XGBoostParameters)this._parms)._tree_method);
            TreeUtils.checkMonotoneConstraints((ModelBuilder)this, (Frame)this._train, (KeyValue[])((XGBoostModel.XGBoostParameters)this._parms)._monotone_constraints);
        }
        if (this._train != null && H2O.CLOUD.size() > 1 && ((XGBoostModel.XGBoostParameters)this._parms)._tree_method == XGBoostModel.XGBoostParameters.TreeMethod.exact && !((XGBoostModel.XGBoostParameters)this._parms)._build_tree_one_node) {
            this.error("_tree_method", "exact is not supported in distributed environment, set build_tree_one_node to true to use exact");
        }
        PlattScalingHelper.initCalibration((PlattScalingHelper.ModelBuilderWithCalibration)this, (PlattScalingHelper.ParamsWithCalibration)((PlattScalingHelper.ParamsWithCalibration)this._parms), (boolean)expensive);
    }

    public XGBoost getModelBuilder() {
        return this;
    }

    public Frame getCalibrationFrame() {
        return this._calib;
    }

    public void setCalibrationFrame(Frame f) {
        this._calib = f;
    }

    protected boolean canLearnFromNAs() {
        return true;
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, XGBoostModel.XGBoostParameters parms, int nClasses) {
        DataInfo dinfo = new DataInfo(train, valid, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, false, false, true, parms._weights_column != null, parms._offset_column != null, parms._fold_column != null);
        GLMTask.YMUTask ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(dinfo, nClasses, nClasses == 1, false, true, true).doAll(dinfo._adaptedFrame);
        if (parms._weights_column != null && parms._offset_column != null) {
            Log.warn((Object[])new Object[]{"Combination of offset and weights can lead to slight differences because Rollupstats aren't weighted - need to re-calculate weighted mean/sigma of the response including offset terms."});
        }
        if (parms._weights_column != null && parms._offset_column == null) {
            dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
            if (nClasses == 1) {
                dinfo.updateWeightedSigmaAndMeanForResponse(ymt.responseSDs(), ymt.responseMeans());
            }
        }
        dinfo.coefNames();
        assert (dinfo._coefNames != null);
        return dinfo;
    }

    protected Frame rebalance(Frame original_fr, boolean local, String name) {
        if (((XGBoostModel.XGBoostParameters)this._parms)._build_tree_one_node) {
            int original_chunks = original_fr.anyVec().nChunks();
            if (original_chunks == 1) {
                return original_fr;
            }
            Log.info((Object[])new Object[]{"Rebalancing " + name.substring(name.length() - 5) + " dataset onto a single node."});
            Key newKey = Key.make((String)(name + ".1chk"));
            RebalanceDataSet rb = new RebalanceDataSet(original_fr, newKey, 1);
            ((RebalanceDataSet)H2O.submitTask((H2O.H2OCountedCompleter)rb)).join();
            Frame singleChunkFr = (Frame)DKV.get((Key)newKey).get();
            Scope.track((Frame[])new Frame[]{singleChunkFr});
            return singleChunkFr;
        }
        return super.rebalance(original_fr, local, name);
    }

    private static TwoDimTable createVarImpTable(String name, double[] rel_imp, String[] coef_names) {
        return ModelMetrics.calcVarImp((double[])rel_imp, (String[])coef_names, (String)("Variable Importances" + (name != null ? " - " + name : "")), (String[])new String[]{"Relative Importance", "Scaled Importance", "Percentage"});
    }

    private static XgbVarImp computeVarImp(Map<String, FeatureScore> varimp) {
        if (varimp.isEmpty()) {
            return null;
        }
        float[] gains = new float[varimp.size()];
        float[] covers = new float[varimp.size()];
        int[] freqs = new int[varimp.size()];
        String[] names = new String[varimp.size()];
        int j = 0;
        for (Map.Entry<String, FeatureScore> it : varimp.entrySet()) {
            gains[j] = it.getValue()._gain;
            covers[j] = it.getValue()._cover;
            freqs[j] = it.getValue()._frequency;
            names[j] = it.getKey();
            ++j;
        }
        return new XgbVarImp(names, gains, covers, freqs);
    }

    static boolean hasGPU(H2ONode node, int gpu_id) {
        boolean hasGPU;
        if (H2O.SELF.equals((Object)node)) {
            hasGPU = XGBoost.hasGPU(gpu_id);
        } else {
            HasGPUTask t = new HasGPUTask(gpu_id);
            new RPC(node, (DTask)t).call().get();
            hasGPU = t._hasGPU;
        }
        Log.debug((Object[])new Object[]{"Availability of GPU (id=" + gpu_id + ") on node " + node + ": " + hasGPU});
        return hasGPU;
    }

    private static boolean hasGPU(int gpu_id) {
        if (gpu_id == 0 && DEFAULT_GPU_BLACKLISTED) {
            return false;
        }
        boolean hasGPU = XGBoost.hasGPU_impl(gpu_id);
        if (gpu_id == 0 && !hasGPU) {
            DEFAULT_GPU_BLACKLISTED = true;
        }
        return hasGPU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized boolean hasGPU_impl(int gpu_id) {
        DMatrix trainMat;
        if (!XGBoostExtension.isGpuSupportEnabled()) {
            return false;
        }
        if (GPUS.contains(gpu_id)) {
            return true;
        }
        try {
            trainMat = new DMatrix(new float[]{1.0f, 2.0f, 1.0f, 2.0f}, 2, 2);
            trainMat.setLabel(new float[]{1.0f, 0.0f});
        }
        catch (XGBoostError xgBoostError) {
            throw new IllegalStateException("Couldn't prepare training matrix for XGBoost.", xgBoostError);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("updater", "grow_gpu_hist");
        params.put("silent", 1);
        params.put("gpu_id", gpu_id);
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        HashMap localRabitEnv = new HashMap();
        Rabit.init(localRabitEnv);
        ml.dmlc.xgboost4j.java.XGBoost.train((DMatrix)trainMat, params, (int)1, watches, null, null);
        GPUS.add(gpu_id);
        boolean bl = true;
        try {
            Rabit.shutdown();
        }
        catch (XGBoostError e) {
            Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
        }
        return bl;
        catch (XGBoostError xgBoostError) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    Rabit.shutdown();
                }
                catch (XGBoostError e) {
                    Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
                }
                throw throwable;
            }
            try {
                Rabit.shutdown();
            }
            catch (XGBoostError e) {
                Log.warn((Object[])new Object[]{"Cannot shutdown XGBoost Rabit for current thread."});
            }
            return bl2;
        }
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput>[] cvModelBuilders) {
        if (((XGBoostModel.XGBoostParameters)this._parms)._stopping_rounds == 0 && ((XGBoostModel.XGBoostParameters)this._parms)._max_runtime_secs == 0.0) {
            return;
        }
        ((XGBoostModel.XGBoostParameters)this._parms)._stopping_rounds = 0;
        ((XGBoostModel.XGBoostParameters)this._parms)._max_runtime_secs = 0.0;
        int sum = 0;
        for (ModelBuilder<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput> mb : cvModelBuilders) {
            sum += ((XGBoostOutput)((Model)DKV.getGet((Key)mb.dest()))._output)._ntrees;
        }
        ((XGBoostModel.XGBoostParameters)this._parms)._ntrees = (int)((double)sum / (double)cvModelBuilders.length);
        this.warn("_ntrees", "Setting optimal _ntrees to " + ((XGBoostModel.XGBoostParameters)this._parms)._ntrees + " for cross-validation main model based on early stopping of cross-validation models.");
        this.warn("_stopping_rounds", "Disabling convergence-based early stopping for cross-validation main model.");
        this.warn("_max_runtime_secs", "Disabling maximum allowed runtime for cross-validation main model.");
    }

    private static class HasGPUTask
    extends DTask<HasGPUTask> {
        private final int _gpu_id;
        private boolean _hasGPU;

        private HasGPUTask(int gpu_id) {
            this._gpu_id = gpu_id;
        }

        public void compute2() {
            this._hasGPU = XGBoost.hasGPU(this._gpu_id);
            this.tryComplete();
        }
    }

    private static final class BoosterProvider {
        final XGBoostModelInfo _modelInfo;
        final File _featureMapFile;
        XGBoostUpdateTask _updateTask;

        BoosterProvider(XGBoostModelInfo modelInfo, File featureMapFile, XGBoostUpdateTask updateTask) {
            this._modelInfo = modelInfo;
            this._featureMapFile = featureMapFile;
            this._updateTask = updateTask;
            this._modelInfo.setBoosterBytes(this._updateTask.getBoosterBytes());
        }

        final void reset(XGBoostUpdateTask updateTask) {
            this._updateTask = updateTask;
        }

        final void updateBooster() {
            if (this._updateTask == null) {
                throw new IllegalStateException("Booster can be retrieved only once!");
            }
            byte[] boosterBytes = this._updateTask.getBoosterBytes();
            this._modelInfo.setBoosterBytes(boosterBytes);
        }
    }

    class XGBoostDriver
    extends ModelBuilder.Driver {
        long _firstScore;
        long _timeLastScoreStart;
        long _timeLastScoreEnd;

        XGBoostDriver() {
            super((ModelBuilder)XGBoost.this);
            this._firstScore = 0L;
            this._timeLastScoreStart = 0L;
            this._timeLastScoreEnd = 0L;
        }

        public void computeImpl() {
            XGBoost.this.init(true);
            if (XGBoost.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)XGBoost.this);
            }
            this.buildModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void buildModel() {
            if ((XGBoostModel.XGBoostParameters.Backend.auto.equals((Object)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._backend) || XGBoostModel.XGBoostParameters.Backend.gpu.equals((Object)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._backend)) && XGBoost.hasGPU(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._gpu_id) && H2O.getCloudSize() == 1 && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).gpuIncompatibleParams().isEmpty()) {
                XGBoostGPULock xGBoostGPULock = XGBoostGPULock.lock(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._gpu_id);
                synchronized (xGBoostGPULock) {
                    this.buildModelImpl();
                }
            } else {
                this.buildModelImpl();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void buildModelImpl() {
            XGBoostModel model;
            block13: {
                if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms).hasCheckpoint()) {
                    XGBoostModel checkpoint = ((XGBoostModel)DKV.get((Key)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._checkpoint).get()).deepClone((Key<XGBoostModel>)XGBoost.this._result);
                    checkpoint._parms = XGBoost.this._parms;
                    model = (XGBoostModel)checkpoint.delete_and_lock(XGBoost.this._job);
                } else {
                    model = new XGBoostModel((Key<XGBoostModel>)XGBoost.this._result, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, new XGBoostOutput(XGBoost.this), XGBoost.this._train, XGBoost.this._valid);
                    model.write_lock(XGBoost.this._job);
                }
                ((XGBoostOutput)model._output)._sparse = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.sparse ? true : (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._dmatrix_type == XGBoostModel.XGBoostParameters.DMatrixType.dense ? false : this.isTrainDatasetSparse());
                File featureMapFile = null;
                try {
                    XGBoostSetupTask.FrameNodes trainFrameNodes = XGBoostSetupTask.findFrameNodes(XGBoost.this._train);
                    RabitTrackerH2O rt = new RabitTrackerH2O(trainFrameNodes.getNumNodes());
                    this.startRabitTracker(rt);
                    DataInfo dataInfo = model.model_info().dataInfo();
                    assert (dataInfo != null);
                    String featureMap = XGBoostUtils.makeFeatureMap(XGBoost.this._train, dataInfo);
                    model.model_info().setFeatureMap(featureMap);
                    featureMapFile = this.createFeatureMapFile(featureMap);
                    BoosterParms boosterParms = XGBoostModel.createParams((XGBoostModel.XGBoostParameters)XGBoost.this._parms, ((XGBoostOutput)model._output).nclasses(), dataInfo.coefNames());
                    ((XGBoostOutput)model._output)._native_parameters = boosterParms.toTwoDimTable();
                    byte[] checkpointBytes = null;
                    if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms).hasCheckpoint()) {
                        checkpointBytes = model.model_info()._boosterBytes;
                    }
                    XGBoostSetupTask setupTask = (XGBoostSetupTask)((Object)new XGBoostSetupTask(model, (XGBoostModel.XGBoostParameters)XGBoost.this._parms, boosterParms, checkpointBytes, this.getWorkerEnvs(rt), trainFrameNodes).run());
                    try {
                        XGBoostUpdateTask nullModelTask = (XGBoostUpdateTask)((Object)new XGBoostUpdateTask(setupTask, 0).run());
                        BoosterProvider boosterProvider = new BoosterProvider(model.model_info(), featureMapFile, nullModelTask);
                        this.scoreAndBuildTrees(setupTask, boosterProvider, model);
                    }
                    finally {
                        XGBoostCleanupTask.cleanUp(setupTask);
                        this.stopRabitTracker(rt);
                    }
                    if (featureMapFile == null || featureMapFile.delete()) break block13;
                }
                catch (XGBoostError xgBoostError) {
                    try {
                        throw new RuntimeException("XGBoost failure", xgBoostError);
                    }
                    catch (Throwable throwable) {
                        if (featureMapFile != null && !featureMapFile.delete()) {
                            Log.warn((Object[])new Object[]{"Unable to delete file " + featureMapFile + ". Please do a manual clean-up."});
                        }
                        model.unlock(XGBoost.this._job);
                        throw throwable;
                    }
                }
                Log.warn((Object[])new Object[]{"Unable to delete file " + featureMapFile + ". Please do a manual clean-up."});
            }
            model.unlock(XGBoost.this._job);
        }

        private boolean isTrainDatasetSparse() {
            long nonZeroCount = 0L;
            int nonCategoricalColumns = 0;
            long oneHotEncodedColumns = 0L;
            for (int i = 0; i < XGBoost.this._train.numCols(); ++i) {
                if (XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._response_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._weights_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._fold_column) || XGBoost.this._train.name(i).equals(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._offset_column)) continue;
                Vec vector = XGBoost.this._train.vec(i);
                nonZeroCount = vector.isCategorical() ? (nonZeroCount += XGBoost.this._train.numRows()) : (nonZeroCount += vector.nzCnt());
                if (vector.isCategorical()) {
                    oneHotEncodedColumns += (long)vector.cardinality();
                    continue;
                }
                ++nonCategoricalColumns;
            }
            long totalColumns = oneHotEncodedColumns + (long)nonCategoricalColumns;
            double denominator = (double)totalColumns * (double)XGBoost.this._train.numRows();
            double fillRatio = (double)nonZeroCount / denominator;
            Log.info((Object[])new Object[]{"fill ratio: " + fillRatio});
            return fillRatio < 0.25 || XGBoost.this._train.numRows() * totalColumns > Integer.MAX_VALUE;
        }

        private File createFeatureMapFile(String featureMap) {
            try {
                File fmFile = Files.createTempFile("h2o_xgb_" + XGBoost.this._result.toString(), ".txt", new FileAttribute[0]).toFile();
                fmFile.deleteOnExit();
                try (FileOutputStream os = new FileOutputStream(fmFile);){
                    ((OutputStream)os).write(featureMap.getBytes());
                }
                return fmFile;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot generate feature map file", e);
            }
        }

        private void scoreAndBuildTrees(XGBoostSetupTask setupTask, BoosterProvider boosterProvider, XGBoostModel model) throws XGBoostError {
            Map<String, Integer> monotoneConstraints;
            for (int tid = 0; tid < XGBoost.this._ntrees; ++tid) {
                boolean scored = this.doScoring(model, boosterProvider, false);
                if (scored && ScoreKeeper.stopEarly((ScoreKeeper[])((XGBoostOutput)model._output).scoreKeepers(), (int)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_rounds, (ScoreKeeper.ProblemType)ScoreKeeper.ProblemType.forSupervised((XGBoost.this._nclass > 1 ? 1 : 0) != 0), (ScoreKeeper.IStoppingMetric)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_metric, (double)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._stopping_tolerance, (String)"model's last", (boolean)true)) {
                    Log.info((Object[])new Object[]{"Early stopping triggered - stopping XGBoost training"});
                    break;
                }
                Timer kb_timer = new Timer();
                XGBoostUpdateTask t = (XGBoostUpdateTask)((Object)new XGBoostUpdateTask(setupTask, tid).run());
                boosterProvider.reset(t);
                Log.info((Object[])new Object[]{tid + 1 + ". tree was built in " + kb_timer.toString()});
                XGBoost.this._job.update(1L);
                ++((XGBoostOutput)model._output)._ntrees;
                ((XGBoostOutput)model._output)._scored_train = (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_train, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper());
                ((XGBoostOutput)model._output)._scored_valid = ((XGBoostOutput)model._output)._scored_valid != null ? (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])((XGBoostOutput)model._output)._scored_valid, (int)(((XGBoostOutput)model._output)._ntrees + 1), (Object)new ScoreKeeper()) : null;
                ((XGBoostOutput)model._output)._training_time_ms = ArrayUtils.copyAndFillOf((long[])((XGBoostOutput)model._output)._training_time_ms, (int)(((XGBoostOutput)model._output)._ntrees + 1), (long)System.currentTimeMillis());
                if (XGBoost.this.stop_requested() && !XGBoost.this.timeout()) {
                    throw new Job.JobCancelledException();
                }
                if (!XGBoost.this.timeout()) continue;
                Log.info((Object[])new Object[]{"Stopping XGBoost training because of timeout"});
                break;
            }
            if (!(monotoneConstraints = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).monotoneConstraints()).isEmpty() && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._booster != XGBoostModel.XGBoostParameters.Booster.gblinear && this.constraintCheckEnabled()) {
                XGBoost.this._job.update(0L, "Checking monotonicity constraints on the final model");
                boosterProvider.updateBooster();
                this.checkConstraints(model.model_info(), monotoneConstraints);
            }
            XGBoost.this._job.update(0L, "Scoring the final model");
            this.doScoring(model, boosterProvider, true);
            XGBoost.this._job.update((long)(((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees - ((XGBoostOutput)model._output)._ntrees));
        }

        private boolean constraintCheckEnabled() {
            return Boolean.parseBoolean(XGBoost.this.getSysProperty("xgboost.monotonicity.checkEnabled", "true"));
        }

        private void checkConstraints(XGBoostModelInfo model_info, Map<String, Integer> monotoneConstraints) {
            GradBooster booster = XGBoostJavaMojoModel.makePredictor((byte[])model_info._boosterBytes).getBooster();
            if (!(booster instanceof GBTree)) {
                throw new IllegalStateException("Expected booster object to be GBTree instead it is " + booster.getClass().getName());
            }
            RegTree[][] groupedTrees = ((GBTree)booster).getGroupedTrees();
            XGBoostUtils.FeatureProperties featureProperties = XGBoostUtils.assembleFeatureNames(model_info.dataInfo());
            RegTree[][] regTreeArray = groupedTrees;
            int n = regTreeArray.length;
            for (int i = 0; i < n; ++i) {
                RegTree[] classTrees;
                for (RegTree tree : classTrees = regTreeArray[i]) {
                    if (tree == null) continue;
                    this.checkConstraints(tree.getNodes(), monotoneConstraints, featureProperties);
                }
            }
        }

        private void checkConstraints(RegTreeNode[] tree, Map<String, Integer> monotoneConstraints, XGBoostUtils.FeatureProperties featureProperties) {
            float[] mins = new float[tree.length];
            int[] min_ids = new int[tree.length];
            float[] maxs = new float[tree.length];
            int[] max_ids = new int[tree.length];
            this.rollupMinMaxPreds(tree, 0, mins, min_ids, maxs, max_ids);
            for (int i = 0; i < tree.length; ++i) {
                String splitColumn;
                RegTreeNode node = tree[i];
                if (node.isLeaf() || !monotoneConstraints.containsKey(splitColumn = featureProperties._names[node.getSplitIndex()])) continue;
                int constraint = monotoneConstraints.get(splitColumn);
                int left = node.getLeftChildIndex();
                int right = node.getRightChildIndex();
                if (constraint > 0) {
                    if (!(maxs[left] > mins[right])) continue;
                    throw new IllegalStateException("Monotonicity constraint " + constraint + " violated on column '" + splitColumn + "' (max(left) > min(right)): " + maxs[left] + " > " + mins[right] + "\nNode: " + node + "\nLeft Node (max): " + tree[max_ids[left]] + "\nRight Node (min): " + tree[min_ids[right]]);
                }
                if (constraint >= 0 || !(mins[left] < maxs[right])) continue;
                throw new IllegalStateException("Monotonicity constraint " + constraint + " violated on column '" + splitColumn + "' (min(left) < max(right)): " + mins[left] + " < " + maxs[right] + "\nNode: " + node + "\nLeft Node (min): " + tree[min_ids[left]] + "\nRight Node (max): " + tree[max_ids[right]]);
            }
        }

        private void rollupMinMaxPreds(RegTreeNode[] tree, int nid, float[] mins, int[] min_ids, float[] maxs, int[] max_ids) {
            RegTreeNode node = tree[nid];
            if (node.isLeaf()) {
                mins[nid] = node.getLeafValue();
                min_ids[nid] = nid;
                maxs[nid] = node.getLeafValue();
                max_ids[nid] = nid;
                return;
            }
            int left = node.getLeftChildIndex();
            int right = node.getRightChildIndex();
            this.rollupMinMaxPreds(tree, left, mins, min_ids, maxs, max_ids);
            this.rollupMinMaxPreds(tree, right, mins, min_ids, maxs, max_ids);
            int min_id = mins[left] < mins[right] ? left : right;
            mins[nid] = mins[min_id];
            min_ids[nid] = min_ids[min_id];
            int max_id = maxs[left] > maxs[right] ? left : right;
            maxs[nid] = maxs[max_id];
            max_ids[nid] = max_ids[max_id];
        }

        private void startRabitTracker(RabitTrackerH2O rt) {
            if (H2O.CLOUD.size() > 1) {
                rt.start(0L);
            }
        }

        private void stopRabitTracker(RabitTrackerH2O rt) {
            if (H2O.CLOUD.size() > 1) {
                rt.waitFor(0L);
                rt.stop();
            }
        }

        private Map<String, String> getWorkerEnvs(RabitTrackerH2O rt) {
            if (H2O.CLOUD.size() > 1) {
                return rt.getWorkerEnvs();
            }
            return new HashMap<String, String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean doScoring(XGBoostModel model, final BoosterProvider boosterProvider, boolean finalScoring) throws XGBoostError {
            boolean manualInterval;
            boolean scored = false;
            long now = System.currentTimeMillis();
            if (this._firstScore == 0L) {
                this._firstScore = now;
            }
            long sinceLastScore = now - this._timeLastScoreStart;
            XGBoost.this._job.update(0L, "Built " + ((XGBoostOutput)model._output)._ntrees + " trees so far (out of " + ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._ntrees + ").");
            boolean timeToScore = now - this._firstScore < (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._initial_score_interval || sinceLastScore > (long)((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_interval && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1;
            boolean bl = manualInterval = ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval > 0 && ((XGBoostOutput)model._output)._ntrees % ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0;
            if (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_each_iteration || finalScoring || timeToScore && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._score_tree_interval == 0 || manualInterval) {
                Map<String, FeatureScore> varimp;
                XGBoostOutput out;
                block7: {
                    this._timeLastScoreStart = now;
                    boosterProvider.updateBooster();
                    model.doScoring(XGBoost.this._train, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).train(), XGBoost.this._valid, ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).valid());
                    this._timeLastScoreEnd = System.currentTimeMillis();
                    out = (XGBoostOutput)model._output;
                    Booster booster = null;
                    try {
                        booster = model.model_info().deserializeBooster();
                        varimp = BoosterHelper.doWithLocalRabit(new BoosterHelper.BoosterOp<Map<String, FeatureScore>>(){

                            @Override
                            public Map<String, FeatureScore> apply(Booster booster) throws XGBoostError {
                                String fmPath = boosterProvider._featureMapFile.getAbsolutePath();
                                String[] modelDump = booster.getModelDump(fmPath, true);
                                return XGBoostUtils.parseFeatureScores(modelDump);
                            }
                        }, booster);
                        if (booster == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (booster != null) {
                            BoosterHelper.dispose(booster);
                        }
                        throw throwable;
                    }
                    BoosterHelper.dispose(booster);
                }
                out._varimp = XGBoost.computeVarImp(varimp);
                out._model_summary = SharedTree.createModelSummaryTable((int)out._ntrees, null);
                out._scoring_history = SharedTree.createScoringHistoryTable((Model.Output)out, (ScoreKeeper[])((XGBoostOutput)model._output)._scored_train, (ScoreKeeper[])out._scored_valid, (Job)XGBoost.this._job, (long[])out._training_time_ms, (((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._custom_metric_func != null ? 1 : 0) != 0, (boolean)false);
                if (out._varimp != null) {
                    out._variable_importances = XGBoost.createVarImpTable(null, ArrayUtils.toDouble((float[])out._varimp._varimp), out._varimp._names);
                    out._variable_importances_cover = XGBoost.createVarImpTable("Cover", ArrayUtils.toDouble((float[])out._varimp._covers), out._varimp._names);
                    out._variable_importances_frequency = XGBoost.createVarImpTable("Frequency", ArrayUtils.toDouble((int[])out._varimp._freqs), out._varimp._names);
                }
                model.update(XGBoost.this._job);
                Log.info((Object[])new Object[]{model});
                scored = true;
            }
            if (finalScoring && ((XGBoostModel.XGBoostParameters)XGBoost.this._parms).calibrateModel() && !((XGBoostModel.XGBoostParameters)XGBoost.this._parms)._is_cv_model) {
                ((XGBoostOutput)model._output)._calib_model = PlattScalingHelper.buildCalibrationModel((PlattScalingHelper.ModelBuilderWithCalibration)XGBoost.this, (PlattScalingHelper.ParamsWithCalibration)((PlattScalingHelper.ParamsWithCalibration)XGBoost.this._parms), (Job)XGBoost.this._job, (Model)model);
                model.update(XGBoost.this._job);
            }
            return scored;
        }
    }
}

