/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import hex.DataInfo;
import hex.tree.xgboost.matrix.MatrixFactoryUtils;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.util.BigDenseMatrix;
import water.H2O;
import water.LocalMR;
import water.MrFun;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class DenseMatrixFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMatrix dense(Chunk[] chunks, DataInfo di, int respIdx, float[] resp, float[] weights, int offsetIdx, float[] offsets) throws XGBoostError {
        Log.debug((Object[])new Object[]{"Treating matrix as dense."});
        BigDenseMatrix data = null;
        try {
            data = DenseMatrixFactory.allocateDenseMatrix(chunks[0].len(), di);
            long actualRows = DenseMatrixFactory.denseChunk(data, chunks, respIdx, di, resp, weights, offsetIdx, offsets);
            assert (actualRows == (long)data.nrow);
            DMatrix dMatrix = new DMatrix(data, Float.NaN);
            return dMatrix;
        }
        finally {
            if (data != null) {
                data.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMatrix dense(Frame f, int[] chunks, int nRows, int[] nRowsByChunk, Vec weightVec, Vec offsetVec, Vec responseVec, DataInfo di, float[] resp, float[] weights, float[] offsets) throws XGBoostError {
        BigDenseMatrix data = null;
        try {
            data = DenseMatrixFactory.allocateDenseMatrix(nRows, di);
            long actualRows = DenseMatrixFactory.denseChunk(data, chunks, nRowsByChunk, f, weightVec, offsetVec, responseVec, di, resp, weights, offsets);
            assert ((long)data.nrow == actualRows);
            DMatrix dMatrix = new DMatrix(data, Float.NaN);
            return dMatrix;
        }
        finally {
            if (data != null) {
                data.dispose();
            }
        }
    }

    private static long denseChunk(BigDenseMatrix data, int[] chunks, int[] nRowsByChunk, Frame f, Vec weightsVec, Vec offsetVec, Vec respVec, DataInfo di, float[] resp, float[] weights, float[] offsets) {
        int[] rowOffsets = new int[nRowsByChunk.length + 1];
        for (int i = 0; i < chunks.length; ++i) {
            rowOffsets[i + 1] = nRowsByChunk[i] + rowOffsets[i];
        }
        WriteDenseChunkFun writeFun = new WriteDenseChunkFun(f, chunks, rowOffsets, weightsVec, offsetVec, respVec, di, data, resp, weights, offsets);
        ((LocalMR)H2O.submitTask((H2O.H2OCountedCompleter)new LocalMR((MrFun)writeFun, chunks.length))).join();
        return writeFun.getTotalRows();
    }

    private static long denseChunk(BigDenseMatrix data, Chunk[] chunks, int respIdx, DataInfo di, float[] resp, float[] weights, int offsetIdx, float[] offsets) {
        long idx = 0L;
        long actualRows = 0L;
        int rwRow = 0;
        for (int i = 0; i < chunks[0]._len; ++i) {
            idx = DenseMatrixFactory.writeDenseRow(di, chunks, i, data, idx);
            ++actualRows;
            rwRow = MatrixFactoryUtils.setResponseAndWeightAndOffset(chunks, respIdx, -1, offsetIdx, resp, weights, offsets, rwRow, i);
        }
        assert ((long)data.nrow * (long)data.ncol == idx);
        return actualRows;
    }

    private static long writeDenseRow(DataInfo di, Chunk[] chunks, int rowInChunk, BigDenseMatrix data, long idx) {
        int j;
        for (j = 0; j < di._cats; ++j) {
            int len = di._catOffsets[j + 1] - di._catOffsets[j];
            double val = chunks[j].isNA(rowInChunk) ? Double.NaN : (double)chunks[j].at8(rowInChunk);
            int pos = di.getCategoricalId(j, val) - di._catOffsets[j];
            for (int cat = 0; cat < len; ++cat) {
                data.set(idx + (long)cat, 0.0f);
            }
            data.set(idx + (long)pos, 1.0f);
            idx += (long)len;
        }
        for (j = 0; j < di._nums; ++j) {
            float val = chunks[di._cats + j].isNA(rowInChunk) ? Float.NaN : (float)chunks[di._cats + j].atd(rowInChunk);
            data.set(idx++, val);
        }
        return idx;
    }

    private static BigDenseMatrix allocateDenseMatrix(int rowCount, DataInfo dataInfo) {
        return new BigDenseMatrix(rowCount, dataInfo.fullN());
    }

    private static class WriteDenseChunkFun
    extends MrFun<WriteDenseChunkFun> {
        private final Frame _f;
        private final int[] _chunks;
        private final int[] _rowOffsets;
        private final Vec _weightsVec;
        private final Vec _offsetsVec;
        private final Vec _respVec;
        private final DataInfo _di;
        private final BigDenseMatrix _data;
        private final float[] _resp;
        private final float[] _weights;
        private final float[] _offsets;
        private int[] _nRowsByChunk;

        private WriteDenseChunkFun(Frame f, int[] chunks, int[] rowOffsets, Vec weightsVec, Vec offsetsVec, Vec respVec, DataInfo di, BigDenseMatrix data, float[] resp, float[] weights, float[] offsets) {
            this._f = f;
            this._chunks = chunks;
            this._rowOffsets = rowOffsets;
            this._weightsVec = weightsVec;
            this._offsetsVec = offsetsVec;
            this._respVec = respVec;
            this._di = di;
            this._data = data;
            this._resp = resp;
            this._weights = weights;
            this._offsets = offsets;
            this._nRowsByChunk = new int[chunks.length];
        }

        protected void map(int id) {
            int chunkIdx = this._chunks[id];
            Chunk[] chks = new Chunk[this._f.numCols()];
            for (int c = 0; c < chks.length; ++c) {
                chks[c] = this._f.vec(c).chunkForChunkIdx(chunkIdx);
            }
            Chunk weightsChk = this._weightsVec != null ? this._weightsVec.chunkForChunkIdx(chunkIdx) : null;
            Chunk offsetsChk = this._offsetsVec != null ? this._offsetsVec.chunkForChunkIdx(chunkIdx) : null;
            Chunk respChk = this._respVec.chunkForChunkIdx(chunkIdx);
            long idx = this._rowOffsets[id] * this._data.ncol;
            int actualRows = 0;
            for (int i = 0; i < chks[0]._len; ++i) {
                if (weightsChk != null && weightsChk.atd(i) == 0.0) continue;
                idx = DenseMatrixFactory.writeDenseRow(this._di, chks, i, this._data, idx);
                this._resp[this._rowOffsets[id] + actualRows] = (float)respChk.atd(i);
                if (weightsChk != null) {
                    this._weights[this._rowOffsets[id] + actualRows] = (float)weightsChk.atd(i);
                }
                if (offsetsChk != null) {
                    this._offsets[this._rowOffsets[id] + actualRows] = (float)offsetsChk.atd(i);
                }
                ++actualRows;
            }
            assert (idx == (long)this._rowOffsets[id + 1] * (long)this._data.ncol);
            this._nRowsByChunk[id] = actualRows;
        }

        private long getTotalRows() {
            long totalRows = 0L;
            for (int r : this._nRowsByChunk) {
                totalRows += (long)r;
            }
            return totalRows;
        }
    }
}

