/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.util.FVec;
import hex.DataInfo;
import hex.Model;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.predict.AssignLeafNodeIdTask;
import hex.tree.xgboost.predict.AssignTreePathTask;
import hex.tree.xgboost.predict.MutableOneHotEncoderFVec;
import ml.dmlc.xgboost4j.java.PredictorFactory;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;

public abstract class AssignLeafNodeTask
extends MRTask<AssignLeafNodeTask> {
    protected final Predictor _p;
    protected final String[] _names;
    private final DataInfo _di;
    private final boolean _sparse;
    private byte _resultType;

    protected AssignLeafNodeTask(DataInfo di, XGBoostOutput output, byte[] boosterBytes, byte resultType) {
        this._p = PredictorFactory.makePredictor(boosterBytes, false);
        this._di = di;
        this._sparse = output._sparse;
        this._names = this.makeNames(output._ntrees, output.nclasses());
        this._resultType = resultType;
    }

    protected abstract void assignNodes(FVec var1, NewChunk[] var2);

    private String[] makeNames(int ntrees, int nclass) {
        nclass = nclass > 2 ? nclass : 1;
        String[] names = new String[ntrees * nclass];
        for (int t = 0; t < ntrees; ++t) {
            for (int c = 0; c < nclass; ++c) {
                names[t * nclass + c] = "T" + (t + 1) + ".C" + (c + 1);
            }
        }
        return names;
    }

    public void map(Chunk[] chks, NewChunk[] idx) {
        MutableOneHotEncoderFVec inputVec = new MutableOneHotEncoderFVec(this._di, this._sparse);
        double[] input = new double[chks.length];
        for (int row = 0; row < chks[0]._len; ++row) {
            for (int i = 0; i < chks.length; ++i) {
                input[i] = chks[i].atd(row);
            }
            inputVec.setInput(input);
            this.assignNodes(inputVec, idx);
        }
    }

    public Frame execute(Frame adaptFrm, Key<Frame> destKey) {
        return ((AssignLeafNodeTask)this.doAll(this._names.length, this._resultType, adaptFrm)).outputFrame(destKey, this._names, null);
    }

    public static AssignLeafNodeTask make(DataInfo di, XGBoostOutput output, byte[] boosterBytes, Model.LeafNodeAssignment.LeafNodeAssignmentType type) {
        switch (type) {
            case Path: {
                return new AssignTreePathTask(di, output, boosterBytes);
            }
            case Node_ID: {
                return new AssignLeafNodeIdTask(di, output, boosterBytes);
            }
        }
        throw new UnsupportedOperationException("Unknown leaf node assignment type: " + type);
    }
}

