/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.matrix.DenseMatrixFactory;
import hex.tree.xgboost.matrix.MatrixLoader;
import hex.tree.xgboost.matrix.SparseMatrixFactory;
import java.util.Arrays;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.apache.log4j.Logger;
import water.H2O;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.VecUtils;

public class XGBoostUtils {
    private static final Logger LOG = Logger.getLogger(XGBoostUtils.class);

    public static void createFeatureMap(XGBoostModel model, Frame train) {
        DataInfo dataInfo = model.model_info().dataInfo();
        assert (dataInfo != null);
        String featureMap = XGBoostUtils.makeFeatureMap(train, dataInfo);
        model.model_info().setFeatureMap(featureMap);
    }

    private static String makeFeatureMap(Frame f, DataInfo di) {
        String[] coefnames = di.coefNames();
        StringBuilder sb = new StringBuilder();
        assert (coefnames.length == di.fullN());
        int catCols = di._catOffsets[di._catOffsets.length - 1];
        for (int i = 0; i < di.fullN(); ++i) {
            sb.append(i).append(" ").append(coefnames[i].replaceAll("\\s*", "")).append(" ");
            if (i < catCols || f.vec(i - catCols).isBinary()) {
                sb.append("i");
            } else if (f.vec(i - catCols).isInt()) {
                sb.append("int");
            } else {
                sb.append("q");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static MatrixLoader.DMatrixProvider convertFrameToDMatrix(DataInfo di, Frame frame, String response, String weight, String offset, boolean sparse) {
        MatrixLoader.DMatrixProvider trainMat;
        assert (di != null);
        int[] chunks = VecUtils.getLocalChunkIds((Vec)frame.anyVec());
        Vec responseVec = frame.vec(response);
        Vec weightVec = frame.vec(weight);
        Vec offsetsVec = frame.vec(offset);
        int[] nRowsByChunk = new int[chunks.length];
        long nRowsL = XGBoostUtils.sumChunksLength(chunks, responseVec, weightVec, nRowsByChunk);
        if (nRowsL > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("XGBoost currently doesn't support datasets with more than 2147483647 per node. To train a XGBoost model on this dataset add more nodes to your H2O cluster and use distributed training.");
        }
        int nRows = (int)nRowsL;
        float[] resp = MemoryManager.malloc4f((int)nRows);
        float[] weights = null;
        float[] offsets = null;
        if (weightVec != null) {
            weights = MemoryManager.malloc4f((int)nRows);
        }
        if (offsetsVec != null) {
            offsets = MemoryManager.malloc4f((int)nRows);
        }
        if (sparse) {
            LOG.debug((Object)"Treating matrix as sparse.");
            trainMat = SparseMatrixFactory.csr(frame, chunks, weightVec, offsetsVec, responseVec, di, resp, weights, offsets);
        } else {
            LOG.debug((Object)"Treating matrix as dense.");
            trainMat = DenseMatrixFactory.dense(frame, chunks, nRows, nRowsByChunk, weightVec, offsetsVec, responseVec, di, resp, weights, offsets);
        }
        return trainMat;
    }

    private static long sumChunksLength(int[] chunkIds, Vec vec, Vec weightsVector, int[] chunkLengths) {
        for (int i = 0; i < chunkIds.length; ++i) {
            int chunk = chunkIds[i];
            chunkLengths[i] = vec.chunkLen(chunk);
            if (weightsVector == null) continue;
            Chunk weightVecChunk = weightsVector.chunkForChunkIdx(chunk);
            if (weightVecChunk.atd(0) == 0.0) {
                int n = i;
                chunkLengths[n] = chunkLengths[n] - 1;
            }
            int nzIndex = 0;
            while ((nzIndex = weightVecChunk.nextNZ(nzIndex, true)) >= 0 && nzIndex < weightVecChunk._len) {
                if (weightVecChunk.atd(nzIndex) != 0.0) continue;
                int n = i;
                chunkLengths[n] = chunkLengths[n] - 1;
            }
        }
        long totalChunkLength = 0L;
        for (int cl : chunkLengths) {
            totalChunkLength += (long)cl;
        }
        return totalChunkLength;
    }

    public static DMatrix convertChunksToDMatrix(DataInfo di, Chunk[] chunks, int response, boolean sparse, int offset) throws XGBoostError {
        DMatrix trainMat;
        int nRows = chunks[0]._len;
        float[] resp = MemoryManager.malloc4f((int)nRows);
        float[] off = null;
        if (offset >= 0) {
            off = MemoryManager.malloc4f((int)nRows);
        }
        try {
            if (sparse) {
                LOG.debug((Object)"Treating matrix as sparse.");
                trainMat = SparseMatrixFactory.csr(chunks, -1, response, offset, di, resp, null, off);
            } else {
                trainMat = DenseMatrixFactory.dense(chunks, di, response, resp, null, offset, off);
            }
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(H2O.technote((int)11, (String)"Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
        }
        int len = (int)trainMat.rowNum();
        if (off != null) {
            off = Arrays.copyOf(off, len);
            trainMat.setBaseMargin(off);
        }
        resp = Arrays.copyOf(resp, len);
        trainMat.setLabel(resp);
        return trainMat;
    }

    public static FeatureProperties assembleFeatureNames(DataInfo di) {
        String[] coefnames = di.coefNames();
        assert (coefnames.length == di.fullN());
        int numCatCols = di._catOffsets[di._catOffsets.length - 1];
        String[] featureNames = new String[di.fullN()];
        boolean[] oneHotEncoded = new boolean[di.fullN()];
        for (int i = 0; i < di.fullN(); ++i) {
            featureNames[i] = coefnames[i];
            if (i >= numCatCols) continue;
            oneHotEncoded[i] = true;
        }
        return new FeatureProperties(featureNames, oneHotEncoded);
    }

    public static class FeatureProperties {
        public String[] _names;
        public boolean[] _oneHotEncoded;

        public FeatureProperties(String[] names, boolean[] oneHotEncoded) {
            this._names = names;
            this._oneHotEncoded = oneHotEncoded;
        }
    }
}

