/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import water.Iced;

public abstract class MatrixLoader
extends Iced<MatrixLoader> {
    public abstract DMatrixProvider makeLocalMatrix();

    public static abstract class DMatrixProvider
    implements Externalizable {
        protected long actualRows;
        protected float[] response;
        protected float[] weights;
        protected float[] offsets;

        protected DMatrixProvider(long actualRows, float[] response, float[] weights, float[] offsets) {
            this.actualRows = actualRows;
            this.response = response;
            this.weights = weights;
            this.offsets = offsets;
        }

        public DMatrixProvider() {
        }

        protected abstract DMatrix makeDMatrix() throws XGBoostError;

        protected void dispose() {
        }

        public final DMatrix get() throws XGBoostError {
            DMatrix mat = this.makeDMatrix();
            this.dispose();
            assert (mat.rowNum() == this.actualRows);
            mat.setLabel(this.response);
            if (this.weights != null) {
                mat.setWeight(this.weights);
            }
            if (this.offsets != null) {
                mat.setBaseMargin(this.offsets);
            }
            return mat;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.actualRows);
            out.writeObject(this.response);
            out.writeObject(this.weights);
            out.writeObject(this.offsets);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.actualRows = in.readLong();
            this.response = (float[])in.readObject();
            this.weights = (float[])in.readObject();
            this.offsets = (float[])in.readObject();
        }
    }
}

