/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.remote;

import hex.genmodel.utils.IOUtils;
import hex.schemas.XGBoostExecRespV3;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import water.H2O;
import water.Key;
import water.server.ServletUtils;

public class RemoteXGBoostUploadServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(RemoteXGBoostUploadServlet.class);

    public static File getUploadDir(String key) {
        return new File(H2O.ICE_ROOT.toString(), key);
    }

    public static File getMatrixFile(String key) {
        return new File(RemoteXGBoostUploadServlet.getUploadDir(key), "matrix.part" + H2O.SELF.index());
    }

    public static File getCheckpointFile(String key) {
        return new File(RemoteXGBoostUploadServlet.getUploadDir(key), "checkpoint.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri((HttpServletRequest)request);
        try {
            String model_key = request.getParameter("model_key");
            String data_type = request.getParameter("data_type");
            LOG.info((Object)("Upload request for " + model_key + " " + data_type + " received"));
            File uploadDir = RemoteXGBoostUploadServlet.getUploadDir(model_key);
            if (uploadDir.mkdirs()) {
                LOG.debug((Object)("Created temporary directory " + uploadDir));
            }
            File destFile = "matrix".equalsIgnoreCase(data_type) ? RemoteXGBoostUploadServlet.getMatrixFile(model_key) : RemoteXGBoostUploadServlet.getCheckpointFile(model_key);
            LOG.debug((Object)("Saving contents into " + destFile));
            ServletInputStream is = request.getInputStream();
            try (FileOutputStream fos = new FileOutputStream(destFile);){
                IOUtils.copyStream((InputStream)is, (OutputStream)fos);
            }
            response.setContentType("application/json");
            response.getWriter().write(new XGBoostExecRespV3(Key.make((String)model_key)).toJsonString());
        }
        catch (Exception e) {
            ServletUtils.sendErrorResponse((HttpServletResponse)response, (Exception)e, (String)uri);
        }
        finally {
            ServletUtils.logRequest((String)"POST", (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }
}

