/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.Rabit;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;

public class BoosterHelper {
    public static Booster loadModel(InputStream in) {
        try {
            return XGBoost.loadModel((InputStream)in);
        }
        catch (IOException | XGBoostError e) {
            throw new IllegalStateException("Failed to load booster.", e);
        }
    }

    public static Booster loadModel(byte[] boosterBytes) {
        if (boosterBytes == null) {
            throw new IllegalArgumentException("Booster not initialized!");
        }
        return BoosterHelper.loadModel(new ByteArrayInputStream(boosterBytes));
    }

    public static void dispose(Object ... xgbObjects) throws IllegalStateException {
        Exception firstException = null;
        for (Object xgbObject : xgbObjects) {
            if (xgbObject == null) continue;
            if (xgbObject instanceof Booster) {
                try {
                    ((Booster)xgbObject).dispose();
                }
                catch (Exception e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
                continue;
            }
            if (xgbObject instanceof DMatrix) {
                try {
                    ((DMatrix)xgbObject).dispose();
                }
                catch (Exception e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
                continue;
            }
            assert (false) : "Unsupported XGBoost object type: " + xgbObject.getClass();
        }
        if (firstException != null) {
            throw new IllegalStateException("We were unable to free-up xgboost memory. This could indicate a memory leak and it can lead to H2O instability.", firstException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> X doWithLocalRabit(BoosterOp<X> op, Booster booster) throws XGBoostError {
        boolean shutdownRabit = true;
        try {
            HashMap<String, String> rabitEnv = new HashMap<String, String>();
            rabitEnv.put("DMLC_TASK_ID", "0");
            Rabit.init(rabitEnv);
            shutdownRabit = true;
            X result = op.apply(booster);
            Rabit.shutdown();
            shutdownRabit = false;
            X x = result;
            return x;
        }
        finally {
            if (shutdownRabit) {
                try {
                    Rabit.shutdown();
                }
                catch (XGBoostError e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface BoosterOp<X> {
        public X apply(Booster var1) throws XGBoostError;
    }
}

