/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.exec;

import hex.DataInfo;
import hex.schemas.XGBoostExecRespV3;
import hex.tree.xgboost.BoosterParms;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.exec.XGBoostExecReq;
import hex.tree.xgboost.exec.XGBoostExecutor;
import hex.tree.xgboost.exec.XGBoostHttpClient;
import hex.tree.xgboost.remote.RemoteXGBoostUploadServlet;
import hex.tree.xgboost.task.XGBoostSetupTask;
import hex.tree.xgboost.task.XGBoostUploadMatrixTask;
import org.apache.log4j.Logger;
import water.H2O;
import water.Key;
import water.fvec.Frame;

public class RemoteXGBoostExecutor
implements XGBoostExecutor {
    private static final Logger LOG = Logger.getLogger(RemoteXGBoostExecutor.class);
    public final XGBoostHttpClient http;
    public final Key modelKey;

    public RemoteXGBoostExecutor(XGBoostModel model, Frame train, String remoteUri, String userName, String password) {
        boolean https = H2O.ARGS.jks != null;
        this.http = new XGBoostHttpClient(remoteUri, https, userName, password);
        this.modelKey = model._key;
        XGBoostExecReq.Init req = new XGBoostExecReq.Init();
        XGBoostSetupTask.FrameNodes trainFrameNodes = XGBoostSetupTask.findFrameNodes(train);
        req.num_nodes = trainFrameNodes.getNumNodes();
        DataInfo dataInfo = model.model_info().dataInfo();
        req.parms = XGBoostModel.createParamsMap((XGBoostModel.XGBoostParameters)model._parms, ((XGBoostOutput)model._output).nclasses(), dataInfo.coefNames());
        ((XGBoostOutput)model._output)._native_parameters = BoosterParms.fromMap(req.parms).toTwoDimTable();
        req.save_matrix_path = ((XGBoostModel.XGBoostParameters)model._parms)._save_matrix_directory;
        req.nodes = this.collectNodes(trainFrameNodes);
        LOG.info((Object)"Initializing remote executor.");
        XGBoostExecRespV3 resp = this.http.postJson(this.modelKey, "init", req);
        String[] remoteNodes = (String[])resp.readData();
        assert (this.modelKey.equals((Object)resp.key.key()));
        this.uploadCheckpointBooster(model);
        this.uploadMatrices(model, train, trainFrameNodes, remoteNodes, https, remoteUri, userName, password);
        LOG.info((Object)"Remote executor init complete.");
    }

    private void uploadMatrices(XGBoostModel model, Frame train, XGBoostSetupTask.FrameNodes trainFrameNodes, String[] remoteNodes, boolean https, String leaderUri, String userName, String password) {
        LOG.info((Object)"Starting matrix data upload.");
        new XGBoostUploadMatrixTask(model, train, trainFrameNodes._nodes, remoteNodes, https, this.parseContextPath(leaderUri), userName, password).run();
    }

    private String parseContextPath(String leaderUri) {
        int slashIndex = leaderUri.indexOf("/");
        if (slashIndex > 0) {
            return leaderUri.substring(slashIndex);
        }
        return "";
    }

    private void uploadCheckpointBooster(XGBoostModel model) {
        if (!((XGBoostModel.XGBoostParameters)model._parms).hasCheckpoint()) {
            return;
        }
        LOG.info((Object)"Uploading booster checkpoint.");
        this.http.uploadBytes(this.modelKey, RemoteXGBoostUploadServlet.RequestType.checkpoint, model.model_info()._boosterBytes);
    }

    private String[] collectNodes(XGBoostSetupTask.FrameNodes nodes) {
        String[] res = new String[H2O.CLOUD.size()];
        for (int i = 0; i < nodes._nodes.length; ++i) {
            if (!nodes._nodes[i]) continue;
            res[i] = H2O.CLOUD.members()[i].getIpPortString();
        }
        return res;
    }

    @Override
    public byte[] setup() {
        XGBoostExecReq req = new XGBoostExecReq();
        return this.http.downloadBytes(this.modelKey, "setup", req);
    }

    @Override
    public void update(int treeId) {
        XGBoostExecReq.Update req = new XGBoostExecReq.Update();
        req.treeId = treeId;
        XGBoostExecRespV3 resp = this.http.postJson(this.modelKey, "update", req);
        assert (resp.key.key().equals((Object)this.modelKey));
    }

    @Override
    public byte[] updateBooster() {
        XGBoostExecReq req = new XGBoostExecReq();
        return this.http.downloadBytes(this.modelKey, "getBooster", req);
    }

    @Override
    public void close() {
        XGBoostExecReq req = new XGBoostExecReq();
        XGBoostExecRespV3 resp = this.http.postJson(this.modelKey, "cleanup", req);
        assert (resp.key.key().equals((Object)this.modelKey));
    }
}

