/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import ai.h2o.xgboost4j.java.DMatrix;
import ai.h2o.xgboost4j.java.XGBoostError;
import java.util.Arrays;
import java.util.Objects;
import water.Iced;

public abstract class MatrixLoader
extends Iced<MatrixLoader> {
    public abstract DMatrixProvider makeLocalMatrix();

    public static abstract class DMatrixProvider {
        protected long actualRows;
        protected float[] response;
        protected float[] weights;
        protected float[] offsets;

        protected DMatrixProvider(long actualRows, float[] response, float[] weights, float[] offsets) {
            this.actualRows = actualRows;
            this.response = response;
            this.weights = weights;
            this.offsets = offsets;
        }

        protected abstract DMatrix makeDMatrix() throws XGBoostError;

        public abstract void print(int var1);

        protected void dispose() {
        }

        public final DMatrix get() throws XGBoostError {
            DMatrix mat = this.makeDMatrix();
            this.dispose();
            assert (mat.rowNum() == this.actualRows);
            mat.setLabel(this.response);
            if (this.weights != null) {
                mat.setWeight(this.weights);
            }
            if (this.offsets != null) {
                mat.setBaseMargin(this.offsets);
            }
            return mat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DMatrixProvider)) {
                return false;
            }
            DMatrixProvider that = (DMatrixProvider)o;
            return this.actualRows == that.actualRows && Arrays.equals(this.response, that.response) && Arrays.equals(this.weights, that.weights) && Arrays.equals(this.offsets, that.offsets);
        }

        public int hashCode() {
            int result = Objects.hash(this.actualRows);
            result = 31 * result + Arrays.hashCode(this.response);
            result = 31 * result + Arrays.hashCode(this.weights);
            result = 31 * result + Arrays.hashCode(this.offsets);
            return result;
        }
    }
}

