/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.util.FVec;
import hex.DataInfo;
import hex.genmodel.algos.xgboost.XGBoostJavaMojoModel;
import hex.tree.xgboost.XGBoostModelInfo;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.predict.MutableOneHotEncoderFVec;
import java.util.Arrays;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class PredictTreeSHAPTask
extends MRTask<PredictTreeSHAPTask> {
    private final DataInfo _di;
    private final XGBoostModelInfo _modelInfo;
    private final XGBoostOutput _output;
    private transient XGBoostJavaMojoModel _mojo;

    public PredictTreeSHAPTask(DataInfo di, XGBoostModelInfo modelInfo, XGBoostOutput output) {
        this._di = di;
        this._modelInfo = modelInfo;
        this._output = output;
    }

    protected void setupLocal() {
        this._mojo = new XGBoostJavaMojoModel(this._modelInfo._boosterBytes, this._output._names, this._output._domains, this._output.responseName(), true);
    }

    public void map(Chunk[] chks, NewChunk[] nc) {
        MutableOneHotEncoderFVec rowFVec = new MutableOneHotEncoderFVec(this._di, this._output._sparse);
        double[] input = MemoryManager.malloc8d((int)chks.length);
        float[] contribs = MemoryManager.malloc4f((int)nc.length);
        Object workspace = this._mojo.makeContributionsWorkspace();
        for (int row = 0; row < chks[0]._len; ++row) {
            int i;
            for (i = 0; i < chks.length; ++i) {
                input[i] = chks[i].atd(row);
            }
            Arrays.fill(contribs, 0.0f);
            rowFVec.setInput(input);
            this._mojo.calculateContributions((FVec)rowFVec, contribs, workspace);
            for (i = 0; i < nc.length; ++i) {
                nc[i].addNum((double)contribs[i]);
            }
        }
    }
}

