/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import ai.h2o.xgboost4j.java.Booster;
import ai.h2o.xgboost4j.java.XGBoostError;
import hex.tree.xgboost.predict.XGBoostVariableImportance;
import hex.tree.xgboost.util.BoosterHelper;
import hex.tree.xgboost.util.FeatureScore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import water.Key;

public class XGBoostNativeVariableImportance
implements XGBoostVariableImportance {
    private static final Logger LOG = Logger.getLogger(XGBoostNativeVariableImportance.class);
    private final File featureMapFile;

    public XGBoostNativeVariableImportance(Key modelKey, String featureMap) {
        this.featureMapFile = this.createFeatureMapFile(modelKey, featureMap);
    }

    private File createFeatureMapFile(Key modelKey, String featureMap) {
        try {
            File fmFile = Files.createTempFile("h2o_xgb_" + modelKey.toString(), ".txt", new FileAttribute[0]).toFile();
            fmFile.deleteOnExit();
            try (FileOutputStream os = new FileOutputStream(fmFile);){
                ((OutputStream)os).write(featureMap.getBytes());
            }
            return fmFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot generate feature map file", e);
        }
    }

    @Override
    public void cleanup() {
        if (this.featureMapFile != null && !this.featureMapFile.delete()) {
            LOG.warn((Object)("Unable to delete file " + this.featureMapFile + ". Please do a manual clean-up."));
        }
    }

    @Override
    public Map<String, FeatureScore> getFeatureScores(byte[] boosterBytes) {
        Map<String, FeatureScore> map;
        block5: {
            Booster booster = null;
            try {
                booster = BoosterHelper.loadModel(boosterBytes);
                map = BoosterHelper.doWithLocalRabit(new BoosterHelper.BoosterOp<Map<String, FeatureScore>>(){

                    @Override
                    public Map<String, FeatureScore> apply(Booster booster) throws XGBoostError {
                        String fmPath = XGBoostNativeVariableImportance.this.featureMapFile.getAbsolutePath();
                        String[] modelDump = booster.getModelDump(fmPath, true);
                        return XGBoostNativeVariableImportance.parseFeatureScores(modelDump);
                    }
                }, booster);
                if (booster == null) break block5;
            }
            catch (XGBoostError e) {
                try {
                    throw new RuntimeException("Failed getting feature scores.", e);
                }
                catch (Throwable throwable) {
                    if (booster != null) {
                        BoosterHelper.dispose(booster);
                    }
                    throw throwable;
                }
            }
            BoosterHelper.dispose(booster);
        }
        return map;
    }

    public static Map<String, FeatureScore> parseFeatureScores(String[] modelDump) {
        HashMap<String, FeatureScore> featureScore = new HashMap<String, FeatureScore>();
        for (String tree : modelDump) {
            for (String node : tree.split("\n")) {
                String[] keyValues;
                String[] content;
                String[] array = node.split("\\[", 2);
                if (array.length < 2 || (content = array[1].split("\\]", 2)).length < 2) continue;
                String fid = content[0].split("<")[0];
                FeatureScore fs = new FeatureScore();
                for (String keyValue : keyValues = content[1].split(",")) {
                    if (keyValue.startsWith("gain=")) {
                        fs._gain = Float.parseFloat(keyValue.substring("gain".length() + 1));
                        continue;
                    }
                    if (!keyValue.startsWith("cover=")) continue;
                    fs._cover = Float.parseFloat(keyValue.substring("cover".length() + 1));
                }
                if (featureScore.containsKey(fid)) {
                    ((FeatureScore)featureScore.get(fid)).add(fs);
                    continue;
                }
                featureScore.put(fid, fs);
            }
        }
        return featureScore;
    }
}

