/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.exec;

import hex.genmodel.utils.IOUtils;
import hex.schemas.XGBoostExecReqV3;
import hex.schemas.XGBoostExecRespV3;
import hex.tree.xgboost.exec.XGBoostExecReq;
import hex.tree.xgboost.remote.RemoteXGBoostUploadServlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import water.Key;

public class XGBoostHttpClient {
    private static final Logger LOG = Logger.getLogger(XGBoostHttpClient.class);
    private final String baseUri;
    private final HttpClientBuilder clientBuilder;
    private final UsernamePasswordCredentials credentials;
    private static final ResponseTransformer<byte[]> ByteArrayResponseTransformer = e -> {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)e.getContent(), (OutputStream)bos);
        bos.close();
        byte[] b = bos.toByteArray();
        if (b.length == 0) {
            return null;
        }
        return b;
    };
    private static final ResponseTransformer<XGBoostExecRespV3> JsonResponseTransformer = e -> {
        String responseBody = EntityUtils.toString((HttpEntity)e);
        XGBoostExecRespV3 resp = new XGBoostExecRespV3();
        resp.fillFromBody(responseBody);
        return resp;
    };

    public XGBoostHttpClient(String baseUri, boolean https, String userName, String password) {
        String suffix = "3/XGBoostExecutor.";
        if (!baseUri.endsWith("/")) {
            suffix = "/" + suffix;
        }
        this.baseUri = (https ? "https" : "http") + "://" + baseUri + suffix;
        this.credentials = userName != null ? new UsernamePasswordCredentials(userName, password) : null;
        this.clientBuilder = this.createClientBuilder(https);
    }

    private HttpClientBuilder createClientBuilder(boolean https) {
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            if (https) {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build();
                SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslFactory);
            }
            if (this.credentials != null) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(AuthScope.ANY, (Credentials)this.credentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
            return builder;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Failed to initialize HTTP client.", e);
        }
    }

    public XGBoostExecRespV3 postJson(Key key, String method, XGBoostExecReq reqContent) {
        return this.post(key, method, reqContent, JsonResponseTransformer);
    }

    public byte[] downloadBytes(Key key, String method, XGBoostExecReq reqContent) {
        return this.post(key, method, reqContent, ByteArrayResponseTransformer);
    }

    private <T> T post(Key key, String method, XGBoostExecReq reqContent, ResponseTransformer<T> transformer) {
        LOG.info((Object)("Request " + method + " " + key + " " + reqContent));
        XGBoostExecReqV3 req = new XGBoostExecReqV3(key, reqContent);
        HttpPost httpReq = new HttpPost(this.baseUri + method);
        httpReq.setEntity((HttpEntity)new StringEntity(req.toJsonString(), StandardCharsets.UTF_8));
        httpReq.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        return this.executeRequestAndReturnResponse(httpReq, transformer);
    }

    private HttpPost makeUploadRequest(Key key, RemoteXGBoostUploadServlet.RequestType dataType) {
        try {
            URIBuilder uri = new URIBuilder(this.baseUri + "upload");
            uri.setParameter("model_key", key.toString()).setParameter("data_type", dataType.toString());
            return new HttpPost(uri.build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to build request URI.", e);
        }
    }

    public void uploadBytes(Key key, RemoteXGBoostUploadServlet.RequestType dataType, byte[] data) {
        LOG.info((Object)("Request upload " + key + " " + (Object)((Object)dataType) + " " + data.length + " bytes"));
        HttpPost httpReq = this.makeUploadRequest(key, dataType);
        httpReq.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(data)));
        this.addAuthentication(httpReq);
        XGBoostExecRespV3 resp = this.executeRequestAndReturnResponse(httpReq, JsonResponseTransformer);
        assert (resp.key.key().equals((Object)key));
    }

    public void uploadObject(Key key, RemoteXGBoostUploadServlet.RequestType dataType, Object data) {
        LOG.info((Object)("Request upload " + key + " " + (Object)((Object)dataType) + " " + data.getClass().getSimpleName()));
        HttpPost httpReq = this.makeUploadRequest(key, dataType);
        httpReq.setEntity((HttpEntity)new ObjectEntity(data));
        this.addAuthentication(httpReq);
        XGBoostExecRespV3 resp = this.executeRequestAndReturnResponse(httpReq, JsonResponseTransformer);
        assert (resp.key.key().equals((Object)key));
    }

    private void addAuthentication(HttpPost httpReq) {
        if (this.credentials != null) {
            try {
                httpReq.addHeader(new BasicScheme().authenticate((Credentials)this.credentials, (HttpRequest)httpReq, null));
            }
            catch (AuthenticationException e) {
                throw new IllegalStateException("Unable to authenticate request.", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <T> T executeRequestAndReturnResponse(HttpPost req, ResponseTransformer<T> transformer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class ObjectEntity
    extends AbstractHttpEntity {
        private final Object object;

        private ObjectEntity(Object object) {
            this.object = object;
        }

        public void writeTo(OutputStream out) throws IOException {
            LOG.debug((Object)("Sending " + this.object));
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(this.object);
            os.flush();
        }

        public boolean isStreaming() {
            return true;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    static interface ResponseTransformer<T> {
        public T transform(HttpEntity var1) throws IOException;
    }
}

