/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeFactory;
import biz.k11i.xgboost.util.ModelReader;
import hex.tree.xgboost.predict.XGBoostRegTree;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class PredictorFactory {
    public static Predictor makePredictor(byte[] boosterBytes) {
        return PredictorFactory.makePredictor(boosterBytes, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Predictor makePredictor(byte[] boosterBytes, boolean scoringOnly) {
        PredictorConfiguration.Builder bldr = PredictorConfiguration.builder();
        if (scoringOnly && PredictorFactory.unsafeTreesSupported()) {
            bldr.regTreeFactory((RegTreeFactory)UnsafeRegTreeFactory.INSTANCE);
        }
        PredictorConfiguration cfg = bldr.build();
        try (ByteArrayInputStream is = new ByteArrayInputStream(boosterBytes);){
            Predictor predictor = new Predictor((InputStream)is, cfg);
            return predictor;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean unsafeTreesSupported() {
        return ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    }

    private static class UnsafeRegTreeFactory
    implements RegTreeFactory {
        private static final UnsafeRegTreeFactory INSTANCE = new UnsafeRegTreeFactory();

        private UnsafeRegTreeFactory() {
        }

        public RegTree loadTree(ModelReader reader) throws IOException {
            return new XGBoostRegTree(reader);
        }
    }
}

