/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.util.FVec;
import hex.DataInfo;
import hex.Model;
import hex.genmodel.algos.xgboost.XGBoostMojoModel;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.predict.MutableOneHotEncoderFVec;
import hex.tree.xgboost.predict.XGBoostPredict;
import water.fvec.Chunk;
import water.fvec.Frame;

public class XGBoostJavaBigScoreChunkPredict
implements XGBoostPredict,
Model.BigScoreChunkPredict {
    private final XGBoostOutput _output;
    private final double _threshold;
    private final Predictor _predictor;
    private final MutableOneHotEncoderFVec _row;
    private final int _offsetIndex;

    public XGBoostJavaBigScoreChunkPredict(DataInfo di, XGBoostOutput output, XGBoostModel.XGBoostParameters parms, double threshold, Predictor predictor, Frame data) {
        this._output = output;
        this._threshold = threshold;
        this._predictor = predictor;
        this._row = new MutableOneHotEncoderFVec(di, this._output._sparse);
        this._offsetIndex = data.find(parms._offset_column);
    }

    public double[] score0(Chunk[] chks, double offset, int row_in_chunk, double[] tmp, double[] preds) {
        float[] out;
        assert (this._output.nfeatures() == tmp.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].atd(row_in_chunk);
        }
        this._row.setInput(tmp);
        if (this._output.hasOffset()) {
            out = this._predictor.predict((FVec)this._row, (float)offset);
        } else {
            if (offset != 0.0) {
                throw new IllegalArgumentException("Model was not trained with offset_column, but offset != 0");
            }
            out = this._predictor.predict((FVec)this._row);
        }
        return XGBoostMojoModel.toPreds((double[])tmp, (float[])out, (double[])preds, (int)this._output.nclasses(), (double[])this._output._priorClassDist, (double)this._threshold);
    }

    @Override
    public float[][] predict(Chunk[] cs) {
        float[][] preds = new float[cs[0]._len][];
        double[] tmp = new double[this._output.nfeatures()];
        for (int row = 0; row < cs[0]._len; ++row) {
            for (int col = 0; col < tmp.length; ++col) {
                tmp[col] = cs[col].atd(row);
            }
            this._row.setInput(tmp);
            if (this._offsetIndex >= 0) {
                float offset = (float)cs[this._offsetIndex].atd(row);
                preds[row] = this._predictor.predict((FVec)this._row, offset);
                continue;
            }
            preds[row] = this._predictor.predict((FVec)this._row);
        }
        return preds;
    }

    public void close() {
    }
}

