/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import water.BootstrapFreezable;
import water.Iced;
import water.util.ArrayUtils;

public final class SparseMatrixDimensions
extends Iced<SparseMatrixDimensions>
implements BootstrapFreezable<SparseMatrixDimensions> {
    public final int[] _precedingRowCounts;
    public final long[] _precedingNonZeroElementsCounts;
    public final long _nonZeroElementsCount;
    public final int _rowHeadersCount;

    public SparseMatrixDimensions(int[] nonZeroElementsCounts, int[] rowIndicesCounts) {
        int precedingRowCount = 0;
        long precedingNonZeroCount = 0L;
        this._precedingRowCounts = new int[rowIndicesCounts.length];
        this._precedingNonZeroElementsCounts = new long[nonZeroElementsCounts.length];
        assert (rowIndicesCounts.length == nonZeroElementsCounts.length);
        for (int i = 0; i < nonZeroElementsCounts.length; ++i) {
            this._precedingRowCounts[i] = precedingRowCount;
            this._precedingNonZeroElementsCounts[i] = precedingNonZeroCount;
            precedingRowCount += rowIndicesCounts[i];
            precedingNonZeroCount += (long)nonZeroElementsCounts[i];
        }
        this._nonZeroElementsCount = ArrayUtils.suml((int[])nonZeroElementsCounts);
        this._rowHeadersCount = ArrayUtils.sum((int[])rowIndicesCounts) + 1;
    }
}

