/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import water.util.PrettyPrint;

public class MemoryCheck {
    public static Report runCheck(double offHeapRatio) {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        GlobalMemory globalMemory = hardware.getMemory();
        Runtime runtime = Runtime.getRuntime();
        long available = globalMemory.getAvailable();
        long availableOffHeap = Math.max(available - (runtime.maxMemory() - runtime.totalMemory()), 0L);
        long desiredOffHeap = (long)((double)runtime.maxMemory() * offHeapRatio);
        return new Report(availableOffHeap, desiredOffHeap);
    }

    public static class Report {
        public final long _available_off_heap;
        public final long _desired_off_heap;

        public Report(long available_off_heap, long desired_off_heap) {
            this._available_off_heap = available_off_heap;
            this._desired_off_heap = desired_off_heap;
        }

        public boolean isOffHeapRequirementMet() {
            return this._available_off_heap >= this._desired_off_heap;
        }

        public String toString() {
            return "Estimated Available Off-Heap (assuming JVM heap reaches maximum size): " + PrettyPrint.bytes((long)this._available_off_heap) + ", Desired Off-Heap: " + PrettyPrint.bytes((long)this._desired_off_heap);
        }
    }
}

