/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import ai.h2o.xgboost4j.java.INativeLibLoader;
import ai.h2o.xgboost4j.java.NativeLibLoader;
import hex.tree.xgboost.MemoryCheck;
import hex.tree.xgboost.util.NativeLibrary;
import hex.tree.xgboost.util.NativeLibraryLoaderChain;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import water.AbstractH2OExtension;
import water.H2O;

public class XGBoostExtension
extends AbstractH2OExtension {
    private static final Logger LOG = Logger.getLogger(XGBoostExtension.class);
    private static final String XGBOOST_MIN_REQUIREMENTS = "Xgboost (enabled GPUs) needs: \n  - CUDA 8.0\nXGboost (minimal version) needs: \n  - GCC 4.7+\nFor more details, run in debug mode: `java -Dlog4j.configuration=file:///tmp/log4j.properties -jar h2o.jar`\n";
    private boolean isInitCalled = false;
    private boolean isXgboostPresent = false;
    private NativeLibInfo nativeLibInfo = null;
    public static String NAME = "XGBoost";

    public String getExtensionName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        if (!this.isInitCalled) {
            XGBoostExtension xGBoostExtension = this;
            synchronized (xGBoostExtension) {
                if (!this.isInitCalled) {
                    this.isXgboostPresent = this.initXgboost();
                    this.isInitCalled = true;
                }
            }
        }
        return this.isXgboostPresent;
    }

    public void logNativeLibInfo() {
        LOG.info((Object)("Found XGBoost backend with library: " + this.nativeLibInfo.name));
        if (this.nativeLibInfo.flags.length == 0) {
            LOG.warn((Object)"Your system supports only minimal version of XGBoost (no GPUs, no multithreading)!");
        } else {
            LOG.info((Object)("XGBoost supported backends: " + Arrays.toString((Object[])this.nativeLibInfo.flags)));
        }
    }

    public static NativeLibraryLoaderChain getLoader() throws IOException {
        INativeLibLoader loader = NativeLibLoader.getLoader();
        if (!(loader instanceof NativeLibraryLoaderChain)) {
            LOG.warn((Object)"Unexpected XGBoost library loader found. Custom loaders are not supported in this version. XGBoost extension will be disabled.");
            return null;
        }
        return (NativeLibraryLoaderChain)loader;
    }

    public void onLocalNodeStarted() {
        MemoryCheck.Report report;
        if (!this.isEnabled()) {
            return;
        }
        double ratio = H2O.ARGS.off_heap_memory_ratio;
        if (H2O.ARGS.off_heap_memory_ratio > 0.0 && !(report = MemoryCheck.runCheck(ratio)).isOffHeapRequirementMet()) {
            LOG.warn((Object)("There doesn't seem to be enough memory available for XGBoost model training (off_heap_memory_ratio=" + ratio + "), training XGBoost models is not advised. Details: " + report));
        }
    }

    private boolean initXgboost() {
        try {
            NativeLibraryLoaderChain chainLoader = XGBoostExtension.getLoader();
            if (chainLoader == null) {
                return false;
            }
            NativeLibrary lib = chainLoader.getLoadedLibrary();
            this.nativeLibInfo = new NativeLibInfo(lib);
            return true;
        }
        catch (IOException e) {
            LOG.warn((Object)"Cannot initialize XGBoost backend! Xgboost (enabled GPUs) needs: \n  - CUDA 8.0\nXGboost (minimal version) needs: \n  - GCC 4.7+\nFor more details, run in debug mode: `java -Dlog4j.configuration=file:///tmp/log4j.properties -jar h2o.jar`\n");
            return false;
        }
    }

    private static class NativeLibInfo {
        String name;
        NativeLibrary.CompilationFlags[] flags;

        private NativeLibInfo(NativeLibrary nl) {
            this.name = nl.getName();
            this.flags = nl.getCompilationFlags();
        }
    }
}

