/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.Model;
import hex.ModelMojoWriter;
import hex.glm.GLMModel;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import java.io.IOException;
import java.nio.charset.Charset;

public class XGBoostMojoWriter
extends ModelMojoWriter<XGBoostModel, XGBoostModel.XGBoostParameters, XGBoostOutput> {
    public XGBoostMojoWriter() {
    }

    public XGBoostMojoWriter(XGBoostModel model) {
        super((Model)model);
    }

    public String mojoVersion() {
        return "1.10";
    }

    protected void writeModelData() throws IOException {
        this.writeblob("boosterBytes", ((XGBoostModel)this.model).model_info()._boosterBytes);
        byte[] auxNodeWeightBytes = ((XGBoostModel)this.model).model_info().auxNodeWeightBytes();
        if (auxNodeWeightBytes != null) {
            this.writeblob("auxNodeWeights", auxNodeWeightBytes);
        }
        this.writekv("nums", ((XGBoostOutput)((XGBoostModel)this.model)._output)._nums);
        this.writekv("cats", ((XGBoostOutput)((XGBoostModel)this.model)._output)._cats);
        this.writekv("cat_offsets", ((XGBoostOutput)((XGBoostModel)this.model)._output)._catOffsets);
        this.writekv("use_all_factor_levels", ((XGBoostOutput)((XGBoostModel)this.model)._output)._useAllFactorLevels);
        this.writekv("sparse", ((XGBoostOutput)((XGBoostModel)this.model)._output)._sparse);
        this.writekv("booster", ((XGBoostModel.XGBoostParameters)((XGBoostModel)this.model)._parms)._booster.toString());
        this.writekv("ntrees", ((XGBoostOutput)((XGBoostModel)this.model)._output)._ntrees);
        this.writeblob("feature_map", ((XGBoostModel)this.model).model_info().getFeatureMap().getBytes(Charset.forName("UTF-8")));
        this.writekv("use_java_scoring_by_default", true);
        if (((XGBoostOutput)((XGBoostModel)this.model)._output)._calib_model != null) {
            GLMModel calibModel = ((XGBoostOutput)((XGBoostModel)this.model)._output)._calib_model;
            double[] beta = calibModel.beta();
            assert (beta.length == ((XGBoostOutput)((XGBoostModel)this.model)._output).nclasses());
            this.writekv("calib_method", "platt");
            this.writekv("calib_glm_beta", beta);
        }
        this.writekv("has_offset", ((XGBoostOutput)((XGBoostModel)this.model)._output).hasOffset());
    }
}

