/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeFactory;
import biz.k11i.xgboost.util.ModelReader;
import hex.genmodel.algos.xgboost.XGBoostJavaMojoModel;
import hex.tree.xgboost.predict.XGBoostRegTree;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class PredictorFactory {
    public static Predictor makePredictor(byte[] boosterBytes) {
        return PredictorFactory.makePredictor(boosterBytes, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Predictor makePredictor(byte[] boosterBytes, byte[] auxNodeWeightBytes, boolean scoringOnly) {
        PredictorConfiguration.Builder bldr = PredictorConfiguration.builder();
        if (scoringOnly && PredictorFactory.unsafeTreesSupported()) {
            bldr.regTreeFactory((RegTreeFactory)UnsafeRegTreeFactory.INSTANCE);
        }
        PredictorConfiguration cfg = bldr.build();
        try (ByteArrayInputStream is = new ByteArrayInputStream(boosterBytes);){
            Predictor p = new Predictor((InputStream)is, cfg);
            if (!scoringOnly && auxNodeWeightBytes != null) {
                XGBoostJavaMojoModel.updateNodeWeights((Predictor)p, (byte[])auxNodeWeightBytes);
            }
            Predictor predictor = p;
            return predictor;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean unsafeTreesSupported() {
        return ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    }

    private static class UnsafeRegTreeFactory
    implements RegTreeFactory {
        private static final UnsafeRegTreeFactory INSTANCE = new UnsafeRegTreeFactory();

        private UnsafeRegTreeFactory() {
        }

        public RegTree loadTree(ModelReader reader) throws IOException {
            return new XGBoostRegTree(reader);
        }
    }
}

