/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import hex.Model;
import hex.ModelMetrics;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.task.XGBoostScoreTask;
import java.util.Arrays;
import water.Key;
import water.Scope;
import water.fvec.Frame;
import water.fvec.Vec;

public class XGBoostModelMetrics {
    private final XGBoostOutput _output;
    private final Frame _data;
    private final Frame _originalData;
    private final XGBoostModel _model;
    private final XGBoostScoreTask _task;

    public XGBoostModelMetrics(XGBoostOutput output, Frame data, Frame originalData, boolean isTrain, XGBoostModel model) {
        this._output = output;
        this._data = data;
        this._originalData = originalData;
        this._model = model;
        this._task = new XGBoostScoreTask(this._output, this._data.find(((XGBoostModel.XGBoostParameters)this._model._parms)._weights_column), isTrain, this._model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelMetrics compute() {
        Scope.enter();
        try {
            Frame preds = Scope.track((Frame[])new Frame[]{this.runScoreTask()});
            if (this._output.nclasses() == 1) {
                Vec pred = preds.vec(0);
                ModelMetrics modelMetrics = this._task._metricBuilder.makeModelMetrics((Model)this._model, this._originalData, this._data, new Frame(new Vec[]{pred}));
                return modelMetrics;
            }
            if (this._output.nclasses() == 2) {
                Vec p1 = preds.vec(2);
                ModelMetrics modelMetrics = this._task._metricBuilder.makeModelMetrics((Model)this._model, this._originalData, this._data, new Frame(new Vec[]{p1}));
                return modelMetrics;
            }
            Frame pp = new Frame(preds);
            pp.remove(0);
            ModelMetrics modelMetrics = this._task._metricBuilder.makeModelMetrics((Model)this._model, this._originalData, this._data, pp);
            return modelMetrics;
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private Frame runScoreTask() {
        this._task.doAll(this.outputTypes(), this._data);
        String[] names = Model.makeScoringNames((Model.Output)this._output);
        return this._task.outputFrame(null, names, this.makeDomains(names));
    }

    private byte[] outputTypes() {
        if (this._output.nclasses() == 1) {
            return new byte[]{3};
        }
        if (this._output.nclasses() == 2) {
            return new byte[]{4, 3, 3};
        }
        byte[] types = new byte[this._output.nclasses() + 1];
        Arrays.fill(types, (byte)3);
        return types;
    }

    private String[][] makeDomains(String[] names) {
        if (this._output.nclasses() == 1) {
            return null;
        }
        String[][] domains = new String[names.length][];
        domains[0] = this._output.classNames();
        return domains;
    }
}

