/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.task;

import hex.tree.xgboost.XGBoostExtension;
import water.ExtensionManager;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.MRTask;

public abstract class AbstractXGBoostTask<T extends MRTask<T>>
extends MRTask<T> {
    final Key _modelKey;
    private final boolean[] _hasDMatrix;

    AbstractXGBoostTask(AbstractXGBoostTask<?> setupTask) {
        this(setupTask._modelKey, setupTask._hasDMatrix);
    }

    AbstractXGBoostTask(Key modelKey, boolean[] hasDMatrix) {
        this._modelKey = modelKey;
        this._hasDMatrix = hasDMatrix;
    }

    protected final void setupLocal() {
        assert (this._fr == null) : "MRTask invoked on a Frame with no intention to run map() on Chunks might not invoke reduce(); use doAllNodes() to make sure reduce() will be called.";
        if (H2O.ARGS.client) {
            return;
        }
        if (!this._hasDMatrix[H2O.SELF.index()]) {
            return;
        }
        if (!ExtensionManager.getInstance().isCoreExtensionEnabled(XGBoostExtension.NAME)) {
            throw new IllegalStateException("XGBoost is not available on the node " + H2O.SELF);
        }
        this.execute();
    }

    abstract void execute();

    public T run() {
        return (T)this.doAllNodes();
    }

    H2ONode getBoosterNode() {
        for (int i = 0; i < H2O.CLOUD.size(); ++i) {
            if (!this._hasDMatrix[i]) continue;
            return H2O.CLOUD._memary[i];
        }
        throw new IllegalStateException("No node of the cluster is holding a Booster");
    }
}

