/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.exec;

import hex.DataInfo;
import hex.genmodel.utils.IOUtils;
import hex.tree.xgboost.BoosterParms;
import hex.tree.xgboost.EvalMetric;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.exec.XGBoostExecReq;
import hex.tree.xgboost.exec.XGBoostExecutor;
import hex.tree.xgboost.matrix.FrameMatrixLoader;
import hex.tree.xgboost.matrix.MatrixLoader;
import hex.tree.xgboost.matrix.RemoteMatrixLoader;
import hex.tree.xgboost.rabit.RabitTrackerH2O;
import hex.tree.xgboost.remote.RemoteXGBoostUploadServlet;
import hex.tree.xgboost.task.XGBoostCleanupTask;
import hex.tree.xgboost.task.XGBoostSetupTask;
import hex.tree.xgboost.task.XGBoostUpdateTask;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import water.H2O;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.util.Log;

public class LocalXGBoostExecutor
implements XGBoostExecutor {
    public final Key modelKey;
    private final BoosterParms boosterParams;
    private final MatrixLoader loader;
    private final CheckpointProvider checkpointProvider;
    private final boolean[] nodes;
    private final String saveMatrixDirectory;
    private final RabitTrackerH2O rt;
    private final Key<Frame> toCleanUp;
    private XGBoostSetupTask setupTask;
    private XGBoostUpdateTask updateTask;
    private EvalMetric evalMetric;

    public LocalXGBoostExecutor(Key key, XGBoostExecReq.Init init) {
        this.modelKey = key;
        this.rt = this.setupRabitTracker(init.num_nodes);
        this.boosterParams = BoosterParms.fromMap((Map<String, Object>)init.parms);
        this.nodes = new boolean[H2O.CLOUD.size()];
        for (int i = 0; i < init.num_nodes; ++i) {
            this.nodes[i] = init.nodes[i] != null;
        }
        this.loader = new RemoteMatrixLoader(this.modelKey);
        this.toCleanUp = null;
        this.saveMatrixDirectory = init.save_matrix_path;
        this.checkpointProvider = () -> {
            if (!init.has_checkpoint) {
                return null;
            }
            File checkpointFile = RemoteXGBoostUploadServlet.getCheckpointFile(this.modelKey.toString());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (FileInputStream fis = new FileInputStream(checkpointFile);){
                IOUtils.copyStream((InputStream)fis, (OutputStream)bos);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed writing data to response.", e);
            }
            finally {
                checkpointFile.delete();
            }
            return bos.toByteArray();
        };
    }

    public LocalXGBoostExecutor(XGBoostModel model, Frame train, Frame valid) {
        this.modelKey = model._key;
        XGBoostSetupTask.FrameNodes trainFrameNodes = XGBoostSetupTask.findFrameNodes(train);
        if (valid != null) {
            XGBoostSetupTask.FrameNodes validFrameNodes = XGBoostSetupTask.findFrameNodes(valid);
            if (!validFrameNodes.isSubsetOf(trainFrameNodes)) {
                Log.warn((Object[])new Object[]{"Need to re-distribute the Validation Frame because it has data on nodes that don't have any data of the training matrix. This might impact runtime performance."});
                this.toCleanUp = Key.make();
                valid = train.makeSimilarlyDistributed(valid, this.toCleanUp);
            } else {
                this.toCleanUp = null;
            }
        } else {
            this.toCleanUp = null;
        }
        this.rt = this.setupRabitTracker(trainFrameNodes.getNumNodes());
        DataInfo dataInfo = model.model_info().dataInfo();
        this.boosterParams = XGBoostModel.createParams((XGBoostModel.XGBoostParameters)model._parms, ((XGBoostOutput)model._output).nclasses(), dataInfo.coefNames());
        ((XGBoostOutput)model._output)._native_parameters = this.boosterParams.toTwoDimTable();
        this.loader = new FrameMatrixLoader(model, train, valid);
        this.nodes = trainFrameNodes._nodes;
        this.saveMatrixDirectory = ((XGBoostModel.XGBoostParameters)model._parms)._save_matrix_directory;
        this.checkpointProvider = () -> {
            if (((XGBoostModel.XGBoostParameters)model._parms).hasCheckpoint()) {
                return model.model_info()._boosterBytes;
            }
            return null;
        };
    }

    @Override
    public byte[] setup() {
        this.setupTask = new XGBoostSetupTask(this.modelKey, this.saveMatrixDirectory, this.boosterParams, this.checkpointProvider.get(), this.getRabitEnv(), this.nodes, this.loader);
        this.setupTask.run();
        this.updateTask = (XGBoostUpdateTask)((Object)new XGBoostUpdateTask(this.setupTask, 0).run());
        return this.updateTask.getBoosterBytes();
    }

    private RabitTrackerH2O setupRabitTracker(int numNodes) {
        if (numNodes > 1) {
            RabitTrackerH2O rt = new RabitTrackerH2O(numNodes);
            rt.start(0L);
            return rt;
        }
        return null;
    }

    private void stopRabitTracker() {
        if (this.rt != null) {
            this.rt.waitFor(0L);
            this.rt.stop();
        }
    }

    private Map<String, String> getRabitEnv() {
        if (this.rt != null) {
            return this.rt.getWorkerEnvs();
        }
        return new HashMap<String, String>();
    }

    @Override
    public void update(int treeId) {
        this.evalMetric = null;
        this.updateTask = new XGBoostUpdateTask(this.setupTask, treeId);
        this.updateTask.run();
    }

    @Override
    public EvalMetric getEvalMetric() {
        if (this.evalMetric != null) {
            return this.evalMetric;
        }
        if (this.updateTask == null) {
            throw new IllegalStateException("Custom metric can only be retrieved immediately after running update iteration.");
        }
        this.evalMetric = this.updateTask.getEvalMetric();
        return this.evalMetric;
    }

    @Override
    public byte[] updateBooster() {
        if (this.updateTask != null) {
            byte[] booster = this.updateTask.getBoosterBytes();
            this.updateTask = null;
            return booster;
        }
        return null;
    }

    @Override
    public void close() {
        if (this.toCleanUp != null) {
            Keyed.remove(this.toCleanUp);
        }
        XGBoostCleanupTask.cleanUp(this.setupTask);
        this.stopRabitTracker();
    }

    static interface CheckpointProvider {
        public byte[] get();
    }
}

