/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.exec;

import hex.DataInfo;
import hex.schemas.XGBoostExecRespV3;
import hex.tree.xgboost.BoosterParms;
import hex.tree.xgboost.EvalMetric;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.exec.XGBoostExecReq;
import hex.tree.xgboost.exec.XGBoostExecutor;
import hex.tree.xgboost.exec.XGBoostHttpClient;
import hex.tree.xgboost.remote.RemoteXGBoostHandler;
import hex.tree.xgboost.task.XGBoostSetupTask;
import hex.tree.xgboost.task.XGBoostUploadMatrixTask;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;
import water.H2O;
import water.Key;
import water.Keyed;
import water.TypeMap;
import water.fvec.Frame;
import water.util.Log;

public class RemoteXGBoostExecutor
implements XGBoostExecutor {
    private static final Logger LOG = Logger.getLogger(RemoteXGBoostExecutor.class);
    public final XGBoostHttpClient http;
    public final Key modelKey;

    public RemoteXGBoostExecutor(XGBoostModel model, Frame train, Frame valid, String remoteUri, String userName, String password) {
        boolean https = H2O.ARGS.jks != null;
        this.http = new XGBoostHttpClient(remoteUri, https, userName, password);
        this.modelKey = model._key;
        XGBoostExecReq.Init req = new XGBoostExecReq.Init();
        XGBoostSetupTask.FrameNodes trainFrameNodes = XGBoostSetupTask.findFrameNodes(train);
        req.num_nodes = trainFrameNodes.getNumNodes();
        DataInfo dataInfo = model.model_info().dataInfo();
        req.setParms(XGBoostModel.createParamsMap((XGBoostModel.XGBoostParameters)model._parms, ((XGBoostOutput)model._output).nclasses(), dataInfo.coefNames()));
        ((XGBoostOutput)model._output)._native_parameters = BoosterParms.fromMap((Map<String, Object>)req.parms).toTwoDimTable();
        req.save_matrix_path = ((XGBoostModel.XGBoostParameters)model._parms)._save_matrix_directory;
        req.nodes = this.collectNodes(trainFrameNodes);
        LOG.info((Object)"Initializing remote executor.");
        XGBoostExecRespV3 resp = this.http.postJson(this.modelKey, "init", req);
        RemoteXGBoostHandler.RemoteExecutors executors = (RemoteXGBoostHandler.RemoteExecutors)((Object)resp.readData());
        if (!Arrays.equals(executors._typeMap, TypeMap.bootstrapClasses())) {
            LOG.error((Object)("TypeMap differs: H2O=" + Arrays.toString(TypeMap.bootstrapClasses()) + ";XGB=" + Arrays.toString(executors._typeMap)));
            throw new IllegalStateException("H2O Cluster and XGBoost external cluster do not have identical TypeMap.");
        }
        assert (this.modelKey.equals((Object)resp.key.key()));
        this.uploadCheckpointBooster(model);
        this.uploadMatrix(model, train, true, trainFrameNodes, executors._nodes, https, remoteUri, userName, password);
        if (valid != null) {
            XGBoostSetupTask.FrameNodes validFrameNodes = XGBoostSetupTask.findFrameNodes(valid);
            Key toCleanUp = null;
            if (!validFrameNodes.isSubsetOf(trainFrameNodes)) {
                Log.info((Object[])new Object[]{"Validation Frame will be re-distributed to be collocated with remote nodes of the training matrix."});
                toCleanUp = Key.make();
                valid = train.makeSimilarlyDistributed(valid, toCleanUp);
            }
            this.uploadMatrix(model, valid, false, validFrameNodes, executors._nodes, https, remoteUri, userName, password);
            if (toCleanUp != null) {
                Keyed.remove((Key)toCleanUp);
            }
        }
        LOG.info((Object)"Remote executor init complete.");
    }

    private void uploadMatrix(XGBoostModel model, Frame train, boolean isTrain, XGBoostSetupTask.FrameNodes trainFrameNodes, String[] remoteNodes, boolean https, String leaderUri, String userName, String password) {
        LOG.info((Object)"Starting matrix data upload.");
        new XGBoostUploadMatrixTask(model, train, isTrain, trainFrameNodes._nodes, remoteNodes, https, this.parseContextPath(leaderUri), userName, password).run();
    }

    private String parseContextPath(String leaderUri) {
        int slashIndex = leaderUri.indexOf("/");
        if (slashIndex > 0) {
            return leaderUri.substring(slashIndex);
        }
        return "";
    }

    private void uploadCheckpointBooster(XGBoostModel model) {
        if (!((XGBoostModel.XGBoostParameters)model._parms).hasCheckpoint()) {
            return;
        }
        LOG.info((Object)"Uploading booster checkpoint.");
        this.http.uploadCheckpointBytes(this.modelKey, model.model_info()._boosterBytes);
    }

    private String[] collectNodes(XGBoostSetupTask.FrameNodes nodes) {
        String[] res = new String[H2O.CLOUD.size()];
        for (int i = 0; i < nodes._nodes.length; ++i) {
            if (!nodes._nodes[i]) continue;
            res[i] = H2O.CLOUD.members()[i].getIpPortString();
        }
        return res;
    }

    @Override
    public byte[] setup() {
        XGBoostExecReq req = new XGBoostExecReq();
        return this.http.downloadBytes(this.modelKey, "setup", req);
    }

    @Override
    public void update(int treeId) {
        XGBoostExecReq.Update req = new XGBoostExecReq.Update();
        req.treeId = treeId;
        XGBoostExecRespV3 resp = this.http.postJson(this.modelKey, "update", req);
        assert (resp.key.key().equals((Object)this.modelKey));
    }

    @Override
    public byte[] updateBooster() {
        XGBoostExecReq req = new XGBoostExecReq();
        return this.http.downloadBytes(this.modelKey, "getBooster", req);
    }

    @Override
    public EvalMetric getEvalMetric() {
        XGBoostExecReq.GetEvalMetric req = new XGBoostExecReq.GetEvalMetric();
        XGBoostExecRespV3 resp = this.http.postJson(this.modelKey, "getEvalMetric", req);
        assert (resp.key.key().equals((Object)this.modelKey));
        return (EvalMetric)((Object)resp.readData());
    }

    @Override
    public void close() {
        XGBoostExecReq req = new XGBoostExecReq();
        XGBoostExecRespV3 resp = this.http.postJson(this.modelKey, "cleanup", req);
        assert (resp.key.key().equals((Object)this.modelKey));
    }
}

