/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostModelInfo;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.XGBoostUtils;
import hex.tree.xgboost.matrix.MatrixLoader;
import water.fvec.Frame;

public class FrameMatrixLoader
extends MatrixLoader {
    private final XGBoostModelInfo _modelInfo;
    private final XGBoostModel.XGBoostParameters _parms;
    private final boolean _sparse;
    private final Frame _trainFrame;
    private final Frame _validFrame;

    public FrameMatrixLoader(XGBoostModel model, Frame train, Frame validFrame) {
        this._modelInfo = model.model_info();
        this._parms = (XGBoostModel.XGBoostParameters)model._parms;
        this._sparse = ((XGBoostOutput)model._output)._sparse;
        this._trainFrame = train;
        this._validFrame = validFrame;
    }

    @Override
    public MatrixLoader.DMatrixProvider makeLocalTrainMatrix() {
        return XGBoostUtils.convertFrameToDMatrix(this._modelInfo.dataInfo(), this._trainFrame, this._parms._response_column, this._parms._weights_column, this._parms._offset_column, this._sparse);
    }

    @Override
    public boolean hasValidationFrame() {
        return this._validFrame != null;
    }

    @Override
    public MatrixLoader.DMatrixProvider makeLocalValidMatrix() {
        return XGBoostUtils.convertFrameToDMatrix(this._modelInfo.dataInfo(), this._validFrame, this._parms._response_column, this._parms._weights_column, this._parms._offset_column, this._sparse);
    }
}

