/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.rabit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import water.util.Pair;

public class LinkMap {
    private int numWorkers;
    public Map<Integer, List<Integer>> treeMap = new LinkedHashMap<Integer, List<Integer>>();
    public Map<Integer, Integer> parentMap = new LinkedHashMap<Integer, Integer>();
    public Map<Integer, Pair<Integer, Integer>> ringMap = new LinkedHashMap<Integer, Pair<Integer, Integer>>();

    public LinkMap(int numWorkers) {
        this.numWorkers = numWorkers;
        Map<Integer, List<Integer>> treeMap_ = this.initTreeMap();
        Map<Integer, Integer> parentMap_ = this.initParentMap();
        Map<Integer, Pair<Integer, Integer>> ringMap_ = this.constructRingMap(treeMap_, parentMap_);
        LinkedHashMap<Integer, Integer> rMap_ = new LinkedHashMap<Integer, Integer>(numWorkers - 1);
        rMap_.put(0, 0);
        int k = 0;
        for (int i = 0; i < numWorkers - 1; ++i) {
            int n;
            k = n = ((Integer)ringMap_.get(k)._2()).intValue();
            rMap_.put(n, i + 1);
        }
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : ringMap_.entrySet()) {
            this.ringMap.put((Integer)rMap_.get(entry.getKey()), (Pair<Integer, Integer>)new Pair(rMap_.get(entry.getValue()._1()), rMap_.get(entry.getValue()._2())));
        }
        for (Map.Entry<Integer, Object> entry : treeMap_.entrySet()) {
            ArrayList mapped = new ArrayList(((List)entry.getValue()).size());
            for (Integer v : (List)entry.getValue()) {
                mapped.add(rMap_.get(v));
            }
            this.treeMap.put((Integer)rMap_.get(entry.getKey()), mapped);
        }
        for (Map.Entry<Integer, Object> entry : parentMap_.entrySet()) {
            if (entry.getKey() == 0) {
                this.parentMap.put((Integer)rMap_.get(entry.getKey()), -1);
                continue;
            }
            this.parentMap.put((Integer)rMap_.get(entry.getKey()), (Integer)rMap_.get(entry.getValue()));
        }
    }

    Map<Integer, List<Integer>> initTreeMap() {
        LinkedHashMap<Integer, List<Integer>> treeMap = new LinkedHashMap<Integer, List<Integer>>(this.numWorkers);
        for (int r = 0; r < this.numWorkers; ++r) {
            treeMap.put(r, this.getNeighbours(r));
        }
        return treeMap;
    }

    Map<Integer, Integer> initParentMap() {
        LinkedHashMap<Integer, Integer> parentMap = new LinkedHashMap<Integer, Integer>(this.numWorkers);
        for (int r = 0; r < this.numWorkers; ++r) {
            parentMap.put(r, (r + 1) / 2 - 1);
        }
        return parentMap;
    }

    List<Integer> getNeighbours(int rank) {
        if (rank < 0) {
            throw new IllegalStateException("Rank should be non negative");
        }
        if (rank >= this.numWorkers) {
            throw new IllegalStateException("Rank [" + rank + "] too high for the number of workers [" + this.numWorkers + "]");
        }
        ArrayList<Integer> neighbour = new ArrayList<Integer>();
        if (++rank > 1) {
            neighbour.add(rank / 2 - 1);
        }
        if (rank * 2 - 1 < this.numWorkers) {
            neighbour.add(rank * 2 - 1);
        }
        if (rank * 2 < this.numWorkers) {
            neighbour.add(rank * 2);
        }
        return neighbour;
    }

    List<Integer> constructShareRing(Map<Integer, List<Integer>> treeMap, Map<Integer, Integer> parentMap, int rank) {
        LinkedHashSet connectionSet = new LinkedHashSet(treeMap.get(rank));
        connectionSet.remove(parentMap.get(rank));
        if (connectionSet.isEmpty()) {
            return Collections.singletonList(rank);
        }
        LinkedList<Integer> ringSeq = new LinkedList<Integer>();
        ringSeq.add(rank);
        int cnt = 0;
        for (Integer n : connectionSet) {
            List<Integer> vConnSeq = this.constructShareRing(treeMap, parentMap, n);
            if (connectionSet.size() == ++cnt) {
                Collections.reverse(vConnSeq);
            }
            ringSeq.addAll(vConnSeq);
        }
        return ringSeq;
    }

    Map<Integer, Pair<Integer, Integer>> constructRingMap(Map<Integer, List<Integer>> treeMap, Map<Integer, Integer> parentMap) {
        assert (parentMap.get(0) == -1);
        List<Integer> sharedRing = this.constructShareRing(treeMap, parentMap, 0);
        assert (sharedRing.size() == treeMap.size());
        LinkedHashMap<Integer, Pair<Integer, Integer>> ringMap = new LinkedHashMap<Integer, Pair<Integer, Integer>>(this.numWorkers);
        for (int r = 0; r < this.numWorkers; ++r) {
            int rPrev = (r + this.numWorkers - 1) % this.numWorkers;
            int rNext = (r + 1) % this.numWorkers;
            ringMap.put(sharedRing.get(r), (Pair<Integer, Integer>)new Pair((Object)sharedRing.get(rPrev), (Object)sharedRing.get(rNext)));
        }
        return ringMap;
    }
}

