/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.CVModelBuilder;
import hex.ModelBuilder;
import hex.tree.xgboost.XGBoost;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.remote.SteamExecutorStarter;
import java.io.IOException;
import org.apache.log4j.Logger;
import water.Job;
import water.Key;

public class XGBoostExternalCVModelBuilder
extends CVModelBuilder {
    private static final Logger LOG = Logger.getLogger(XGBoostExternalCVModelBuilder.class);
    private final SteamExecutorStarter _starter;
    private boolean _initialized;

    public XGBoostExternalCVModelBuilder(Job job, ModelBuilder<?, ?, ?>[] modelBuilders, int parallelization, SteamExecutorStarter starter) {
        super(job, modelBuilders, parallelization);
        this._starter = starter;
    }

    protected void prepare(ModelBuilder<?, ?, ?> m) {
        if (!this._initialized) {
            XGBoost xgb = (XGBoost)m;
            try {
                this.prepareCluster(xgb);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to prepare an external XGBoost cluster, individual CV models will attempt to start the cluster again.", (Throwable)e);
            }
            this._initialized = true;
        }
    }

    void prepareCluster(XGBoost xgb) {
        LOG.info((Object)("Requesting external cluster for model " + xgb.dest()));
        try {
            this._starter.startCluster((Key<XGBoostModel>)xgb.dest(), (Job<XGBoostModel>)this.getJob());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to start external XGBoost cluster", e);
        }
        LOG.info((Object)"External cluster successfully initialized");
    }
}

