/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.gbm.GBTree;
import biz.k11i.xgboost.gbm.GradBooster;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeNode;
import hex.DataInfo;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XGBoostModelInfo;
import hex.tree.xgboost.XGBoostOutput;
import hex.tree.xgboost.predict.PredictorFactory;
import hex.tree.xgboost.predict.XGBoostBigScorePredict;
import hex.tree.xgboost.predict.XGBoostJavaBigScoreChunkPredict;
import hex.tree.xgboost.predict.XGBoostPredict;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class XGBoostJavaBigScorePredict
implements XGBoostBigScorePredict {
    private final DataInfo _di;
    private final XGBoostOutput _output;
    private final XGBoostModel.XGBoostParameters _parms;
    private final double _threshold;
    private final Predictor _predictor;
    private final boolean[] _usedColumns;

    public XGBoostJavaBigScorePredict(XGBoostModelInfo model_info, XGBoostOutput output, DataInfo di, XGBoostModel.XGBoostParameters parms, double threshold) {
        this._di = di;
        this._output = output;
        this._parms = parms;
        this._threshold = threshold;
        this._predictor = PredictorFactory.makePredictor(model_info._boosterBytes);
        this._usedColumns = XGBoostJavaBigScorePredict.findUsedColumns(this._predictor.getBooster(), di, this._output.nfeatures());
    }

    @Override
    public XGBoostPredict initMap(Frame fr, Chunk[] chks) {
        return new XGBoostJavaBigScoreChunkPredict(this._di, this._output, this._parms, this._threshold, this._predictor, this._usedColumns, fr);
    }

    static boolean[] findUsedColumns(GradBooster booster, DataInfo di, int nFeatures) {
        if (!(booster instanceof GBTree)) {
            return null;
        }
        int[] splitIndexToColumnIndex = di.coefOriginalColumnIndices();
        assert (ArrayUtils.maxValue((int[])splitIndexToColumnIndex) < nFeatures);
        boolean[] usedColumns = new boolean[nFeatures];
        int usedCount = 0;
        RegTree[][] regTreeArray = ((GBTree)booster).getGroupedTrees();
        int n = regTreeArray.length;
        for (int i = 0; i < n; ++i) {
            RegTree[] trees;
            for (RegTree tree : trees = regTreeArray[i]) {
                for (RegTreeNode node : tree.getNodes()) {
                    int column;
                    if (node.isLeaf() || usedColumns[column = splitIndexToColumnIndex[node.getSplitIndex()]]) continue;
                    usedColumns[column] = true;
                    if (splitIndexToColumnIndex.length != ++usedCount) continue;
                    return null;
                }
            }
        }
        return usedColumns;
    }
}

