/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.task;

import ai.h2o.xgboost4j.java.Booster;
import hex.tree.xgboost.EvalMetric;
import hex.tree.xgboost.task.AbstractXGBoostTask;
import hex.tree.xgboost.task.XGBoostSetupTask;
import hex.tree.xgboost.task.XGBoostUpdater;
import org.apache.log4j.Logger;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.RPC;

public class XGBoostUpdateTask
extends AbstractXGBoostTask<XGBoostUpdateTask> {
    private static final Logger LOG = Logger.getLogger(XGBoostUpdateTask.class);
    private final int _tid;

    public XGBoostUpdateTask(XGBoostSetupTask setupTask, int tid) {
        super(setupTask);
        this._tid = tid;
    }

    @Override
    protected void execute() {
        Booster booster = XGBoostUpdater.getUpdater(this._modelKey).doUpdate(this._tid);
        if (booster == null) {
            throw new IllegalStateException("Boosting iteration didn't produce a valid Booster.");
        }
    }

    public byte[] getBoosterBytes() {
        byte[] boosterBytes;
        H2ONode boosterNode = this.getBoosterNode();
        if (H2O.SELF.equals((Object)boosterNode)) {
            boosterBytes = XGBoostUpdater.getUpdater(this._modelKey).getBoosterBytes();
        } else {
            LOG.debug((Object)("Booster will be retrieved from a remote node, node=" + boosterNode));
            FetchBoosterTask t = new FetchBoosterTask(this._modelKey);
            boosterBytes = ((FetchBoosterTask)new RPC(boosterNode, (DTask)t).call().get())._boosterBytes;
        }
        return boosterBytes;
    }

    public EvalMetric getEvalMetric() {
        EvalMetric evalMetric;
        H2ONode boosterNode = this.getBoosterNode();
        if (H2O.SELF.equals((Object)boosterNode)) {
            evalMetric = XGBoostUpdater.getUpdater(this._modelKey).getEvalMetric();
        } else {
            LOG.debug((Object)("CustomMetric will be retrieved from a remote node, node=" + boosterNode));
            FetchEvalMetricTask t = new FetchEvalMetricTask(this._modelKey);
            evalMetric = ((FetchEvalMetricTask)new RPC(boosterNode, (DTask)t).call().get())._evalMetric;
        }
        return evalMetric;
    }

    private static class FetchEvalMetricTask
    extends DTask<FetchEvalMetricTask> {
        private final Key _modelKey;
        private EvalMetric _evalMetric;

        private FetchEvalMetricTask(Key modelKey) {
            this._modelKey = modelKey;
        }

        public void compute2() {
            this._evalMetric = XGBoostUpdater.getUpdater(this._modelKey).getEvalMetric();
            this.tryComplete();
        }
    }

    private static class FetchBoosterTask
    extends DTask<FetchBoosterTask> {
        private final Key _modelKey;
        private byte[] _boosterBytes;

        private FetchBoosterTask(Key modelKey) {
            this._modelKey = modelKey;
        }

        public void compute2() {
            this._boosterBytes = XGBoostUpdater.getUpdater(this._modelKey).getBoosterBytes();
            this.tryComplete();
        }
    }
}

