/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.remote;

import hex.genmodel.utils.IOUtils;
import hex.schemas.XGBoostExecRespV3;
import hex.tree.xgboost.matrix.RemoteMatrixLoader;
import hex.tree.xgboost.matrix.SparseMatrixDimensions;
import hex.tree.xgboost.task.XGBoostUploadMatrixTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.BootstrapFreezable;
import water.H2O;
import water.Key;
import water.TypeMap;
import water.server.ServletUtils;

public class RemoteXGBoostUploadServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(RemoteXGBoostUploadServlet.class);

    public static File getUploadDir(String key) {
        return new File(H2O.ICE_ROOT.toString(), key);
    }

    public static File getCheckpointFile(String key) {
        File uploadDir = RemoteXGBoostUploadServlet.getUploadDir(key);
        if (uploadDir.mkdirs()) {
            LOG.debug((Object)("Created temporary directory " + uploadDir));
        }
        return new File(RemoteXGBoostUploadServlet.getUploadDir(key), "checkpoint.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri((HttpServletRequest)request);
        try {
            String modelKey = request.getParameter("model_key");
            String requestType = request.getParameter("request_type");
            LOG.info((Object)("Upload request for " + modelKey + " " + requestType + " received"));
            RequestType type = RequestType.valueOf(requestType);
            if (type == RequestType.checkpoint) {
                File destFile = RemoteXGBoostUploadServlet.getCheckpointFile(modelKey);
                this.saveIntoFile(destFile, request);
            } else if (type == RequestType.matrixTrain || type == RequestType.matrixValid) {
                Key key = Key.make((String)modelKey);
                MatrixRequestType matrixRequestType = MatrixRequestType.valueOf(request.getParameter("data_type"));
                String matrixKey = type == RequestType.matrixTrain ? RemoteMatrixLoader.trainMatrixKey(key) : RemoteMatrixLoader.validMatrixKey(key);
                this.handleMatrixRequest(matrixKey, matrixRequestType, request);
            }
            response.setContentType("application/json");
            response.getWriter().write(new XGBoostExecRespV3(Key.make((String)modelKey)).toJsonString());
        }
        catch (Exception e) {
            ServletUtils.sendErrorResponse((HttpServletResponse)response, (Exception)e, (String)uri);
        }
        finally {
            ServletUtils.logRequest((String)"POST", (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private void handleMatrixRequest(String matrixKey, MatrixRequestType type, HttpServletRequest request) throws IOException {
        BootstrapFreezable requestData;
        try (AutoBuffer ab = new AutoBuffer((InputStream)request.getInputStream(), TypeMap.bootstrapClasses());){
            requestData = (BootstrapFreezable)ab.get();
        }
        switch (type) {
            case sparseMatrixDimensions: {
                RemoteMatrixLoader.initSparse(matrixKey, (SparseMatrixDimensions)requestData);
                break;
            }
            case sparseMatrixChunk: {
                RemoteMatrixLoader.sparseChunk(matrixKey, (XGBoostUploadMatrixTask.SparseMatrixChunk)requestData);
                break;
            }
            case denseMatrixDimensions: {
                RemoteMatrixLoader.initDense(matrixKey, (XGBoostUploadMatrixTask.DenseMatrixDimensions)requestData);
                break;
            }
            case denseMatrixChunk: {
                RemoteMatrixLoader.denseChunk(matrixKey, (XGBoostUploadMatrixTask.DenseMatrixChunk)requestData);
                break;
            }
            case matrixData: {
                RemoteMatrixLoader.matrixData(matrixKey, (XGBoostUploadMatrixTask.MatrixData)requestData);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type: " + (Object)((Object)type));
            }
        }
    }

    private void saveIntoFile(File destFile, HttpServletRequest request) throws IOException {
        LOG.debug((Object)("Saving contents into " + destFile));
        ServletInputStream is = request.getInputStream();
        try (FileOutputStream fos = new FileOutputStream(destFile);){
            IOUtils.copyStream((InputStream)is, (OutputStream)fos);
        }
    }

    public static enum MatrixRequestType {
        sparseMatrixDimensions,
        sparseMatrixChunk,
        denseMatrixDimensions,
        denseMatrixChunk,
        matrixData;

    }

    public static enum RequestType {
        checkpoint,
        matrixTrain,
        matrixValid;

    }
}

