/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.util;

import hex.tree.xgboost.util.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLibrary {
    private static final Log logger = LogFactory.getLog(NativeLibrary.class);
    public static CompilationFlags[] EMPTY_COMPILATION_FLAGS = new CompilationFlags[0];
    private final String name;
    private final ClassLoader classLoader;
    private final Platform platform;
    private final CompilationFlags[] flags;
    private boolean loaded = false;

    static NativeLibrary nativeLibrary(String name, CompilationFlags[] flags) {
        return new NativeLibrary(name, flags);
    }

    static NativeLibrary nativeLibrary(String name, CompilationFlags[] flags, ClassLoader classLoader) {
        return new NativeLibrary(name, flags, classLoader);
    }

    private NativeLibrary(String name, CompilationFlags[] flags) {
        this(name, flags, NativeLibrary.class.getClassLoader());
    }

    private NativeLibrary(String name, CompilationFlags[] flags, ClassLoader classLoader) {
        this.name = name;
        this.classLoader = classLoader;
        this.platform = Platform.geOSType();
        this.flags = flags;
    }

    synchronized boolean load() throws IOException {
        if (!this.loaded) {
            this.loaded = this.doLoad();
        }
        return this.loaded;
    }

    private boolean doLoad() throws IOException {
        String libName = this.getName();
        try {
            System.loadLibrary(libName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            try {
                return this.extractAndLoad(this.getPlatformLibraryPath());
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failed to load library from both native path and jar!");
                throw ioe;
            }
        }
    }

    private String getPlatformLibraryPath() {
        return String.format("%s/%s/%s", this.getResourcePrefix(), this.platform.getPlatform(), this.platform.getPlatformLibName(this.getName()));
    }

    private String getResourcePrefix() {
        return "lib";
    }

    private ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private boolean extractAndLoad(String libPath) throws IOException {
        try {
            URL libResource = NativeLibrary.getLibResource(libPath, this.getClassLoader());
            if (libResource == null) {
                logger.debug((Object)("We don't bundle library " + libPath));
                return false;
            }
            File temp = NativeLibrary.extract(libPath, libResource);
            System.load(temp.getAbsolutePath());
            logger.info((Object)("Loaded library from " + libPath + " (" + temp.getAbsolutePath() + ")"));
            return true;
        }
        catch (IOException | UnsatisfiedLinkError e) {
            logger.warn((Object)("Cannot load library from path " + libPath));
            throw new IOException(e);
        }
    }

    private URL getLibResource() {
        return NativeLibrary.getLibResource(this.getPlatformLibraryPath(), this.getClassLoader());
    }

    public boolean isBundled() {
        return this.getLibResource() != null;
    }

    public File extractTo(File directory) throws IOException {
        File target = new File(directory, this.platform.getPlatformLibName(this.getName()));
        NativeLibrary.extractTo(this.getLibResource(), target);
        return target;
    }

    private static void extractTo(URL libResource, File target) throws IOException {
        try (InputStream is = libResource.openStream();){
            Files.copy(is, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static URL getLibResource(String libPath, ClassLoader classLoader) {
        return classLoader.getResource(libPath);
    }

    private static File extract(String libPath, URL libResource) throws IOException, IllegalArgumentException {
        assert (libResource != null) : "Argument `libResource` cannot be null, make sure you only call `extract` for libraries that are available for the current platform.";
        String filename = libPath.substring(libPath.lastIndexOf(47) + 1);
        int lastDotIdx = filename.lastIndexOf(46);
        String prefix = "";
        String suffix = null;
        if (lastDotIdx >= 0 && lastDotIdx < filename.length() - 1) {
            prefix = filename.substring(0, lastDotIdx);
            suffix = filename.substring(lastDotIdx);
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        NativeLibrary.extractTo(libResource, temp);
        return temp;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasCompilationFlag(CompilationFlags flag) {
        for (CompilationFlags f : this.getCompilationFlags()) {
            if (flag != f) continue;
            return true;
        }
        return false;
    }

    public CompilationFlags[] getCompilationFlags() {
        return this.flags;
    }

    public String toString() {
        return String.format("%s (%s)", this.getName(), this.getPlatformLibraryPath());
    }

    public static enum CompilationFlags {
        WITH_GPU,
        WITH_OMP;

    }
}

