/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.DataInfo;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.predict.AuxNodeWeights;
import java.util.Arrays;
import water.Iced;
import water.Key;

public final class XGBoostModelInfo
extends Iced {
    public final XGBoostModel.XGBoostParameters _parameters;
    private final Key<DataInfo> _dataInfoKey;
    private final Key<AuxNodeWeights> _auxNodeWeightsKey;
    public String _featureMap;
    public byte[] _boosterBytes;

    public XGBoostModelInfo(XGBoostModel.XGBoostParameters origParams, DataInfo dinfo) {
        this._parameters = (XGBoostModel.XGBoostParameters)origParams.clone();
        this._dataInfoKey = dinfo._key;
        this._auxNodeWeightsKey = Key.make();
    }

    public String getFeatureMap() {
        return this._featureMap;
    }

    public void setFeatureMap(String featureMap) {
        this._featureMap = featureMap;
    }

    public void updateBoosterBytes(byte[] boosterBytes) {
        if (boosterBytes != null) {
            this._boosterBytes = boosterBytes;
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this._boosterBytes);
    }

    public long size() {
        long res = 0L;
        if (this._boosterBytes != null) {
            res += (long)this._boosterBytes.length;
        }
        return res;
    }

    public Key<DataInfo> getDataInfoKey() {
        return this._dataInfoKey;
    }

    public DataInfo dataInfo() {
        return (DataInfo)this._dataInfoKey.get();
    }

    public DataInfo scoringInfo(boolean isTrain) {
        return isTrain ? this.dataInfo() : this.dataInfo().scoringInfo();
    }

    public Key<AuxNodeWeights> getAuxNodeWeightsKey() {
        return this._auxNodeWeightsKey;
    }

    public AuxNodeWeights auxNodeWeights() {
        return (AuxNodeWeights)this._auxNodeWeightsKey.get();
    }

    public byte[] auxNodeWeightBytes() {
        AuxNodeWeights anw = (AuxNodeWeights)this._auxNodeWeightsKey.get();
        return anw != null ? anw._nodeWeightBytes : null;
    }
}

