/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.xgboost4j.java;

import ai.h2o.xgboost4j.java.Booster;
import ai.h2o.xgboost4j.java.DMatrix;
import ai.h2o.xgboost4j.java.XGBoostError;
import hex.tree.xgboost.util.BoosterHelper;
import java.util.Map;

public class BoosterWrapper {
    private final Booster booster;

    public BoosterWrapper(byte[] checkpointBoosterBytes, Map<String, Object> params, DMatrix train, DMatrix valid) throws XGBoostError {
        if (checkpointBoosterBytes != null) {
            this.booster = BoosterHelper.loadModel(checkpointBoosterBytes);
            this.booster.setParams(params);
        } else {
            DMatrix[] dMatrixArray;
            if (valid == null) {
                DMatrix[] dMatrixArray2 = new DMatrix[1];
                dMatrixArray = dMatrixArray2;
                dMatrixArray2[0] = train;
            } else {
                DMatrix[] dMatrixArray3 = new DMatrix[2];
                dMatrixArray3[0] = train;
                dMatrixArray = dMatrixArray3;
                dMatrixArray3[1] = valid;
            }
            DMatrix[] cacheMats = dMatrixArray;
            this.booster = Booster.newBooster(params, (DMatrix[])cacheMats);
            this.booster.loadRabitCheckpoint();
        }
        this.booster.saveRabitCheckpoint();
    }

    public void update(DMatrix dtrain, int iter) throws XGBoostError {
        this.booster.update(dtrain, iter);
    }

    public String evalSet(DMatrix dtrain, DMatrix dvalid, int iter) throws XGBoostError {
        if (dvalid == null) {
            return this.booster.evalSet(new DMatrix[]{dtrain}, new String[]{"train"}, iter);
        }
        return this.booster.evalSet(new DMatrix[]{dtrain, dvalid}, new String[]{"train", "valid"}, iter);
    }

    public void saveRabitCheckpoint() throws XGBoostError {
        this.booster.saveRabitCheckpoint();
    }

    public byte[] toByteArray() throws XGBoostError {
        return this.booster.toByteArray();
    }

    public void dispose() {
        this.booster.dispose();
    }

    public Booster getBooster() {
        return this.booster;
    }
}

